globals
constant real bj_PI=3.14159
constant real bj_E=2.71828
constant real bj_CELLWIDTH=128.0
constant real bj_CLIFFHEIGHT=128.0
constant real bj_UNIT_FACING=270.0
constant real bj_RADTODEG=180.0/bj_PI
constant real bj_DEGTORAD=bj_PI/180.0
constant real bj_TEXT_DELAY_QUEST=20.00
constant real bj_TEXT_DELAY_QUESTUPDATE=20.00
constant real bj_TEXT_DELAY_QUESTDONE=20.00
constant real bj_TEXT_DELAY_QUESTFAILED=20.00
constant real bj_TEXT_DELAY_QUESTREQUIREMENT=20.00
constant real bj_TEXT_DELAY_MISSIONFAILED=20.00
constant real bj_TEXT_DELAY_ALWAYSHINT=12.00
constant real bj_TEXT_DELAY_HINT=12.00
constant real bj_TEXT_DELAY_SECRET=10.00
constant real bj_TEXT_DELAY_UNITACQUIRED=15.00
constant real bj_TEXT_DELAY_UNITAVAILABLE=10.00
constant real bj_TEXT_DELAY_ITEMACQUIRED=10.00
constant real bj_TEXT_DELAY_WARNING=12.00
constant real bj_QUEUE_DELAY_QUEST=5.00
constant real bj_QUEUE_DELAY_HINT=5.00
constant real bj_QUEUE_DELAY_SECRET=3.00
constant real bj_HANDICAP_EASY=60.00
constant real bj_GAME_STARTED_THRESHOLD=0.01
constant real bj_WAIT_FOR_COND_MIN_INTERVAL=0.10
constant real bj_POLLED_WAIT_INTERVAL=0.10
constant real bj_POLLED_WAIT_SKIP_THRESHOLD=2.00
constant integer bj_MAX_INVENTORY=6
constant integer bj_MAX_PLAYERS=12
constant integer bj_PLAYER_NEUTRAL_VICTIM=13
constant integer bj_PLAYER_NEUTRAL_EXTRA=14
constant integer bj_MAX_PLAYER_SLOTS=16
constant integer bj_MAX_SKELETONS=25
constant integer bj_MAX_STOCK_ITEM_SLOTS=11
constant integer bj_MAX_STOCK_UNIT_SLOTS=11
constant integer bj_MAX_ITEM_LEVEL=10
constant real bj_TOD_DAWN=6.00
constant real bj_TOD_DUSK=18.00
constant real bj_MELEE_STARTING_TOD=8.00
constant integer bj_MELEE_STARTING_GOLD_V0=750
constant integer bj_MELEE_STARTING_GOLD_V1=500
constant integer bj_MELEE_STARTING_LUMBER_V0=200
constant integer bj_MELEE_STARTING_LUMBER_V1=150
constant integer bj_MELEE_STARTING_HERO_TOKENS=1
constant integer bj_MELEE_HERO_LIMIT=3
constant integer bj_MELEE_HERO_TYPE_LIMIT=1
constant real bj_MELEE_MINE_SEARCH_RADIUS=2000
constant real bj_MELEE_CLEAR_UNITS_RADIUS=1500
constant real bj_MELEE_CRIPPLE_TIMEOUT=120.00
constant real bj_MELEE_CRIPPLE_MSG_DURATION=20.00
constant integer bj_MELEE_MAX_TWINKED_HEROES_V0=3
constant integer bj_MELEE_MAX_TWINKED_HEROES_V1=1
constant real bj_CREEP_ITEM_DELAY=0.50
constant real bj_STOCK_RESTOCK_INITIAL_DELAY=120
constant real bj_STOCK_RESTOCK_INTERVAL=30
constant integer bj_STOCK_MAX_ITERATIONS=20
constant integer bj_MAX_DEST_IN_REGION_EVENTS=64
constant integer bj_CAMERA_MIN_FARZ=100
constant integer bj_CAMERA_DEFAULT_DISTANCE=1650
constant integer bj_CAMERA_DEFAULT_FARZ=5000
constant integer bj_CAMERA_DEFAULT_AOA=304
constant integer bj_CAMERA_DEFAULT_FOV=70
constant integer bj_CAMERA_DEFAULT_ROLL=0
constant integer bj_CAMERA_DEFAULT_ROTATION=90
constant real bj_RESCUE_PING_TIME=2.00
constant real bj_NOTHING_SOUND_DURATION=5.00
constant real bj_TRANSMISSION_PING_TIME=1.00
constant integer bj_TRANSMISSION_IND_RED=255
constant integer bj_TRANSMISSION_IND_BLUE=255
constant integer bj_TRANSMISSION_IND_GREEN=255
constant integer bj_TRANSMISSION_IND_ALPHA=255
constant real bj_TRANSMISSION_PORT_HANGTIME=1.50
constant real bj_CINEMODE_INTERFACEFADE=0.50
constant gamespeed bj_CINEMODE_GAMESPEED=MAP_SPEED_NORMAL
constant real bj_CINEMODE_VOLUME_UNITMOVEMENT=0.40
constant real bj_CINEMODE_VOLUME_UNITSOUNDS=0.00
constant real bj_CINEMODE_VOLUME_COMBAT=0.40
constant real bj_CINEMODE_VOLUME_SPELLS=0.40
constant real bj_CINEMODE_VOLUME_UI=0.00
constant real bj_CINEMODE_VOLUME_MUSIC=0.55
constant real bj_CINEMODE_VOLUME_AMBIENTSOUNDS=1.00
constant real bj_CINEMODE_VOLUME_FIRE=0.60
constant real bj_SPEECH_VOLUME_UNITMOVEMENT=0.25
constant real bj_SPEECH_VOLUME_UNITSOUNDS=0.00
constant real bj_SPEECH_VOLUME_COMBAT=0.25
constant real bj_SPEECH_VOLUME_SPELLS=0.25
constant real bj_SPEECH_VOLUME_UI=0.00
constant real bj_SPEECH_VOLUME_MUSIC=0.55
constant real bj_SPEECH_VOLUME_AMBIENTSOUNDS=1.00
constant real bj_SPEECH_VOLUME_FIRE=0.60
constant real bj_SMARTPAN_TRESHOLD_PAN=500
constant real bj_SMARTPAN_TRESHOLD_SNAP=3500
constant integer bj_MAX_QUEUED_TRIGGERS=100
constant real bj_QUEUED_TRIGGER_TIMEOUT=180.00
constant integer bj_CAMPAIGN_INDEX_T=0
constant integer bj_CAMPAIGN_INDEX_H=1
constant integer bj_CAMPAIGN_INDEX_U=2
constant integer bj_CAMPAIGN_INDEX_O=3
constant integer bj_CAMPAIGN_INDEX_N=4
constant integer bj_CAMPAIGN_INDEX_XN=5
constant integer bj_CAMPAIGN_INDEX_XH=6
constant integer bj_CAMPAIGN_INDEX_XU=7
constant integer bj_CAMPAIGN_INDEX_XO=8
constant integer bj_CAMPAIGN_OFFSET_T=0
constant integer bj_CAMPAIGN_OFFSET_H=1
constant integer bj_CAMPAIGN_OFFSET_U=2
constant integer bj_CAMPAIGN_OFFSET_O=3
constant integer bj_CAMPAIGN_OFFSET_N=4
constant integer bj_CAMPAIGN_OFFSET_XN=0
constant integer bj_CAMPAIGN_OFFSET_XH=1
constant integer bj_CAMPAIGN_OFFSET_XU=2
constant integer bj_CAMPAIGN_OFFSET_XO=3
constant integer bj_MISSION_INDEX_T00=bj_CAMPAIGN_OFFSET_T*1000+0
constant integer bj_MISSION_INDEX_T01=bj_CAMPAIGN_OFFSET_T*1000+1
constant integer bj_MISSION_INDEX_H00=bj_CAMPAIGN_OFFSET_H*1000+0
constant integer bj_MISSION_INDEX_H01=bj_CAMPAIGN_OFFSET_H*1000+1
constant integer bj_MISSION_INDEX_H02=bj_CAMPAIGN_OFFSET_H*1000+2
constant integer bj_MISSION_INDEX_H03=bj_CAMPAIGN_OFFSET_H*1000+3
constant integer bj_MISSION_INDEX_H04=bj_CAMPAIGN_OFFSET_H*1000+4
constant integer bj_MISSION_INDEX_H05=bj_CAMPAIGN_OFFSET_H*1000+5
constant integer bj_MISSION_INDEX_H06=bj_CAMPAIGN_OFFSET_H*1000+6
constant integer bj_MISSION_INDEX_H07=bj_CAMPAIGN_OFFSET_H*1000+7
constant integer bj_MISSION_INDEX_H08=bj_CAMPAIGN_OFFSET_H*1000+8
constant integer bj_MISSION_INDEX_H09=bj_CAMPAIGN_OFFSET_H*1000+9
constant integer bj_MISSION_INDEX_H10=bj_CAMPAIGN_OFFSET_H*1000+10
constant integer bj_MISSION_INDEX_H11=bj_CAMPAIGN_OFFSET_H*1000+11
constant integer bj_MISSION_INDEX_U00=bj_CAMPAIGN_OFFSET_U*1000+0
constant integer bj_MISSION_INDEX_U01=bj_CAMPAIGN_OFFSET_U*1000+1
constant integer bj_MISSION_INDEX_U02=bj_CAMPAIGN_OFFSET_U*1000+2
constant integer bj_MISSION_INDEX_U03=bj_CAMPAIGN_OFFSET_U*1000+3
constant integer bj_MISSION_INDEX_U05=bj_CAMPAIGN_OFFSET_U*1000+4
constant integer bj_MISSION_INDEX_U07=bj_CAMPAIGN_OFFSET_U*1000+5
constant integer bj_MISSION_INDEX_U08=bj_CAMPAIGN_OFFSET_U*1000+6
constant integer bj_MISSION_INDEX_U09=bj_CAMPAIGN_OFFSET_U*1000+7
constant integer bj_MISSION_INDEX_U10=bj_CAMPAIGN_OFFSET_U*1000+8
constant integer bj_MISSION_INDEX_U11=bj_CAMPAIGN_OFFSET_U*1000+9
constant integer bj_MISSION_INDEX_O00=bj_CAMPAIGN_OFFSET_O*1000+0
constant integer bj_MISSION_INDEX_O01=bj_CAMPAIGN_OFFSET_O*1000+1
constant integer bj_MISSION_INDEX_O02=bj_CAMPAIGN_OFFSET_O*1000+2
constant integer bj_MISSION_INDEX_O03=bj_CAMPAIGN_OFFSET_O*1000+3
constant integer bj_MISSION_INDEX_O04=bj_CAMPAIGN_OFFSET_O*1000+4
constant integer bj_MISSION_INDEX_O05=bj_CAMPAIGN_OFFSET_O*1000+5
constant integer bj_MISSION_INDEX_O06=bj_CAMPAIGN_OFFSET_O*1000+6
constant integer bj_MISSION_INDEX_O07=bj_CAMPAIGN_OFFSET_O*1000+7
constant integer bj_MISSION_INDEX_O08=bj_CAMPAIGN_OFFSET_O*1000+8
constant integer bj_MISSION_INDEX_O09=bj_CAMPAIGN_OFFSET_O*1000+9
constant integer bj_MISSION_INDEX_O10=bj_CAMPAIGN_OFFSET_O*1000+10
constant integer bj_MISSION_INDEX_N00=bj_CAMPAIGN_OFFSET_N*1000+0
constant integer bj_MISSION_INDEX_N01=bj_CAMPAIGN_OFFSET_N*1000+1
constant integer bj_MISSION_INDEX_N02=bj_CAMPAIGN_OFFSET_N*1000+2
constant integer bj_MISSION_INDEX_N03=bj_CAMPAIGN_OFFSET_N*1000+3
constant integer bj_MISSION_INDEX_N04=bj_CAMPAIGN_OFFSET_N*1000+4
constant integer bj_MISSION_INDEX_N05=bj_CAMPAIGN_OFFSET_N*1000+5
constant integer bj_MISSION_INDEX_N06=bj_CAMPAIGN_OFFSET_N*1000+6
constant integer bj_MISSION_INDEX_N07=bj_CAMPAIGN_OFFSET_N*1000+7
constant integer bj_MISSION_INDEX_N08=bj_CAMPAIGN_OFFSET_N*1000+8
constant integer bj_MISSION_INDEX_N09=bj_CAMPAIGN_OFFSET_N*1000+9
constant integer bj_MISSION_INDEX_XN00=bj_CAMPAIGN_OFFSET_XN*1000+0
constant integer bj_MISSION_INDEX_XN01=bj_CAMPAIGN_OFFSET_XN*1000+1
constant integer bj_MISSION_INDEX_XN02=bj_CAMPAIGN_OFFSET_XN*1000+2
constant integer bj_MISSION_INDEX_XN03=bj_CAMPAIGN_OFFSET_XN*1000+3
constant integer bj_MISSION_INDEX_XN04=bj_CAMPAIGN_OFFSET_XN*1000+4
constant integer bj_MISSION_INDEX_XN05=bj_CAMPAIGN_OFFSET_XN*1000+5
constant integer bj_MISSION_INDEX_XN06=bj_CAMPAIGN_OFFSET_XN*1000+6
constant integer bj_MISSION_INDEX_XN07=bj_CAMPAIGN_OFFSET_XN*1000+7
constant integer bj_MISSION_INDEX_XN08=bj_CAMPAIGN_OFFSET_XN*1000+8
constant integer bj_MISSION_INDEX_XN09=bj_CAMPAIGN_OFFSET_XN*1000+9
constant integer bj_MISSION_INDEX_XN10=bj_CAMPAIGN_OFFSET_XN*1000+10
constant integer bj_MISSION_INDEX_XH00=bj_CAMPAIGN_OFFSET_XH*1000+0
constant integer bj_MISSION_INDEX_XH01=bj_CAMPAIGN_OFFSET_XH*1000+1
constant integer bj_MISSION_INDEX_XH02=bj_CAMPAIGN_OFFSET_XH*1000+2
constant integer bj_MISSION_INDEX_XH03=bj_CAMPAIGN_OFFSET_XH*1000+3
constant integer bj_MISSION_INDEX_XH04=bj_CAMPAIGN_OFFSET_XH*1000+4
constant integer bj_MISSION_INDEX_XH05=bj_CAMPAIGN_OFFSET_XH*1000+5
constant integer bj_MISSION_INDEX_XH06=bj_CAMPAIGN_OFFSET_XH*1000+6
constant integer bj_MISSION_INDEX_XH07=bj_CAMPAIGN_OFFSET_XH*1000+7
constant integer bj_MISSION_INDEX_XH08=bj_CAMPAIGN_OFFSET_XH*1000+8
constant integer bj_MISSION_INDEX_XH09=bj_CAMPAIGN_OFFSET_XH*1000+9
constant integer bj_MISSION_INDEX_XU00=bj_CAMPAIGN_OFFSET_XU*1000+0
constant integer bj_MISSION_INDEX_XU01=bj_CAMPAIGN_OFFSET_XU*1000+1
constant integer bj_MISSION_INDEX_XU02=bj_CAMPAIGN_OFFSET_XU*1000+2
constant integer bj_MISSION_INDEX_XU03=bj_CAMPAIGN_OFFSET_XU*1000+3
constant integer bj_MISSION_INDEX_XU04=bj_CAMPAIGN_OFFSET_XU*1000+4
constant integer bj_MISSION_INDEX_XU05=bj_CAMPAIGN_OFFSET_XU*1000+5
constant integer bj_MISSION_INDEX_XU06=bj_CAMPAIGN_OFFSET_XU*1000+6
constant integer bj_MISSION_INDEX_XU07=bj_CAMPAIGN_OFFSET_XU*1000+7
constant integer bj_MISSION_INDEX_XU08=bj_CAMPAIGN_OFFSET_XU*1000+8
constant integer bj_MISSION_INDEX_XU09=bj_CAMPAIGN_OFFSET_XU*1000+9
constant integer bj_MISSION_INDEX_XU10=bj_CAMPAIGN_OFFSET_XU*1000+10
constant integer bj_MISSION_INDEX_XU11=bj_CAMPAIGN_OFFSET_XU*1000+11
constant integer bj_MISSION_INDEX_XU12=bj_CAMPAIGN_OFFSET_XU*1000+12
constant integer bj_MISSION_INDEX_XU13=bj_CAMPAIGN_OFFSET_XU*1000+13
constant integer bj_MISSION_INDEX_XO00=bj_CAMPAIGN_OFFSET_XO*1000+0
constant integer bj_CINEMATICINDEX_TOP=0
constant integer bj_CINEMATICINDEX_HOP=1
constant integer bj_CINEMATICINDEX_HED=2
constant integer bj_CINEMATICINDEX_OOP=3
constant integer bj_CINEMATICINDEX_OED=4
constant integer bj_CINEMATICINDEX_UOP=5
constant integer bj_CINEMATICINDEX_UED=6
constant integer bj_CINEMATICINDEX_NOP=7
constant integer bj_CINEMATICINDEX_NED=8
constant integer bj_CINEMATICINDEX_XOP=9
constant integer bj_CINEMATICINDEX_XED=10
constant integer bj_ALLIANCE_UNALLIED=0
constant integer bj_ALLIANCE_UNALLIED_VISION=1
constant integer bj_ALLIANCE_ALLIED=2
constant integer bj_ALLIANCE_ALLIED_VISION=3
constant integer bj_ALLIANCE_ALLIED_UNITS=4
constant integer bj_ALLIANCE_ALLIED_ADVUNITS=5
constant integer bj_ALLIANCE_NEUTRAL=6
constant integer bj_ALLIANCE_NEUTRAL_VISION=7
constant integer bj_KEYEVENTTYPE_DEPRESS=0
constant integer bj_KEYEVENTTYPE_RELEASE=1
constant integer bj_KEYEVENTKEY_LEFT=0
constant integer bj_KEYEVENTKEY_RIGHT=1
constant integer bj_KEYEVENTKEY_DOWN=2
constant integer bj_KEYEVENTKEY_UP=3
constant integer bj_TIMETYPE_ADD=0
constant integer bj_TIMETYPE_SET=1
constant integer bj_TIMETYPE_SUB=2
constant integer bj_CAMERABOUNDS_ADJUST_ADD=0
constant integer bj_CAMERABOUNDS_ADJUST_SUB=1
constant integer bj_QUESTTYPE_REQ_DISCOVERED=0
constant integer bj_QUESTTYPE_REQ_UNDISCOVERED=1
constant integer bj_QUESTTYPE_OPT_DISCOVERED=2
constant integer bj_QUESTTYPE_OPT_UNDISCOVERED=3
constant integer bj_QUESTMESSAGE_DISCOVERED=0
constant integer bj_QUESTMESSAGE_UPDATED=1
constant integer bj_QUESTMESSAGE_COMPLETED=2
constant integer bj_QUESTMESSAGE_FAILED=3
constant integer bj_QUESTMESSAGE_REQUIREMENT=4
constant integer bj_QUESTMESSAGE_MISSIONFAILED=5
constant integer bj_QUESTMESSAGE_ALWAYSHINT=6
constant integer bj_QUESTMESSAGE_HINT=7
constant integer bj_QUESTMESSAGE_SECRET=8
constant integer bj_QUESTMESSAGE_UNITACQUIRED=9
constant integer bj_QUESTMESSAGE_UNITAVAILABLE=10
constant integer bj_QUESTMESSAGE_ITEMACQUIRED=11
constant integer bj_QUESTMESSAGE_WARNING=12
constant integer bj_SORTTYPE_SORTBYVALUE=0
constant integer bj_SORTTYPE_SORTBYPLAYER=1
constant integer bj_SORTTYPE_SORTBYLABEL=2
constant integer bj_CINEFADETYPE_FADEIN=0
constant integer bj_CINEFADETYPE_FADEOUT=1
constant integer bj_CINEFADETYPE_FADEOUTIN=2
constant integer bj_REMOVEBUFFS_POSITIVE=0
constant integer bj_REMOVEBUFFS_NEGATIVE=1
constant integer bj_REMOVEBUFFS_ALL=2
constant integer bj_REMOVEBUFFS_NONTLIFE=3
constant integer bj_BUFF_POLARITY_POSITIVE=0
constant integer bj_BUFF_POLARITY_NEGATIVE=1
constant integer bj_BUFF_POLARITY_EITHER=2
constant integer bj_BUFF_RESIST_MAGIC=0
constant integer bj_BUFF_RESIST_PHYSICAL=1
constant integer bj_BUFF_RESIST_EITHER=2
constant integer bj_BUFF_RESIST_BOTH=3
constant integer bj_HEROSTAT_STR=0
constant integer bj_HEROSTAT_AGI=1
constant integer bj_HEROSTAT_INT=2
constant integer bj_MODIFYMETHOD_ADD=0
constant integer bj_MODIFYMETHOD_SUB=1
constant integer bj_MODIFYMETHOD_SET=2
constant integer bj_UNIT_STATE_METHOD_ABSOLUTE=0
constant integer bj_UNIT_STATE_METHOD_RELATIVE=1
constant integer bj_UNIT_STATE_METHOD_DEFAULTS=2
constant integer bj_UNIT_STATE_METHOD_MAXIMUM=3
constant integer bj_GATEOPERATION_CLOSE=0
constant integer bj_GATEOPERATION_OPEN=1
constant integer bj_GATEOPERATION_DESTROY=2
constant integer bj_GAMECACHE_BOOLEAN=0
constant integer bj_GAMECACHE_INTEGER=1
constant integer bj_GAMECACHE_REAL=2
constant integer bj_GAMECACHE_UNIT=3
constant integer bj_GAMECACHE_STRING=4
constant integer bj_ITEM_STATUS_HIDDEN=0
constant integer bj_ITEM_STATUS_OWNED=1
constant integer bj_ITEM_STATUS_INVULNERABLE=2
constant integer bj_ITEM_STATUS_POWERUP=3
constant integer bj_ITEM_STATUS_SELLABLE=4
constant integer bj_ITEM_STATUS_PAWNABLE=5
constant integer bj_ITEMCODE_STATUS_POWERUP=0
constant integer bj_ITEMCODE_STATUS_SELLABLE=1
constant integer bj_ITEMCODE_STATUS_PAWNABLE=2
constant integer bj_MINIMAPPINGSTYLE_SIMPLE=0
constant integer bj_MINIMAPPINGSTYLE_FLASHY=1
constant integer bj_MINIMAPPINGSTYLE_ATTACK=2
constant real bj_CORPSE_MAX_DEATH_TIME=8.00
constant integer bj_CORPSETYPE_FLESH=0
constant integer bj_CORPSETYPE_BONE=1
constant integer bj_ELEVATOR_BLOCKER_CODE='DTep'
constant integer bj_ELEVATOR_CODE01='DTrf'
constant integer bj_ELEVATOR_CODE02='DTrx'
constant integer bj_ELEVATOR_WALL_TYPE_ALL=0
constant integer bj_ELEVATOR_WALL_TYPE_EAST=1
constant integer bj_ELEVATOR_WALL_TYPE_NORTH=2
constant integer bj_ELEVATOR_WALL_TYPE_SOUTH=3
constant integer bj_ELEVATOR_WALL_TYPE_WEST=4
force bj_FORCE_ALL_PLAYERS=null
force array bj_FORCE_PLAYER
integer bj_MELEE_MAX_TWINKED_HEROES=0
rect bj_mapInitialPlayableArea=null
rect bj_mapInitialCameraBounds=null
integer bj_forLoopAIndex=0
integer bj_forLoopBIndex=0
integer bj_forLoopAIndexEnd=0
integer bj_forLoopBIndexEnd=0
boolean bj_slotControlReady=false
boolean array bj_slotControlUsed
mapcontrol array bj_slotControl
timer bj_gameStartedTimer=null
boolean bj_gameStarted=false
timer bj_volumeGroupsTimer=CreateTimer()
boolean bj_isSinglePlayer=false
trigger bj_dncSoundsDay=null
trigger bj_dncSoundsNight=null
sound bj_dayAmbientSound=null
sound bj_nightAmbientSound=null
trigger bj_dncSoundsDawn=null
trigger bj_dncSoundsDusk=null
sound bj_dawnSound=null
sound bj_duskSound=null
boolean bj_useDawnDuskSounds=true
boolean bj_dncIsDaytime=false
sound bj_rescueSound=null
sound bj_questDiscoveredSound=null
sound bj_questUpdatedSound=null
sound bj_questCompletedSound=null
sound bj_questFailedSound=null
sound bj_questHintSound=null
sound bj_questSecretSound=null
sound bj_questItemAcquiredSound=null
sound bj_questWarningSound=null
sound bj_victoryDialogSound=null
sound bj_defeatDialogSound=null
trigger bj_stockItemPurchased=null
timer bj_stockUpdateTimer=null
boolean array bj_stockAllowedPermanent
boolean array bj_stockAllowedCharged
boolean array bj_stockAllowedArtifact
integer bj_stockPickedItemLevel=0
itemtype bj_stockPickedItemType
trigger bj_meleeVisibilityTrained=null
boolean bj_meleeVisibilityIsDay=true
boolean bj_meleeGrantHeroItems=false
location bj_meleeNearestMineToLoc=null
unit bj_meleeNearestMine=null
real bj_meleeNearestMineDist=0.00
boolean bj_meleeGameOver=false
boolean array bj_meleeDefeated
boolean array bj_meleeVictoried
unit array bj_ghoul
timer array bj_crippledTimer
timerdialog array bj_crippledTimerWindows
boolean array bj_playerIsCrippled
boolean array bj_playerIsExposed
boolean bj_finishSoonAllExposed=false
timerdialog bj_finishSoonTimerDialog=null
integer array bj_meleeTwinkedHeroes
trigger bj_rescueUnitBehavior=null
boolean bj_rescueChangeColorUnit=true
boolean bj_rescueChangeColorBldg=true
timer bj_cineSceneEndingTimer=null
sound bj_cineSceneLastSound=null
trigger bj_cineSceneBeingSkipped=null
gamespeed bj_cineModePriorSpeed=MAP_SPEED_NORMAL
boolean bj_cineModePriorFogSetting=false
boolean bj_cineModePriorMaskSetting=false
boolean bj_cineModeAlreadyIn=false
boolean bj_cineModePriorDawnDusk=false
integer bj_cineModeSavedSeed=0
timer bj_cineFadeFinishTimer=null
timer bj_cineFadeContinueTimer=null
real bj_cineFadeContinueRed=0
real bj_cineFadeContinueGreen=0
real bj_cineFadeContinueBlue=0
real bj_cineFadeContinueTrans=0
real bj_cineFadeContinueDuration=0
string bj_cineFadeContinueTex=""
integer bj_queuedExecTotal=0
trigger array bj_queuedExecTriggers
boolean array bj_queuedExecUseConds
timer bj_queuedExecTimeoutTimer=CreateTimer()
trigger bj_queuedExecTimeout=null
integer bj_destInRegionDiesCount=0
trigger bj_destInRegionDiesTrig=null
integer bj_groupCountUnits=0
integer bj_forceCountPlayers=0
integer bj_groupEnumTypeId=0
player bj_groupEnumOwningPlayer=null
group bj_groupAddGroupDest=null
group bj_groupRemoveGroupDest=null
integer bj_groupRandomConsidered=0
unit bj_groupRandomCurrentPick=null
group bj_groupLastCreatedDest=null
group bj_randomSubGroupGroup=null
integer bj_randomSubGroupWant=0
integer bj_randomSubGroupTotal=0
real bj_randomSubGroupChance=0
integer bj_destRandomConsidered=0
destructable bj_destRandomCurrentPick=null
destructable bj_elevatorWallBlocker=null
destructable bj_elevatorNeighbor=null
integer bj_itemRandomConsidered=0
item bj_itemRandomCurrentPick=null
integer bj_forceRandomConsidered=0
player bj_forceRandomCurrentPick=null
unit bj_makeUnitRescuableUnit=null
boolean bj_makeUnitRescuableFlag=true
boolean bj_pauseAllUnitsFlag=true
location bj_enumDestructableCenter=null
real bj_enumDestructableRadius=0
playercolor bj_setPlayerTargetColor=null
boolean bj_isUnitGroupDeadResult=true
boolean bj_isUnitGroupEmptyResult=true
boolean bj_isUnitGroupInRectResult=true
rect bj_isUnitGroupInRectRect=null
boolean bj_changeLevelShowScores=false
string bj_changeLevelMapName=null
group bj_suspendDecayFleshGroup=CreateGroup()
group bj_suspendDecayBoneGroup=CreateGroup()
timer bj_delayedSuspendDecayTimer=CreateTimer()
trigger bj_delayedSuspendDecayTrig=null
integer bj_livingPlayerUnitsTypeId=0
widget bj_lastDyingWidget=null
integer bj_randDistCount=0
integer array bj_randDistID
integer array bj_randDistChance
unit bj_lastCreatedUnit=null
item bj_lastCreatedItem=null
item bj_lastRemovedItem=null
unit bj_lastHauntedGoldMine=null
destructable bj_lastCreatedDestructable=null
group bj_lastCreatedGroup=CreateGroup()
fogmodifier bj_lastCreatedFogModifier=null
effect bj_lastCreatedEffect=null
weathereffect bj_lastCreatedWeatherEffect=null
terraindeformation bj_lastCreatedTerrainDeformation=null
quest bj_lastCreatedQuest=null
questitem bj_lastCreatedQuestItem=null
defeatcondition bj_lastCreatedDefeatCondition=null
timer bj_lastStartedTimer=CreateTimer()
timerdialog bj_lastCreatedTimerDialog=null
leaderboard bj_lastCreatedLeaderboard=null
multiboard bj_lastCreatedMultiboard=null
sound bj_lastPlayedSound=null
string bj_lastPlayedMusic=""
real bj_lastTransmissionDuration=0
gamecache bj_lastCreatedGameCache=null
unit bj_lastLoadedUnit=null
button bj_lastCreatedButton=null
unit bj_lastReplacedUnit=null
texttag bj_lastCreatedTextTag=null
lightning bj_lastCreatedLightning=null
image bj_lastCreatedImage=null
ubersplat bj_lastCreatedUbersplat=null
boolexpr filterIssueHauntOrderAtLocBJ=null
boolexpr filterEnumDestructablesInCircleBJ=null
boolexpr filterGetUnitsInRectOfPlayer=null
boolexpr filterGetUnitsOfTypeIdAll=null
boolexpr filterGetUnitsOfPlayerAndTypeId=null
boolexpr filterMeleeTrainedUnitIsHeroBJ=null
boolexpr filterLivingPlayerUnitsOfTypeId=null
boolean bj_wantDestroyGroup=false
string language=""
string game_mode=""
integer array command_number
integer array command_par1
integer array command_par2
integer array command_par3
string array command_key1
string array command_key2
string array command_key3
string array command_dlg1
integer array command_hotkey1
string array command_dlg2
integer array command_hotkey2
string array command_dlg3
integer array command_hotkey3
string array command_msg
integer command_length=0
string array parsed_command
string command_prefix="Cmd:"
button array cdlg_button
integer array cdlg_number
dialog array cdlg_dialog
integer cdlg_length=0
dialog number_dialog=null
dialog player_dialog=null
dialog start_dialog=null
dialog root_dialog=null
integer array current_command
integer array current_player_par
integer array current_number_par
player array commanded_player
string array tribute_type
button tribute_g=null
button tribute_l=null
button tribute_give_g=null
button tribute_give_l=null
dialog tribute_dlg=null
button array tribute_dlg_button
integer tribute_dlg_length=0
button array sdbn_button
integer array sdbn_number
integer sdbn_length=0
button array pcbn_button
integer array pcbn_number
integer pcbn_length=0
button array ndbn_button
integer ndbn_length=0
dialog array dlg_dialog
string array dlg_string
integer dlg_length=0
dialog game_start_dialog=null
trigger game_start_trigger=null
button commander_mode=null
button no_human_mode=null
button ai_only_mode=null
dialog language_dialog=null
trigger language_trigger=null
button English_button=null
button Deutsch_button=null
button Swedish_button=null
button French_button=null
button Spanish_button=null
button Romanian_button=null
button Russian_button=null
button Portuguese_button=null
button Norwegian_button=null
button Chinese_button=null
string chat_no_ally=""
string dlghdr_choose_ally=""
string dlghdr_choose_number=""
string dlghdr_choose_player=""
string dlghdr_game_type=""
string dlghdr_root=""
string dlghdr_tribute_type=""
string dlghdr_tribute_amount=""
string dlgbutton_cancel=""
string dlgbutton_all=""
string dlgbutton_gold=""
string dlgbutton_lumber=""
string dlgbutton_give_gold="Give Gold"
string dlgbutton_give_lumber="Give Lumber"
string dlgbutton_tribute=""
string dlgbutton_commander=""
string dlgbutton_no_human=""
string dlgbutton_ai_only=""
leaderboard color_board=null
gamecache translation=InitGameCache("Commander.w3v")
endglobals
function BJDebugMsg takes string msg returns nothing
local integer i=0
loop
call DisplayTimedTextToPlayer(Player(i),0,0,60,msg)
set i=i+1
exitwhen i==bj_MAX_PLAYERS
endloop
endfunction
function RMinBJ takes real a,real b returns real
if(a<b)then
return a
else
return b
endif
endfunction
function RMaxBJ takes real a,real b returns real
if(a<b)then
return b
else
return a
endif
endfunction
function RAbsBJ takes real a returns real
if(a>=0)then
return a
else
return-a
endif
endfunction
function RSignBJ takes real a returns real
if(a>=0.0)then
return 1.0
else
return-1.0
endif
endfunction
function IMinBJ takes integer a,integer b returns integer
if(a<b)then
return a
else
return b
endif
endfunction
function IMaxBJ takes integer a,integer b returns integer
if(a<b)then
return b
else
return a
endif
endfunction
function IAbsBJ takes integer a returns integer
if(a>=0)then
return a
else
return-a
endif
endfunction
function ISignBJ takes integer a returns integer
if(a>=0)then
return 1
else
return-1
endif
endfunction
function SinBJ takes real degrees returns real
return Sin(degrees*bj_DEGTORAD)
endfunction
function CosBJ takes real degrees returns real
return Cos(degrees*bj_DEGTORAD)
endfunction
function TanBJ takes real degrees returns real
return Tan(degrees*bj_DEGTORAD)
endfunction
function AsinBJ takes real degrees returns real
return Asin(degrees)*bj_RADTODEG
endfunction
function AcosBJ takes real degrees returns real
return Acos(degrees)*bj_RADTODEG
endfunction
function AtanBJ takes real degrees returns real
return Atan(degrees)*bj_RADTODEG
endfunction
function Atan2BJ takes real y,real x returns real
return Atan2(y,x)*bj_RADTODEG
endfunction
function AngleBetweenPoints takes location locA,location locB returns real
return bj_RADTODEG*Atan2(GetLocationY(locB)-GetLocationY(locA),GetLocationX(locB)-GetLocationX(locA))
endfunction
function DistanceBetweenPoints takes location locA,location locB returns real
local real dx=GetLocationX(locB)-GetLocationX(locA)
local real dy=GetLocationY(locB)-GetLocationY(locA)
return SquareRoot(dx*dx+dy*dy)
endfunction
function PolarProjectionBJ takes location source,real dist,real angle returns location
local real x=GetLocationX(source)+dist*Cos(angle*bj_DEGTORAD)
local real y=GetLocationY(source)+dist*Sin(angle*bj_DEGTORAD)
return Location(x,y)
endfunction
function GetRandomDirectionDeg takes nothing returns real
return GetRandomReal(0,360)
endfunction
function GetRandomPercentageBJ takes nothing returns real
return GetRandomReal(0,100)
endfunction
function GetRandomLocInRect takes rect whichRect returns location
return Location(GetRandomReal(GetRectMinX(whichRect),GetRectMaxX(whichRect)),GetRandomReal(GetRectMinY(whichRect),GetRectMaxY(whichRect)))
endfunction
function ModuloInteger takes integer dividend,integer divisor returns integer
local integer modulus=dividend-(dividend/divisor)*divisor
if(modulus<0)then
set modulus=modulus+divisor
endif
return modulus
endfunction
function ModuloReal takes real dividend,real divisor returns real
local real modulus=dividend-I2R(R2I(dividend/divisor))*divisor
if(modulus<0)then
set modulus=modulus+divisor
endif
return modulus
endfunction
function OffsetLocation takes location loc,real dx,real dy returns location
return Location(GetLocationX(loc)+dx,GetLocationY(loc)+dy)
endfunction
function OffsetRectBJ takes rect r,real dx,real dy returns rect
return Rect(GetRectMinX(r)+dx,GetRectMinY(r)+dy,GetRectMaxX(r)+dx,GetRectMaxY(r)+dy)
endfunction
function RectFromCenterSizeBJ takes location center,real width,real height returns rect
local real x=GetLocationX(center)
local real y=GetLocationY(center)
return Rect(x-width*0.5,y-height*0.5,x+width*0.5,y+height*0.5)
endfunction
function RectContainsCoords takes rect r,real x,real y returns boolean
return(GetRectMinX(r)<=x)and(x<=GetRectMaxX(r))and(GetRectMinY(r)<=y)and(y<=GetRectMaxY(r))
endfunction
function RectContainsLoc takes rect r,location loc returns boolean
return RectContainsCoords(r,GetLocationX(loc),GetLocationY(loc))
endfunction
function RectContainsUnit takes rect r,unit whichUnit returns boolean
return RectContainsCoords(r,GetUnitX(whichUnit),GetUnitY(whichUnit))
endfunction
function RectContainsItem takes item whichItem,rect r returns boolean
if(whichItem==null)then
return false
endif
if(IsItemOwned(whichItem))then
return false
endif
return RectContainsCoords(r,GetItemX(whichItem),GetItemY(whichItem))
endfunction
function ConditionalTriggerExecute takes trigger trig returns nothing
if TriggerEvaluate(trig)then
call TriggerExecute(trig)
endif
endfunction
function TriggerExecuteBJ takes trigger trig,boolean checkConditions returns boolean
if checkConditions then
if not(TriggerEvaluate(trig))then
return false
endif
endif
call TriggerExecute(trig)
return true
endfunction
function PostTriggerExecuteBJ takes trigger trig,boolean checkConditions returns boolean
if checkConditions then
if not(TriggerEvaluate(trig))then
return false
endif
endif
call TriggerRegisterTimerEvent(trig,0,false)
return true
endfunction
function QueuedTriggerCheck takes nothing returns nothing
local string s="TrigQueue Check "
local integer i
set i=0
loop
exitwhen i>=bj_queuedExecTotal
set s=s+"q["+I2S(i)+"]="
if(bj_queuedExecTriggers[i]==null)then
set s=s+"null "
else
set s=s+"x "
endif
set i=i+1
endloop
set s=s+"("+I2S(bj_queuedExecTotal)+" total)"
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,600,s)
endfunction
function QueuedTriggerGetIndex takes trigger trig returns integer
local integer index=0
loop
exitwhen index>=bj_queuedExecTotal
if(bj_queuedExecTriggers[index]==trig)then
return index
endif
set index=index+1
endloop
return-1
endfunction
function QueuedTriggerRemoveByIndex takes integer trigIndex returns boolean
local integer index
if(trigIndex>=bj_queuedExecTotal)then
return false
endif
set bj_queuedExecTotal=bj_queuedExecTotal-1
set index=trigIndex
loop
exitwhen index>=bj_queuedExecTotal
set bj_queuedExecTriggers[index]=bj_queuedExecTriggers[index+1]
set bj_queuedExecUseConds[index]=bj_queuedExecUseConds[index+1]
set index=index+1
endloop
return true
endfunction
function QueuedTriggerAttemptExec takes nothing returns boolean
loop
exitwhen bj_queuedExecTotal==0
if TriggerExecuteBJ(bj_queuedExecTriggers[0],bj_queuedExecUseConds[0])then
call TimerStart(bj_queuedExecTimeoutTimer,bj_QUEUED_TRIGGER_TIMEOUT,false,null)
return true
endif
call QueuedTriggerRemoveByIndex(0)
endloop
return false
endfunction
function QueuedTriggerAddBJ takes trigger trig,boolean checkConditions returns boolean
if(bj_queuedExecTotal>=bj_MAX_QUEUED_TRIGGERS)then
return false
endif
set bj_queuedExecTriggers[bj_queuedExecTotal]=trig
set bj_queuedExecUseConds[bj_queuedExecTotal]=checkConditions
set bj_queuedExecTotal=bj_queuedExecTotal+1
if(bj_queuedExecTotal==1)then
call QueuedTriggerAttemptExec()
endif
return true
endfunction
function QueuedTriggerRemoveBJ takes trigger trig returns nothing
local integer index
local integer trigIndex
local boolean trigExecuted
set trigIndex=QueuedTriggerGetIndex(trig)
if(trigIndex==-1)then
return
endif
call QueuedTriggerRemoveByIndex(trigIndex)
if(trigIndex==0)then
call PauseTimer(bj_queuedExecTimeoutTimer)
call QueuedTriggerAttemptExec()
endif
endfunction
function QueuedTriggerDoneBJ takes nothing returns nothing
local integer index
if(bj_queuedExecTotal<=0)then
return
endif
call QueuedTriggerRemoveByIndex(0)
call PauseTimer(bj_queuedExecTimeoutTimer)
call QueuedTriggerAttemptExec()
endfunction
function QueuedTriggerClearBJ takes nothing returns nothing
call PauseTimer(bj_queuedExecTimeoutTimer)
set bj_queuedExecTotal=0
endfunction
function QueuedTriggerClearInactiveBJ takes nothing returns nothing
set bj_queuedExecTotal=IMinBJ(bj_queuedExecTotal,1)
endfunction
function QueuedTriggerCountBJ takes nothing returns integer
return bj_queuedExecTotal
endfunction
function IsTriggerQueueEmptyBJ takes nothing returns boolean
return bj_queuedExecTotal<=0
endfunction
function IsTriggerQueuedBJ takes trigger trig returns boolean
return QueuedTriggerGetIndex(trig)!=-1
endfunction
function GetForLoopIndexA takes nothing returns integer
return bj_forLoopAIndex
endfunction
function SetForLoopIndexA takes integer newIndex returns nothing
set bj_forLoopAIndex=newIndex
endfunction
function GetForLoopIndexB takes nothing returns integer
return bj_forLoopBIndex
endfunction
function SetForLoopIndexB takes integer newIndex returns nothing
set bj_forLoopBIndex=newIndex
endfunction
function PolledWait takes real duration returns nothing
local timer t
local real timeRemaining
if(duration>0)then
set t=CreateTimer()
call TimerStart(t,duration,false,null)
loop
set timeRemaining=TimerGetRemaining(t)
exitwhen timeRemaining<=0
if(timeRemaining>bj_POLLED_WAIT_SKIP_THRESHOLD)then
call TriggerSleepAction(0.1*timeRemaining)
else
call TriggerSleepAction(bj_POLLED_WAIT_INTERVAL)
endif
endloop
call DestroyTimer(t)
endif
endfunction
function IntegerTertiaryOp takes boolean flag,integer valueA,integer valueB returns integer
if flag then
return valueA
else
return valueB
endif
endfunction
function DoNothing takes nothing returns nothing
endfunction
function CommentString takes string commentString returns nothing
endfunction
function StringIdentity takes string theString returns string
return GetLocalizedString(theString)
endfunction
function GetBooleanAnd takes boolean valueA,boolean valueB returns boolean
return valueA and valueB
endfunction
function GetBooleanOr takes boolean valueA,boolean valueB returns boolean
return valueA or valueB
endfunction
function PercentToInt takes real percentage,integer max returns integer
local integer result=R2I(percentage*I2R(max)*0.01)
if(result<0)then
set result=0
elseif(result>max)then
set result=max
endif
return result
endfunction
function PercentTo255 takes real percentage returns integer
return PercentToInt(percentage,255)
endfunction
function GetTimeOfDay takes nothing returns real
return GetFloatGameState(GAME_STATE_TIME_OF_DAY)
endfunction
function SetTimeOfDay takes real whatTime returns nothing
call SetFloatGameState(GAME_STATE_TIME_OF_DAY,whatTime)
endfunction
function SetTimeOfDayScalePercentBJ takes real scalePercent returns nothing
call SetTimeOfDayScale(scalePercent*0.01)
endfunction
function GetTimeOfDayScalePercentBJ takes nothing returns real
return GetTimeOfDayScale()*100
endfunction
function PlaySound takes string soundName returns nothing
local sound soundHandle=CreateSound(soundName,false,false,true,12700,12700,"")
call StartSound(soundHandle)
call KillSoundWhenDone(soundHandle)
endfunction
function CompareLocationsBJ takes location A,location B returns boolean
return GetLocationX(A)==GetLocationX(B)and GetLocationY(A)==GetLocationY(B)
endfunction
function CompareRectsBJ takes rect A,rect B returns boolean
return GetRectMinX(A)==GetRectMinX(B)and GetRectMinY(A)==GetRectMinY(B)and GetRectMaxX(A)==GetRectMaxX(B)and GetRectMaxY(A)==GetRectMaxY(B)
endfunction
function GetRectFromCircleBJ takes location center,real radius returns rect
local real centerX=GetLocationX(center)
local real centerY=GetLocationY(center)
return Rect(centerX-radius,centerY-radius,centerX+radius,centerY+radius)
endfunction
function GetCurrentCameraSetup takes nothing returns camerasetup
local camerasetup theCam=CreateCameraSetup()
local real duration=0
call CameraSetupSetField(theCam,CAMERA_FIELD_TARGET_DISTANCE,GetCameraField(CAMERA_FIELD_TARGET_DISTANCE),duration)
call CameraSetupSetField(theCam,CAMERA_FIELD_FARZ,GetCameraField(CAMERA_FIELD_FARZ),duration)
call CameraSetupSetField(theCam,CAMERA_FIELD_ZOFFSET,GetCameraField(CAMERA_FIELD_ZOFFSET),duration)
call CameraSetupSetField(theCam,CAMERA_FIELD_ANGLE_OF_ATTACK,bj_RADTODEG*GetCameraField(CAMERA_FIELD_ANGLE_OF_ATTACK),duration)
call CameraSetupSetField(theCam,CAMERA_FIELD_FIELD_OF_VIEW,bj_RADTODEG*GetCameraField(CAMERA_FIELD_FIELD_OF_VIEW),duration)
call CameraSetupSetField(theCam,CAMERA_FIELD_ROLL,bj_RADTODEG*GetCameraField(CAMERA_FIELD_ROLL),duration)
call CameraSetupSetField(theCam,CAMERA_FIELD_ROTATION,bj_RADTODEG*GetCameraField(CAMERA_FIELD_ROTATION),duration)
call CameraSetupSetDestPosition(theCam,GetCameraTargetPositionX(),GetCameraTargetPositionY(),duration)
return theCam
endfunction
function CameraSetupApplyForPlayer takes boolean doPan,camerasetup whichSetup,player whichPlayer,real duration returns nothing
if(GetLocalPlayer()==whichPlayer)then
call CameraSetupApplyForceDuration(whichSetup,doPan,duration)
endif
endfunction
function CameraSetupGetFieldSwap takes camerafield whichField,camerasetup whichSetup returns real
return CameraSetupGetField(whichSetup,whichField)
endfunction
function SetCameraFieldForPlayer takes player whichPlayer,camerafield whichField,real value,real duration returns nothing
if(GetLocalPlayer()==whichPlayer)then
call SetCameraField(whichField,value,duration)
endif
endfunction
function SetCameraTargetControllerNoZForPlayer takes player whichPlayer,unit whichUnit,real xoffset,real yoffset,boolean inheritOrientation returns nothing
if(GetLocalPlayer()==whichPlayer)then
call SetCameraTargetController(whichUnit,xoffset,yoffset,inheritOrientation)
endif
endfunction
function SetCameraPositionForPlayer takes player whichPlayer,real x,real y returns nothing
if(GetLocalPlayer()==whichPlayer)then
call SetCameraPosition(x,y)
endif
endfunction
function SetCameraPositionLocForPlayer takes player whichPlayer,location loc returns nothing
if(GetLocalPlayer()==whichPlayer)then
call SetCameraPosition(GetLocationX(loc),GetLocationY(loc))
endif
endfunction
function RotateCameraAroundLocBJ takes real degrees,location loc,player whichPlayer,real duration returns nothing
if(GetLocalPlayer()==whichPlayer)then
call SetCameraRotateMode(GetLocationX(loc),GetLocationY(loc),bj_DEGTORAD*degrees,duration)
endif
endfunction
function PanCameraToForPlayer takes player whichPlayer,real x,real y returns nothing
if(GetLocalPlayer()==whichPlayer)then
call PanCameraTo(x,y)
endif
endfunction
function PanCameraToLocForPlayer takes player whichPlayer,location loc returns nothing
if(GetLocalPlayer()==whichPlayer)then
call PanCameraTo(GetLocationX(loc),GetLocationY(loc))
endif
endfunction
function PanCameraToTimedForPlayer takes player whichPlayer,real x,real y,real duration returns nothing
if(GetLocalPlayer()==whichPlayer)then
call PanCameraToTimed(x,y,duration)
endif
endfunction
function PanCameraToTimedLocForPlayer takes player whichPlayer,location loc,real duration returns nothing
if(GetLocalPlayer()==whichPlayer)then
call PanCameraToTimed(GetLocationX(loc),GetLocationY(loc),duration)
endif
endfunction
function PanCameraToTimedLocWithZForPlayer takes player whichPlayer,location loc,real zOffset,real duration returns nothing
if(GetLocalPlayer()==whichPlayer)then
call PanCameraToTimedWithZ(GetLocationX(loc),GetLocationY(loc),zOffset,duration)
endif
endfunction
function SmartCameraPanBJ takes player whichPlayer,location loc,real duration returns nothing
local real dist
if(GetLocalPlayer()==whichPlayer)then
set dist=DistanceBetweenPoints(loc,GetCameraTargetPositionLoc())
if(dist>=bj_SMARTPAN_TRESHOLD_SNAP)then
call PanCameraToTimed(GetLocationX(loc),GetLocationY(loc),0)
elseif(dist>=bj_SMARTPAN_TRESHOLD_PAN)then
call PanCameraToTimed(GetLocationX(loc),GetLocationY(loc),duration)
else
endif
endif
endfunction
function SetCinematicCameraForPlayer takes player whichPlayer,string cameraModelFile returns nothing
if(GetLocalPlayer()==whichPlayer)then
call SetCinematicCamera(cameraModelFile)
endif
endfunction
function ResetToGameCameraForPlayer takes player whichPlayer,real duration returns nothing
if(GetLocalPlayer()==whichPlayer)then
call ResetToGameCamera(duration)
endif
endfunction
function CameraSetSourceNoiseForPlayer takes player whichPlayer,real magnitude,real velocity returns nothing
if(GetLocalPlayer()==whichPlayer)then
call CameraSetSourceNoise(magnitude,velocity)
endif
endfunction
function CameraSetTargetNoiseForPlayer takes player whichPlayer,real magnitude,real velocity returns nothing
if(GetLocalPlayer()==whichPlayer)then
call CameraSetTargetNoise(magnitude,velocity)
endif
endfunction
function CameraSetEQNoiseForPlayer takes player whichPlayer,real magnitude returns nothing
local real richter=magnitude
if(richter>5.0)then
set richter=5.0
endif
if(richter<2.0)then
set richter=2.0
endif
if(GetLocalPlayer()==whichPlayer)then
call CameraSetTargetNoiseEx(magnitude*2.0,magnitude*Pow(10,richter),true)
call CameraSetSourceNoiseEx(magnitude*2.0,magnitude*Pow(10,richter),true)
endif
endfunction
function CameraClearNoiseForPlayer takes player whichPlayer returns nothing
if(GetLocalPlayer()==whichPlayer)then
call CameraSetSourceNoise(0,0)
call CameraSetTargetNoise(0,0)
endif
endfunction
function GetCurrentCameraBoundsMapRectBJ takes nothing returns rect
return Rect(GetCameraBoundMinX(),GetCameraBoundMinY(),GetCameraBoundMaxX(),GetCameraBoundMaxY())
endfunction
function GetCameraBoundsMapRect takes nothing returns rect
return bj_mapInitialCameraBounds
endfunction
function GetPlayableMapRect takes nothing returns rect
return bj_mapInitialPlayableArea
endfunction
function GetEntireMapRect takes nothing returns rect
return GetWorldBounds()
endfunction
function SetCameraBoundsToRect takes rect r returns nothing
local real minX=GetRectMinX(r)
local real minY=GetRectMinY(r)
local real maxX=GetRectMaxX(r)
local real maxY=GetRectMaxY(r)
call SetCameraBounds(minX,minY,minX,maxY,maxX,maxY,maxX,minY)
endfunction
function SetCameraBoundsToRectForPlayerBJ takes player whichPlayer,rect r returns nothing
if(GetLocalPlayer()==whichPlayer)then
call SetCameraBoundsToRect(r)
endif
endfunction
function AdjustCameraBoundsBJ takes integer adjustMethod,real dxWest,real dxEast,real dyNorth,real dySouth returns nothing
local real minX=0
local real minY=0
local real maxX=0
local real maxY=0
local real scale=0
if(adjustMethod==bj_CAMERABOUNDS_ADJUST_ADD)then
set scale=1
elseif(adjustMethod==bj_CAMERABOUNDS_ADJUST_SUB)then
set scale=-1
else
return
endif
set minX=GetCameraBoundMinX()-scale*dxWest
set maxX=GetCameraBoundMaxX()+scale*dxEast
set minY=GetCameraBoundMinY()-scale*dySouth
set maxY=GetCameraBoundMaxY()+scale*dyNorth
if(maxX<minX)then
set minX=(minX+maxX)*0.5
set maxX=minX
endif
if(maxY<minY)then
set minY=(minY+maxY)*0.5
set maxY=minY
endif
call SetCameraBounds(minX,minY,minX,maxY,maxX,maxY,maxX,minY)
endfunction
function AdjustCameraBoundsForPlayerBJ takes integer adjustMethod,player whichPlayer,real dxWest,real dxEast,real dyNorth,real dySouth returns nothing
if(GetLocalPlayer()==whichPlayer)then
call AdjustCameraBoundsBJ(adjustMethod,dxWest,dxEast,dyNorth,dySouth)
endif
endfunction
function SetCameraQuickPositionForPlayer takes player whichPlayer,real x,real y returns nothing
if(GetLocalPlayer()==whichPlayer)then
call SetCameraQuickPosition(x,y)
endif
endfunction
function SetCameraQuickPositionLocForPlayer takes player whichPlayer,location loc returns nothing
if(GetLocalPlayer()==whichPlayer)then
call SetCameraQuickPosition(GetLocationX(loc),GetLocationY(loc))
endif
endfunction
function SetCameraQuickPositionLoc takes location loc returns nothing
call SetCameraQuickPosition(GetLocationX(loc),GetLocationY(loc))
endfunction
function StopCameraForPlayerBJ takes player whichPlayer returns nothing
if(GetLocalPlayer()==whichPlayer)then
call StopCamera()
endif
endfunction
function SetCameraOrientControllerForPlayerBJ takes player whichPlayer,unit whichUnit,real xoffset,real yoffset returns nothing
if(GetLocalPlayer()==whichPlayer)then
call SetCameraOrientController(whichUnit,xoffset,yoffset)
endif
endfunction
function CameraSetSmoothingFactorBJ takes real factor returns nothing
call CameraSetSmoothingFactor(factor)
endfunction
function CameraResetSmoothingFactorBJ takes nothing returns nothing
call CameraSetSmoothingFactor(0)
endfunction
function DisplayTextToForce takes force toForce,string message returns nothing
if(IsPlayerInForce(GetLocalPlayer(),toForce))then
call DisplayTextToPlayer(GetLocalPlayer(),0,0,message)
endif
endfunction
function DisplayTimedTextToForce takes force toForce,real duration,string message returns nothing
if(IsPlayerInForce(GetLocalPlayer(),toForce))then
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,duration,message)
endif
endfunction
function ClearTextMessagesBJ takes force toForce returns nothing
if(IsPlayerInForce(GetLocalPlayer(),toForce))then
call ClearTextMessages()
endif
endfunction
function SubStringBJ takes string source,integer start,integer end returns string
return SubString(source,start-1,end)
endfunction
function TriggerRegisterTimerEventPeriodic takes trigger trig,real timeout returns event
return TriggerRegisterTimerEvent(trig,timeout,true)
endfunction
function TriggerRegisterTimerEventSingle takes trigger trig,real timeout returns event
return TriggerRegisterTimerEvent(trig,timeout,false)
endfunction
function TriggerRegisterTimerExpireEventBJ takes trigger trig,timer t returns event
return TriggerRegisterTimerExpireEvent(trig,t)
endfunction
function TriggerRegisterPlayerUnitEventSimple takes trigger trig,player whichPlayer,playerunitevent whichEvent returns event
return TriggerRegisterPlayerUnitEvent(trig,whichPlayer,whichEvent,null)
endfunction
function TriggerRegisterAnyUnitEventBJ takes trigger trig,playerunitevent whichEvent returns nothing
local integer index
set index=0
loop
call TriggerRegisterPlayerUnitEvent(trig,Player(index),whichEvent,null)
set index=index+1
exitwhen index==bj_MAX_PLAYER_SLOTS
endloop
endfunction
function TriggerRegisterPlayerSelectionEventBJ takes trigger trig,player whichPlayer,boolean selected returns event
if selected then
return TriggerRegisterPlayerUnitEvent(trig,whichPlayer,EVENT_PLAYER_UNIT_SELECTED,null)
else
return TriggerRegisterPlayerUnitEvent(trig,whichPlayer,EVENT_PLAYER_UNIT_DESELECTED,null)
endif
endfunction
function TriggerRegisterPlayerKeyEventBJ takes trigger trig,player whichPlayer,integer keType,integer keKey returns event
if(keType==bj_KEYEVENTTYPE_DEPRESS)then
if(keKey==bj_KEYEVENTKEY_LEFT)then
return TriggerRegisterPlayerEvent(trig,whichPlayer,EVENT_PLAYER_ARROW_LEFT_DOWN)
elseif(keKey==bj_KEYEVENTKEY_RIGHT)then
return TriggerRegisterPlayerEvent(trig,whichPlayer,EVENT_PLAYER_ARROW_RIGHT_DOWN)
elseif(keKey==bj_KEYEVENTKEY_DOWN)then
return TriggerRegisterPlayerEvent(trig,whichPlayer,EVENT_PLAYER_ARROW_DOWN_DOWN)
elseif(keKey==bj_KEYEVENTKEY_UP)then
return TriggerRegisterPlayerEvent(trig,whichPlayer,EVENT_PLAYER_ARROW_UP_DOWN)
else
return null
endif
elseif(keType==bj_KEYEVENTTYPE_RELEASE)then
if(keKey==bj_KEYEVENTKEY_LEFT)then
return TriggerRegisterPlayerEvent(trig,whichPlayer,EVENT_PLAYER_ARROW_LEFT_UP)
elseif(keKey==bj_KEYEVENTKEY_RIGHT)then
return TriggerRegisterPlayerEvent(trig,whichPlayer,EVENT_PLAYER_ARROW_RIGHT_UP)
elseif(keKey==bj_KEYEVENTKEY_DOWN)then
return TriggerRegisterPlayerEvent(trig,whichPlayer,EVENT_PLAYER_ARROW_DOWN_UP)
elseif(keKey==bj_KEYEVENTKEY_UP)then
return TriggerRegisterPlayerEvent(trig,whichPlayer,EVENT_PLAYER_ARROW_UP_UP)
else
return null
endif
else
return null
endif
endfunction
function TriggerRegisterPlayerEventVictory takes trigger trig,player whichPlayer returns event
return TriggerRegisterPlayerEvent(trig,whichPlayer,EVENT_PLAYER_VICTORY)
endfunction
function TriggerRegisterPlayerEventDefeat takes trigger trig,player whichPlayer returns event
return TriggerRegisterPlayerEvent(trig,whichPlayer,EVENT_PLAYER_DEFEAT)
endfunction
function TriggerRegisterPlayerEventLeave takes trigger trig,player whichPlayer returns event
return TriggerRegisterPlayerEvent(trig,whichPlayer,EVENT_PLAYER_LEAVE)
endfunction
function TriggerRegisterPlayerEventAllianceChanged takes trigger trig,player whichPlayer returns event
return TriggerRegisterPlayerEvent(trig,whichPlayer,EVENT_PLAYER_ALLIANCE_CHANGED)
endfunction
function TriggerRegisterPlayerEventEndCinematic takes trigger trig,player whichPlayer returns event
return TriggerRegisterPlayerEvent(trig,whichPlayer,EVENT_PLAYER_END_CINEMATIC)
endfunction
function TriggerRegisterGameStateEventTimeOfDay takes trigger trig,limitop opcode,real limitval returns event
return TriggerRegisterGameStateEvent(trig,GAME_STATE_TIME_OF_DAY,opcode,limitval)
endfunction
function TriggerRegisterEnterRegionSimple takes trigger trig,region whichRegion returns event
return TriggerRegisterEnterRegion(trig,whichRegion,null)
endfunction
function TriggerRegisterLeaveRegionSimple takes trigger trig,region whichRegion returns event
return TriggerRegisterLeaveRegion(trig,whichRegion,null)
endfunction
function TriggerRegisterEnterRectSimple takes trigger trig,rect r returns event
local region rectRegion=CreateRegion()
call RegionAddRect(rectRegion,r)
return TriggerRegisterEnterRegion(trig,rectRegion,null)
endfunction
function TriggerRegisterLeaveRectSimple takes trigger trig,rect r returns event
local region rectRegion=CreateRegion()
call RegionAddRect(rectRegion,r)
return TriggerRegisterLeaveRegion(trig,rectRegion,null)
endfunction
function TriggerRegisterDistanceBetweenUnits takes trigger trig,unit whichUnit,boolexpr condition,real range returns event
return TriggerRegisterUnitInRange(trig,whichUnit,range,condition)
endfunction
function TriggerRegisterUnitInRangeSimple takes trigger trig,real range,unit whichUnit returns event
return TriggerRegisterUnitInRange(trig,whichUnit,range,null)
endfunction
function TriggerRegisterUnitLifeEvent takes trigger trig,unit whichUnit,limitop opcode,real limitval returns event
return TriggerRegisterUnitStateEvent(trig,whichUnit,UNIT_STATE_LIFE,opcode,limitval)
endfunction
function TriggerRegisterUnitManaEvent takes trigger trig,unit whichUnit,limitop opcode,real limitval returns event
return TriggerRegisterUnitStateEvent(trig,whichUnit,UNIT_STATE_MANA,opcode,limitval)
endfunction
function TriggerRegisterDialogEventBJ takes trigger trig,dialog whichDialog returns event
return TriggerRegisterDialogEvent(trig,whichDialog)
endfunction
function TriggerRegisterShowSkillEventBJ takes trigger trig returns event
return TriggerRegisterGameEvent(trig,EVENT_GAME_SHOW_SKILL)
endfunction
function TriggerRegisterBuildSubmenuEventBJ takes trigger trig returns event
return TriggerRegisterGameEvent(trig,EVENT_GAME_BUILD_SUBMENU)
endfunction
function TriggerRegisterGameLoadedEventBJ takes trigger trig returns event
return TriggerRegisterGameEvent(trig,EVENT_GAME_LOADED)
endfunction
function TriggerRegisterGameSavedEventBJ takes trigger trig returns event
return TriggerRegisterGameEvent(trig,EVENT_GAME_SAVE)
endfunction
function RegisterDestDeathInRegionEnum takes nothing returns nothing
set bj_destInRegionDiesCount=bj_destInRegionDiesCount+1
if(bj_destInRegionDiesCount<=bj_MAX_DEST_IN_REGION_EVENTS)then
call TriggerRegisterDeathEvent(bj_destInRegionDiesTrig,GetEnumDestructable())
endif
endfunction
function TriggerRegisterDestDeathInRegionEvent takes trigger trig,rect r returns event
set bj_destInRegionDiesTrig=trig
set bj_destInRegionDiesCount=0
call EnumDestructablesInRect(r,null,function RegisterDestDeathInRegionEnum)
return trig
endfunction
function AddWeatherEffectSaveLast takes rect where,integer effectID returns weathereffect
set bj_lastCreatedWeatherEffect=AddWeatherEffect(where,effectID)
return bj_lastCreatedWeatherEffect
endfunction
function GetLastCreatedWeatherEffect takes nothing returns weathereffect
return bj_lastCreatedWeatherEffect
endfunction
function RemoveWeatherEffectBJ takes weathereffect whichWeatherEffect returns nothing
call RemoveWeatherEffect(whichWeatherEffect)
endfunction
function TerrainDeformationCraterBJ takes real duration,boolean permanent,location where,real radius,real depth returns terraindeformation
set bj_lastCreatedTerrainDeformation=TerrainDeformCrater(GetLocationX(where),GetLocationY(where),radius,depth,R2I(duration*1000),permanent)
return bj_lastCreatedTerrainDeformation
endfunction
function TerrainDeformationRippleBJ takes real duration,boolean limitNeg,location where,real startRadius,real endRadius,real depth,real wavePeriod,real waveWidth returns terraindeformation
local real spaceWave
local real timeWave
local real radiusRatio
if(endRadius<=0 or waveWidth<=0 or wavePeriod<=0)then
return null
endif
set timeWave=2.0*duration/wavePeriod
set spaceWave=2.0*endRadius/waveWidth
set radiusRatio=startRadius/endRadius
set bj_lastCreatedTerrainDeformation=TerrainDeformRipple(GetLocationX(where),GetLocationY(where),endRadius,depth,R2I(duration*1000),1,spaceWave,timeWave,radiusRatio,limitNeg)
return bj_lastCreatedTerrainDeformation
endfunction
function TerrainDeformationWaveBJ takes real duration,location source,location target,real radius,real depth,real trailDelay returns terraindeformation
local real distance
local real dirX
local real dirY
local real speed
set distance=DistanceBetweenPoints(source,target)
if(distance==0 or duration<=0)then
return null
endif
set dirX=(GetLocationX(target)-GetLocationX(source))/distance
set dirY=(GetLocationY(target)-GetLocationY(source))/distance
set speed=distance/duration
set bj_lastCreatedTerrainDeformation=TerrainDeformWave(GetLocationX(source),GetLocationY(source),dirX,dirY,distance,speed,radius,depth,R2I(trailDelay*1000),1)
return bj_lastCreatedTerrainDeformation
endfunction
function TerrainDeformationRandomBJ takes real duration,location where,real radius,real minDelta,real maxDelta,real updateInterval returns terraindeformation
set bj_lastCreatedTerrainDeformation=TerrainDeformRandom(GetLocationX(where),GetLocationY(where),radius,minDelta,maxDelta,R2I(duration*1000),R2I(updateInterval*1000))
return bj_lastCreatedTerrainDeformation
endfunction
function TerrainDeformationStopBJ takes terraindeformation deformation,real duration returns nothing
call TerrainDeformStop(deformation,R2I(duration*1000))
endfunction
function GetLastCreatedTerrainDeformation takes nothing returns terraindeformation
return bj_lastCreatedTerrainDeformation
endfunction
function AddLightningLoc takes string codeName,location where1,location where2 returns lightning
set bj_lastCreatedLightning=AddLightningEx(codeName,true,GetLocationX(where1),GetLocationY(where1),GetLocationZ(where1),GetLocationX(where2),GetLocationY(where2),GetLocationZ(where2))
return bj_lastCreatedLightning
endfunction
function DestroyLightningBJ takes lightning whichBolt returns boolean
return DestroyLightning(whichBolt)
endfunction
function MoveLightningLoc takes lightning whichBolt,location where1,location where2 returns boolean
return MoveLightningEx(whichBolt,true,GetLocationX(where1),GetLocationY(where1),GetLocationZ(where1),GetLocationX(where2),GetLocationY(where2),GetLocationZ(where2))
endfunction
function GetLightningColorABJ takes lightning whichBolt returns real
return GetLightningColorA(whichBolt)
endfunction
function GetLightningColorRBJ takes lightning whichBolt returns real
return GetLightningColorR(whichBolt)
endfunction
function GetLightningColorGBJ takes lightning whichBolt returns real
return GetLightningColorG(whichBolt)
endfunction
function GetLightningColorBBJ takes lightning whichBolt returns real
return GetLightningColorB(whichBolt)
endfunction
function SetLightningColorBJ takes lightning whichBolt,real r,real g,real b,real a returns boolean
return SetLightningColor(whichBolt,r,g,b,a)
endfunction
function GetLastCreatedLightningBJ takes nothing returns lightning
return bj_lastCreatedLightning
endfunction
function GetAbilityEffectBJ takes integer abilcode,effecttype t,integer index returns string
return GetAbilityEffectById(abilcode,t,index)
endfunction
function GetAbilitySoundBJ takes integer abilcode,soundtype t returns string
return GetAbilitySoundById(abilcode,t)
endfunction
function GetTerrainCliffLevelBJ takes location where returns integer
return GetTerrainCliffLevel(GetLocationX(where),GetLocationY(where))
endfunction
function GetTerrainTypeBJ takes location where returns integer
return GetTerrainType(GetLocationX(where),GetLocationY(where))
endfunction
function GetTerrainVarianceBJ takes location where returns integer
return GetTerrainVariance(GetLocationX(where),GetLocationY(where))
endfunction
function SetTerrainTypeBJ takes location where,integer terrainType,integer variation,integer area,integer shape returns nothing
call SetTerrainType(GetLocationX(where),GetLocationY(where),terrainType,variation,area,shape)
endfunction
function IsTerrainPathableBJ takes location where,pathingtype t returns boolean
return IsTerrainPathable(GetLocationX(where),GetLocationY(where),t)
endfunction
function SetTerrainPathableBJ takes location where,pathingtype t,boolean flag returns nothing
call SetTerrainPathable(GetLocationX(where),GetLocationY(where),t,flag)
endfunction
function SetWaterBaseColorBJ takes real red,real green,real blue,real transparency returns nothing
call SetWaterBaseColor(PercentTo255(red),PercentTo255(green),PercentTo255(blue),PercentTo255(100.0-transparency))
endfunction
function CreateFogModifierRectSimple takes player whichPlayer,fogstate whichFogState,rect r,boolean afterUnits returns fogmodifier
set bj_lastCreatedFogModifier=CreateFogModifierRect(whichPlayer,whichFogState,r,true,afterUnits)
return bj_lastCreatedFogModifier
endfunction
function CreateFogModifierRadiusLocSimple takes player whichPlayer,fogstate whichFogState,location center,real radius,boolean afterUnits returns fogmodifier
set bj_lastCreatedFogModifier=CreateFogModifierRadiusLoc(whichPlayer,whichFogState,center,radius,true,afterUnits)
return bj_lastCreatedFogModifier
endfunction
function CreateFogModifierRectBJ takes boolean enabled,player whichPlayer,fogstate whichFogState,rect r returns fogmodifier
set bj_lastCreatedFogModifier=CreateFogModifierRect(whichPlayer,whichFogState,r,true,false)
if enabled then
call FogModifierStart(bj_lastCreatedFogModifier)
endif
return bj_lastCreatedFogModifier
endfunction
function CreateFogModifierRadiusLocBJ takes boolean enabled,player whichPlayer,fogstate whichFogState,location center,real radius returns fogmodifier
set bj_lastCreatedFogModifier=CreateFogModifierRadiusLoc(whichPlayer,whichFogState,center,radius,true,false)
if enabled then
call FogModifierStart(bj_lastCreatedFogModifier)
endif
return bj_lastCreatedFogModifier
endfunction
function GetLastCreatedFogModifier takes nothing returns fogmodifier
return bj_lastCreatedFogModifier
endfunction
function FogEnableOn takes nothing returns nothing
call FogEnable(true)
endfunction
function FogEnableOff takes nothing returns nothing
call FogEnable(false)
endfunction
function FogMaskEnableOn takes nothing returns nothing
call FogMaskEnable(true)
endfunction
function FogMaskEnableOff takes nothing returns nothing
call FogMaskEnable(false)
endfunction
function UseTimeOfDayBJ takes boolean flag returns nothing
call SuspendTimeOfDay(not flag)
endfunction
function SetTerrainFogExBJ takes integer style,real zstart,real zend,real density,real red,real green,real blue returns nothing
call SetTerrainFogEx(style,zstart,zend,density,red*0.01,green*0.01,blue*0.01)
endfunction
function ResetTerrainFogBJ takes nothing returns nothing
call ResetTerrainFog()
endfunction
function SetDoodadAnimationBJ takes string animName,integer doodadID,real radius,location center returns nothing
call SetDoodadAnimation(GetLocationX(center),GetLocationY(center),radius,doodadID,false,animName,false)
endfunction
function SetDoodadAnimationRectBJ takes string animName,integer doodadID,rect r returns nothing
call SetDoodadAnimationRect(r,doodadID,animName,false)
endfunction
function AddUnitAnimationPropertiesBJ takes boolean add,string animProperties,unit whichUnit returns nothing
call AddUnitAnimationProperties(whichUnit,animProperties,add)
endfunction
function CreateImageBJ takes string file,real size,location where,real zOffset,integer imageType returns image
set bj_lastCreatedImage=CreateImage(file,size,size,size,GetLocationX(where),GetLocationY(where),zOffset,0,0,0,imageType)
return bj_lastCreatedImage
endfunction
function ShowImageBJ takes boolean flag,image whichImage returns nothing
call ShowImage(whichImage,flag)
endfunction
function SetImagePositionBJ takes image whichImage,location where,real zOffset returns nothing
call SetImagePosition(whichImage,GetLocationX(where),GetLocationY(where),zOffset)
endfunction
function SetImageColorBJ takes image whichImage,real red,real green,real blue,real alpha returns nothing
call SetImageColor(whichImage,PercentTo255(red),PercentTo255(green),PercentTo255(blue),PercentTo255(100.0-alpha))
endfunction
function GetLastCreatedImage takes nothing returns image
return bj_lastCreatedImage
endfunction
function CreateUbersplatBJ takes location where,string name,real red,real green,real blue,real alpha,boolean forcePaused,boolean noBirthTime returns ubersplat
set bj_lastCreatedUbersplat=CreateUbersplat(GetLocationX(where),GetLocationY(where),name,PercentTo255(red),PercentTo255(green),PercentTo255(blue),PercentTo255(100.0-alpha),forcePaused,noBirthTime)
return bj_lastCreatedUbersplat
endfunction
function ShowUbersplatBJ takes boolean flag,ubersplat whichSplat returns nothing
call ShowUbersplat(whichSplat,flag)
endfunction
function GetLastCreatedUbersplat takes nothing returns ubersplat
return bj_lastCreatedUbersplat
endfunction
function PlaySoundBJ takes sound soundHandle returns nothing
set bj_lastPlayedSound=soundHandle
if(soundHandle!=null)then
call StartSound(soundHandle)
endif
endfunction
function StopSoundBJ takes sound soundHandle,boolean fadeOut returns nothing
call StopSound(soundHandle,false,fadeOut)
endfunction
function SetSoundVolumeBJ takes sound soundHandle,real volumePercent returns nothing
call SetSoundVolume(soundHandle,PercentToInt(volumePercent,127))
endfunction
function SetSoundOffsetBJ takes real newOffset,sound soundHandle returns nothing
call SetSoundPlayPosition(soundHandle,R2I(newOffset*1000))
endfunction
function SetSoundDistanceCutoffBJ takes sound soundHandle,real cutoff returns nothing
call SetSoundDistanceCutoff(soundHandle,cutoff)
endfunction
function SetSoundPitchBJ takes sound soundHandle,real pitch returns nothing
call SetSoundPitch(soundHandle,pitch)
endfunction
function SetSoundPositionLocBJ takes sound soundHandle,location loc,real z returns nothing
call SetSoundPosition(soundHandle,GetLocationX(loc),GetLocationY(loc),z)
endfunction
function AttachSoundToUnitBJ takes sound soundHandle,unit whichUnit returns nothing
call AttachSoundToUnit(soundHandle,whichUnit)
endfunction
function SetSoundConeAnglesBJ takes sound soundHandle,real inside,real outside,real outsideVolumePercent returns nothing
call SetSoundConeAngles(soundHandle,inside,outside,PercentToInt(outsideVolumePercent,127))
endfunction
function KillSoundWhenDoneBJ takes sound soundHandle returns nothing
call KillSoundWhenDone(soundHandle)
endfunction
function PlaySoundAtPointBJ takes sound soundHandle,real volumePercent,location loc,real z returns nothing
call SetSoundPositionLocBJ(soundHandle,loc,z)
call SetSoundVolumeBJ(soundHandle,volumePercent)
call PlaySoundBJ(soundHandle)
endfunction
function PlaySoundOnUnitBJ takes sound soundHandle,real volumePercent,unit whichUnit returns nothing
call AttachSoundToUnitBJ(soundHandle,whichUnit)
call SetSoundVolumeBJ(soundHandle,volumePercent)
call PlaySoundBJ(soundHandle)
endfunction
function PlaySoundFromOffsetBJ takes sound soundHandle,real volumePercent,real startingOffset returns nothing
call SetSoundVolumeBJ(soundHandle,volumePercent)
call PlaySoundBJ(soundHandle)
call SetSoundOffsetBJ(startingOffset,soundHandle)
endfunction
function PlayMusicBJ takes string musicFileName returns nothing
set bj_lastPlayedMusic=musicFileName
call PlayMusic(musicFileName)
endfunction
function PlayMusicExBJ takes string musicFileName,real startingOffset,real fadeInTime returns nothing
set bj_lastPlayedMusic=musicFileName
call PlayMusicEx(musicFileName,R2I(startingOffset*1000),R2I(fadeInTime*1000))
endfunction
function SetMusicOffsetBJ takes real newOffset returns nothing
call SetMusicPlayPosition(R2I(newOffset*1000))
endfunction
function PlayThematicMusicBJ takes string musicName returns nothing
call PlayThematicMusic(musicName)
endfunction
function PlayThematicMusicExBJ takes string musicName,real startingOffset returns nothing
call PlayThematicMusicEx(musicName,R2I(startingOffset*1000))
endfunction
function SetThematicMusicOffsetBJ takes real newOffset returns nothing
call SetThematicMusicPlayPosition(R2I(newOffset*1000))
endfunction
function EndThematicMusicBJ takes nothing returns nothing
call EndThematicMusic()
endfunction
function StopMusicBJ takes boolean fadeOut returns nothing
call StopMusic(fadeOut)
endfunction
function ResumeMusicBJ takes nothing returns nothing
call ResumeMusic()
endfunction
function SetMusicVolumeBJ takes real volumePercent returns nothing
call SetMusicVolume(PercentToInt(volumePercent,127))
endfunction
function GetSoundDurationBJ takes sound soundHandle returns real
if(soundHandle==null)then
return bj_NOTHING_SOUND_DURATION
else
return I2R(GetSoundDuration(soundHandle))*0.001
endif
endfunction
function GetSoundFileDurationBJ takes string musicFileName returns real
return I2R(GetSoundFileDuration(musicFileName))*0.001
endfunction
function GetLastPlayedSound takes nothing returns sound
return bj_lastPlayedSound
endfunction
function GetLastPlayedMusic takes nothing returns string
return bj_lastPlayedMusic
endfunction
function VolumeGroupSetVolumeBJ takes volumegroup vgroup,real percent returns nothing
call VolumeGroupSetVolume(vgroup,percent*0.01)
endfunction
function SetCineModeVolumeGroupsImmediateBJ takes nothing returns nothing
call VolumeGroupSetVolume(SOUND_VOLUMEGROUP_UNITMOVEMENT,bj_CINEMODE_VOLUME_UNITMOVEMENT)
call VolumeGroupSetVolume(SOUND_VOLUMEGROUP_UNITSOUNDS,bj_CINEMODE_VOLUME_UNITSOUNDS)
call VolumeGroupSetVolume(SOUND_VOLUMEGROUP_COMBAT,bj_CINEMODE_VOLUME_COMBAT)
call VolumeGroupSetVolume(SOUND_VOLUMEGROUP_SPELLS,bj_CINEMODE_VOLUME_SPELLS)
call VolumeGroupSetVolume(SOUND_VOLUMEGROUP_UI,bj_CINEMODE_VOLUME_UI)
call VolumeGroupSetVolume(SOUND_VOLUMEGROUP_MUSIC,bj_CINEMODE_VOLUME_MUSIC)
call VolumeGroupSetVolume(SOUND_VOLUMEGROUP_AMBIENTSOUNDS,bj_CINEMODE_VOLUME_AMBIENTSOUNDS)
call VolumeGroupSetVolume(SOUND_VOLUMEGROUP_FIRE,bj_CINEMODE_VOLUME_FIRE)
endfunction
function SetCineModeVolumeGroupsBJ takes nothing returns nothing
if bj_gameStarted then
call SetCineModeVolumeGroupsImmediateBJ()
else
call TimerStart(bj_volumeGroupsTimer,bj_GAME_STARTED_THRESHOLD,false,function SetCineModeVolumeGroupsImmediateBJ)
endif
endfunction
function SetSpeechVolumeGroupsImmediateBJ takes nothing returns nothing
call VolumeGroupSetVolume(SOUND_VOLUMEGROUP_UNITMOVEMENT,bj_SPEECH_VOLUME_UNITMOVEMENT)
call VolumeGroupSetVolume(SOUND_VOLUMEGROUP_UNITSOUNDS,bj_SPEECH_VOLUME_UNITSOUNDS)
call VolumeGroupSetVolume(SOUND_VOLUMEGROUP_COMBAT,bj_SPEECH_VOLUME_COMBAT)
call VolumeGroupSetVolume(SOUND_VOLUMEGROUP_SPELLS,bj_SPEECH_VOLUME_SPELLS)
call VolumeGroupSetVolume(SOUND_VOLUMEGROUP_UI,bj_SPEECH_VOLUME_UI)
call VolumeGroupSetVolume(SOUND_VOLUMEGROUP_MUSIC,bj_SPEECH_VOLUME_MUSIC)
call VolumeGroupSetVolume(SOUND_VOLUMEGROUP_AMBIENTSOUNDS,bj_SPEECH_VOLUME_AMBIENTSOUNDS)
call VolumeGroupSetVolume(SOUND_VOLUMEGROUP_FIRE,bj_SPEECH_VOLUME_FIRE)
endfunction
function SetSpeechVolumeGroupsBJ takes nothing returns nothing
if bj_gameStarted then
call SetSpeechVolumeGroupsImmediateBJ()
else
call TimerStart(bj_volumeGroupsTimer,bj_GAME_STARTED_THRESHOLD,false,function SetSpeechVolumeGroupsImmediateBJ)
endif
endfunction
function VolumeGroupResetImmediateBJ takes nothing returns nothing
call VolumeGroupReset()
endfunction
function VolumeGroupResetBJ takes nothing returns nothing
if bj_gameStarted then
call VolumeGroupResetImmediateBJ()
else
call TimerStart(bj_volumeGroupsTimer,bj_GAME_STARTED_THRESHOLD,false,function VolumeGroupResetImmediateBJ)
endif
endfunction
function GetSoundIsPlayingBJ takes sound soundHandle returns boolean
return GetSoundIsLoading(soundHandle)or GetSoundIsPlaying(soundHandle)
endfunction
function WaitForSoundBJ takes sound soundHandle,real offset returns nothing
call TriggerWaitForSound(soundHandle,offset)
endfunction
function SetMapMusicIndexedBJ takes string musicName,integer index returns nothing
call SetMapMusic(musicName,false,index)
endfunction
function SetMapMusicRandomBJ takes string musicName returns nothing
call SetMapMusic(musicName,true,0)
endfunction
function ClearMapMusicBJ takes nothing returns nothing
call ClearMapMusic()
endfunction
function SetStackedSoundBJ takes boolean add,sound soundHandle,rect r returns nothing
local real width=GetRectMaxX(r)-GetRectMinX(r)
local real height=GetRectMaxY(r)-GetRectMinY(r)
call SetSoundPosition(soundHandle,GetRectCenterX(r),GetRectCenterY(r),0)
if add then
call RegisterStackedSound(soundHandle,true,width,height)
else
call UnregisterStackedSound(soundHandle,true,width,height)
endif
endfunction
function StartSoundForPlayerBJ takes player whichPlayer,sound soundHandle returns nothing
if(whichPlayer==GetLocalPlayer())then
call StartSound(soundHandle)
endif
endfunction
function VolumeGroupSetVolumeForPlayerBJ takes player whichPlayer,volumegroup vgroup,real scale returns nothing
if(GetLocalPlayer()==whichPlayer)then
call VolumeGroupSetVolume(vgroup,scale)
endif
endfunction
function EnableDawnDusk takes boolean flag returns nothing
set bj_useDawnDuskSounds=flag
endfunction
function IsDawnDuskEnabled takes nothing returns boolean
return bj_useDawnDuskSounds
endfunction
function SetAmbientDaySound takes string inLabel returns nothing
local real ToD
if(bj_dayAmbientSound!=null)then
call StopSound(bj_dayAmbientSound,true,true)
endif
set bj_dayAmbientSound=CreateMIDISound(inLabel,20,20)
set ToD=GetTimeOfDay()
if(ToD>=bj_TOD_DAWN and ToD<bj_TOD_DUSK)then
call StartSound(bj_dayAmbientSound)
endif
endfunction
function SetAmbientNightSound takes string inLabel returns nothing
local real ToD
if(bj_nightAmbientSound!=null)then
call StopSound(bj_nightAmbientSound,true,true)
endif
set bj_nightAmbientSound=CreateMIDISound(inLabel,20,20)
set ToD=GetTimeOfDay()
if(ToD<bj_TOD_DAWN or ToD>=bj_TOD_DUSK)then
call StartSound(bj_nightAmbientSound)
endif
endfunction
function AddSpecialEffectLocBJ takes location where,string modelName returns effect
set bj_lastCreatedEffect=AddSpecialEffectLoc(modelName,where)
return bj_lastCreatedEffect
endfunction
function AddSpecialEffectTargetUnitBJ takes string attachPointName,widget targetWidget,string modelName returns effect
set bj_lastCreatedEffect=AddSpecialEffectTarget(modelName,targetWidget,attachPointName)
return bj_lastCreatedEffect
endfunction
function DestroyEffectBJ takes effect whichEffect returns nothing
call DestroyEffect(whichEffect)
endfunction
function GetLastCreatedEffectBJ takes nothing returns effect
return bj_lastCreatedEffect
endfunction
function GetItemLoc takes item whichItem returns location
return Location(GetItemX(whichItem),GetItemY(whichItem))
endfunction
function GetItemLifeBJ takes widget whichWidget returns real
return GetWidgetLife(whichWidget)
endfunction
function SetItemLifeBJ takes widget whichWidget,real life returns nothing
call SetWidgetLife(whichWidget,life)
endfunction
function AddHeroXPSwapped takes integer xpToAdd,unit whichHero,boolean showEyeCandy returns nothing
call AddHeroXP(whichHero,xpToAdd,showEyeCandy)
endfunction
function SetHeroLevelBJ takes unit whichHero,integer newLevel,boolean showEyeCandy returns nothing
local integer oldLevel=GetHeroLevel(whichHero)
if(newLevel>oldLevel)then
call SetHeroLevel(whichHero,newLevel,showEyeCandy)
elseif(newLevel<oldLevel)then
call UnitStripHeroLevel(whichHero,oldLevel-newLevel)
else
endif
endfunction
function DecUnitAbilityLevelSwapped takes integer abilcode,unit whichUnit returns integer
return DecUnitAbilityLevel(whichUnit,abilcode)
endfunction
function IncUnitAbilityLevelSwapped takes integer abilcode,unit whichUnit returns integer
return IncUnitAbilityLevel(whichUnit,abilcode)
endfunction
function SetUnitAbilityLevelSwapped takes integer abilcode,unit whichUnit,integer level returns integer
return SetUnitAbilityLevel(whichUnit,abilcode,level)
endfunction
function GetUnitAbilityLevelSwapped takes integer abilcode,unit whichUnit returns integer
return GetUnitAbilityLevel(whichUnit,abilcode)
endfunction
function UnitHasBuffBJ takes unit whichUnit,integer buffcode returns boolean
return(GetUnitAbilityLevel(whichUnit,buffcode)>0)
endfunction
function UnitRemoveBuffBJ takes integer buffcode,unit whichUnit returns boolean
return UnitRemoveAbility(whichUnit,buffcode)
endfunction
function UnitAddItemSwapped takes item whichItem,unit whichHero returns boolean
return UnitAddItem(whichHero,whichItem)
endfunction
function UnitAddItemByIdSwapped takes integer itemId,unit whichHero returns item
set bj_lastCreatedItem=CreateItem(itemId,GetUnitX(whichHero),GetUnitY(whichHero))
call UnitAddItem(whichHero,bj_lastCreatedItem)
return bj_lastCreatedItem
endfunction
function UnitRemoveItemSwapped takes item whichItem,unit whichHero returns nothing
set bj_lastRemovedItem=whichItem
call UnitRemoveItem(whichHero,whichItem)
endfunction
function UnitRemoveItemFromSlotSwapped takes integer itemSlot,unit whichHero returns item
set bj_lastRemovedItem=UnitRemoveItemFromSlot(whichHero,itemSlot-1)
return bj_lastRemovedItem
endfunction
function CreateItemLoc takes integer itemId,location loc returns item
set bj_lastCreatedItem=CreateItem(itemId,GetLocationX(loc),GetLocationY(loc))
return bj_lastCreatedItem
endfunction
function GetLastCreatedItem takes nothing returns item
return bj_lastCreatedItem
endfunction
function GetLastRemovedItem takes nothing returns item
return bj_lastRemovedItem
endfunction
function SetItemPositionLoc takes item whichItem,location loc returns nothing
call SetItemPosition(whichItem,GetLocationX(loc),GetLocationY(loc))
endfunction
function GetLearnedSkillBJ takes nothing returns integer
return GetLearnedSkill()
endfunction
function SuspendHeroXPBJ takes boolean flag,unit whichHero returns nothing
call SuspendHeroXP(whichHero,not flag)
endfunction
function SetPlayerHandicapXPBJ takes player whichPlayer,real handicapPercent returns nothing
call SetPlayerHandicapXP(whichPlayer,handicapPercent*0.01)
endfunction
function GetPlayerHandicapXPBJ takes player whichPlayer returns real
return GetPlayerHandicapXP(whichPlayer)*100
endfunction
function SetPlayerHandicapBJ takes player whichPlayer,real handicapPercent returns nothing
call SetPlayerHandicap(whichPlayer,handicapPercent*0.01)
endfunction
function GetPlayerHandicapBJ takes player whichPlayer returns real
return GetPlayerHandicap(whichPlayer)*100
endfunction
function GetHeroStatBJ takes integer whichStat,unit whichHero,boolean includeBonuses returns integer
if(whichStat==bj_HEROSTAT_STR)then
return GetHeroStr(whichHero,includeBonuses)
elseif(whichStat==bj_HEROSTAT_AGI)then
return GetHeroAgi(whichHero,includeBonuses)
elseif(whichStat==bj_HEROSTAT_INT)then
return GetHeroInt(whichHero,includeBonuses)
else
return 0
endif
endfunction
function SetHeroStat takes unit whichHero,integer whichStat,integer value returns nothing
if(value<=0)then
return
endif
if(whichStat==bj_HEROSTAT_STR)then
call SetHeroStr(whichHero,value,true)
elseif(whichStat==bj_HEROSTAT_AGI)then
call SetHeroAgi(whichHero,value,true)
elseif(whichStat==bj_HEROSTAT_INT)then
call SetHeroInt(whichHero,value,true)
else
endif
endfunction
function ModifyHeroStat takes integer whichStat,unit whichHero,integer modifyMethod,integer value returns nothing
if(modifyMethod==bj_MODIFYMETHOD_ADD)then
call SetHeroStat(whichHero,whichStat,GetHeroStatBJ(whichStat,whichHero,false)+value)
elseif(modifyMethod==bj_MODIFYMETHOD_SUB)then
call SetHeroStat(whichHero,whichStat,GetHeroStatBJ(whichStat,whichHero,false)-value)
elseif(modifyMethod==bj_MODIFYMETHOD_SET)then
call SetHeroStat(whichHero,whichStat,value)
else
endif
endfunction
function ModifyHeroSkillPoints takes unit whichHero,integer modifyMethod,integer value returns boolean
if(modifyMethod==bj_MODIFYMETHOD_ADD)then
return UnitModifySkillPoints(whichHero,value)
elseif(modifyMethod==bj_MODIFYMETHOD_SUB)then
return UnitModifySkillPoints(whichHero,-value)
elseif(modifyMethod==bj_MODIFYMETHOD_SET)then
return UnitModifySkillPoints(whichHero,value-GetHeroSkillPoints(whichHero))
else
return false
endif
endfunction
function UnitDropItemPointBJ takes unit whichUnit,item whichItem,real x,real y returns boolean
return UnitDropItemPoint(whichUnit,whichItem,x,y)
endfunction
function UnitDropItemPointLoc takes unit whichUnit,item whichItem,location loc returns boolean
return UnitDropItemPoint(whichUnit,whichItem,GetLocationX(loc),GetLocationY(loc))
endfunction
function UnitDropItemSlotBJ takes unit whichUnit,item whichItem,integer slot returns boolean
return UnitDropItemSlot(whichUnit,whichItem,slot-1)
endfunction
function UnitDropItemTargetBJ takes unit whichUnit,item whichItem,widget target returns boolean
return UnitDropItemTarget(whichUnit,whichItem,target)
endfunction
function UnitUseItemDestructable takes unit whichUnit,item whichItem,widget target returns boolean
return UnitUseItemTarget(whichUnit,whichItem,target)
endfunction
function UnitUseItemPointLoc takes unit whichUnit,item whichItem,location loc returns boolean
return UnitUseItemPoint(whichUnit,whichItem,GetLocationX(loc),GetLocationY(loc))
endfunction
function UnitItemInSlotBJ takes unit whichUnit,integer itemSlot returns item
return UnitItemInSlot(whichUnit,itemSlot-1)
endfunction
function GetInventoryIndexOfItemTypeBJ takes unit whichUnit,integer itemId returns integer
local integer index
local item indexItem
set index=0
loop
set indexItem=UnitItemInSlot(whichUnit,index)
if(indexItem!=null)and(GetItemTypeId(indexItem)==itemId)then
return index+1
endif
set index=index+1
exitwhen index>=bj_MAX_INVENTORY
endloop
return 0
endfunction
function GetItemOfTypeFromUnitBJ takes unit whichUnit,integer itemId returns item
local integer index=GetInventoryIndexOfItemTypeBJ(whichUnit,itemId)
if(index==0)then
return null
else
return UnitItemInSlot(whichUnit,index-1)
endif
endfunction
function UnitHasItemOfTypeBJ takes unit whichUnit,integer itemId returns boolean
return GetInventoryIndexOfItemTypeBJ(whichUnit,itemId)>0
endfunction
function UnitInventoryCount takes unit whichUnit returns integer
local integer index=0
local integer count=0
loop
if(UnitItemInSlot(whichUnit,index)!=null)then
set count=count+1
endif
set index=index+1
exitwhen index>=bj_MAX_INVENTORY
endloop
return count
endfunction
function UnitInventorySizeBJ takes unit whichUnit returns integer
return UnitInventorySize(whichUnit)
endfunction
function SetItemInvulnerableBJ takes item whichItem,boolean flag returns nothing
call SetItemInvulnerable(whichItem,flag)
endfunction
function SetItemDropOnDeathBJ takes item whichItem,boolean flag returns nothing
call SetItemDropOnDeath(whichItem,flag)
endfunction
function SetItemDroppableBJ takes item whichItem,boolean flag returns nothing
call SetItemDroppable(whichItem,flag)
endfunction
function SetItemPlayerBJ takes item whichItem,player whichPlayer,boolean changeColor returns nothing
call SetItemPlayer(whichItem,whichPlayer,changeColor)
endfunction
function SetItemVisibleBJ takes boolean show,item whichItem returns nothing
call SetItemVisible(whichItem,show)
endfunction
function IsItemHiddenBJ takes item whichItem returns boolean
return not IsItemVisible(whichItem)
endfunction
function ChooseRandomItemBJ takes integer level returns integer
return ChooseRandomItem(level)
endfunction
function ChooseRandomItemExBJ takes integer level,itemtype whichType returns integer
return ChooseRandomItemEx(whichType,level)
endfunction
function ChooseRandomNPBuildingBJ takes nothing returns integer
return ChooseRandomNPBuilding()
endfunction
function ChooseRandomCreepBJ takes integer level returns integer
return ChooseRandomCreep(level)
endfunction
function EnumItemsInRectBJ takes rect r,code actionFunc returns nothing
call EnumItemsInRect(r,null,actionFunc)
endfunction
function RandomItemInRectBJEnum takes nothing returns nothing
set bj_itemRandomConsidered=bj_itemRandomConsidered+1
if(GetRandomInt(1,bj_itemRandomConsidered)==1)then
set bj_itemRandomCurrentPick=GetEnumItem()
endif
endfunction
function RandomItemInRectBJ takes rect r,boolexpr filter returns item
set bj_itemRandomConsidered=0
set bj_itemRandomCurrentPick=null
call EnumItemsInRect(r,filter,function RandomItemInRectBJEnum)
call DestroyBoolExpr(filter)
return bj_itemRandomCurrentPick
endfunction
function RandomItemInRectSimpleBJ takes rect r returns item
return RandomItemInRectBJ(r,null)
endfunction
function CheckItemStatus takes item whichItem,integer status returns boolean
if(status==bj_ITEM_STATUS_HIDDEN)then
return not IsItemVisible(whichItem)
elseif(status==bj_ITEM_STATUS_OWNED)then
return IsItemOwned(whichItem)
elseif(status==bj_ITEM_STATUS_INVULNERABLE)then
return IsItemInvulnerable(whichItem)
elseif(status==bj_ITEM_STATUS_POWERUP)then
return IsItemPowerup(whichItem)
elseif(status==bj_ITEM_STATUS_SELLABLE)then
return IsItemSellable(whichItem)
elseif(status==bj_ITEM_STATUS_PAWNABLE)then
return IsItemPawnable(whichItem)
else
return false
endif
endfunction
function CheckItemcodeStatus takes integer itemId,integer status returns boolean
if(status==bj_ITEMCODE_STATUS_POWERUP)then
return IsItemIdPowerup(itemId)
elseif(status==bj_ITEMCODE_STATUS_SELLABLE)then
return IsItemIdSellable(itemId)
elseif(status==bj_ITEMCODE_STATUS_PAWNABLE)then
return IsItemIdPawnable(itemId)
else
return false
endif
endfunction
function UnitId2OrderIdBJ takes integer unitId returns integer
return unitId
endfunction
function String2UnitIdBJ takes string unitIdString returns integer
return UnitId(unitIdString)
endfunction
function UnitId2StringBJ takes integer unitId returns string
local string unitString=UnitId2String(unitId)
if(unitString!=null)then
return unitString
endif
return ""
endfunction
function String2OrderIdBJ takes string orderIdString returns integer
local integer orderId
set orderId=OrderId(orderIdString)
if(orderId!=0)then
return orderId
endif
set orderId=UnitId(orderIdString)
if(orderId!=0)then
return orderId
endif
return 0
endfunction
function OrderId2StringBJ takes integer orderId returns string
local string orderString
set orderString=OrderId2String(orderId)
if(orderString!=null)then
return orderString
endif
set orderString=UnitId2String(orderId)
if(orderString!=null)then
return orderString
endif
return ""
endfunction
function GetIssuedOrderIdBJ takes nothing returns integer
return GetIssuedOrderId()
endfunction
function GetKillingUnitBJ takes nothing returns unit
return GetKillingUnit()
endfunction
function CreateUnitAtLocSaveLast takes player id,integer unitid,location loc,real face returns unit
if(unitid=='ugol')then
set bj_lastCreatedUnit=CreateBlightedGoldmine(id,GetLocationX(loc),GetLocationY(loc),face)
else
set bj_lastCreatedUnit=CreateUnitAtLoc(id,unitid,loc,face)
endif
return bj_lastCreatedUnit
endfunction
function GetLastCreatedUnit takes nothing returns unit
return bj_lastCreatedUnit
endfunction
function CreateNUnitsAtLoc takes integer count,integer unitId,player whichPlayer,location loc,real face returns group
call GroupClear(bj_lastCreatedGroup)
loop
set count=count-1
exitwhen count<0
call CreateUnitAtLocSaveLast(whichPlayer,unitId,loc,face)
call GroupAddUnit(bj_lastCreatedGroup,bj_lastCreatedUnit)
endloop
return bj_lastCreatedGroup
endfunction
function CreateNUnitsAtLocFacingLocBJ takes integer count,integer unitId,player whichPlayer,location loc,location lookAt returns group
return CreateNUnitsAtLoc(count,unitId,whichPlayer,loc,AngleBetweenPoints(loc,lookAt))
endfunction
function GetLastCreatedGroupEnum takes nothing returns nothing
call GroupAddUnit(bj_groupLastCreatedDest,GetEnumUnit())
endfunction
function GetLastCreatedGroup takes nothing returns group
set bj_groupLastCreatedDest=CreateGroup()
call ForGroup(bj_lastCreatedGroup,function GetLastCreatedGroupEnum)
return bj_groupLastCreatedDest
endfunction
function CreateCorpseLocBJ takes integer unitid,player whichPlayer,location loc returns unit
set bj_lastCreatedUnit=CreateCorpse(whichPlayer,unitid,GetLocationX(loc),GetLocationY(loc),GetRandomReal(0,360))
return bj_lastCreatedUnit
endfunction
function UnitSuspendDecayBJ takes boolean suspend,unit whichUnit returns nothing
call UnitSuspendDecay(whichUnit,suspend)
endfunction
function DelayedSuspendDecayStopAnimEnum takes nothing returns nothing
local unit enumUnit=GetEnumUnit()
if(GetUnitState(enumUnit,UNIT_STATE_LIFE)<=0)then
call SetUnitTimeScale(enumUnit,0.0001)
endif
endfunction
function DelayedSuspendDecayBoneEnum takes nothing returns nothing
local unit enumUnit=GetEnumUnit()
if(GetUnitState(enumUnit,UNIT_STATE_LIFE)<=0)then
call UnitSuspendDecay(enumUnit,true)
call SetUnitTimeScale(enumUnit,0.0001)
endif
endfunction
function DelayedSuspendDecayFleshEnum takes nothing returns nothing
local unit enumUnit=GetEnumUnit()
if(GetUnitState(enumUnit,UNIT_STATE_LIFE)<=0)then
call UnitSuspendDecay(enumUnit,true)
call SetUnitTimeScale(enumUnit,10.0)
call SetUnitAnimation(enumUnit,"decay flesh")
endif
endfunction
function DelayedSuspendDecay takes nothing returns nothing
local group boneGroup
local group fleshGroup
set boneGroup=bj_suspendDecayBoneGroup
set fleshGroup=bj_suspendDecayFleshGroup
set bj_suspendDecayBoneGroup=CreateGroup()
set bj_suspendDecayFleshGroup=CreateGroup()
call ForGroup(fleshGroup,function DelayedSuspendDecayStopAnimEnum)
call ForGroup(boneGroup,function DelayedSuspendDecayStopAnimEnum)
call TriggerSleepAction(bj_CORPSE_MAX_DEATH_TIME)
call ForGroup(fleshGroup,function DelayedSuspendDecayFleshEnum)
call ForGroup(boneGroup,function DelayedSuspendDecayBoneEnum)
call TriggerSleepAction(0.05)
call ForGroup(fleshGroup,function DelayedSuspendDecayStopAnimEnum)
call DestroyGroup(boneGroup)
call DestroyGroup(fleshGroup)
endfunction
function DelayedSuspendDecayCreate takes nothing returns nothing
set bj_delayedSuspendDecayTrig=CreateTrigger()
call TriggerRegisterTimerExpireEvent(bj_delayedSuspendDecayTrig,bj_delayedSuspendDecayTimer)
call TriggerAddAction(bj_delayedSuspendDecayTrig,function DelayedSuspendDecay)
endfunction
function CreatePermanentCorpseLocBJ takes integer style,integer unitid,player whichPlayer,location loc,real facing returns unit
set bj_lastCreatedUnit=CreateCorpse(whichPlayer,unitid,GetLocationX(loc),GetLocationY(loc),facing)
call SetUnitBlendTime(bj_lastCreatedUnit,0)
if(style==bj_CORPSETYPE_FLESH)then
call SetUnitAnimation(bj_lastCreatedUnit,"decay flesh")
call GroupAddUnit(bj_suspendDecayFleshGroup,bj_lastCreatedUnit)
elseif(style==bj_CORPSETYPE_BONE)then
call SetUnitAnimation(bj_lastCreatedUnit,"decay bone")
call GroupAddUnit(bj_suspendDecayBoneGroup,bj_lastCreatedUnit)
else
call SetUnitAnimation(bj_lastCreatedUnit,"decay bone")
call GroupAddUnit(bj_suspendDecayBoneGroup,bj_lastCreatedUnit)
endif
call TimerStart(bj_delayedSuspendDecayTimer,0.05,false,null)
return bj_lastCreatedUnit
endfunction
function GetUnitStateSwap takes unitstate whichState,unit whichUnit returns real
return GetUnitState(whichUnit,whichState)
endfunction
function GetUnitStatePercent takes unit whichUnit,unitstate whichState,unitstate whichMaxState returns real
local real value=GetUnitState(whichUnit,whichState)
local real maxValue=GetUnitState(whichUnit,whichMaxState)
if(whichUnit==null)or(maxValue==0)then
return 0.0
endif
return value/maxValue*100.0
endfunction
function GetUnitLifePercent takes unit whichUnit returns real
return GetUnitStatePercent(whichUnit,UNIT_STATE_LIFE,UNIT_STATE_MAX_LIFE)
endfunction
function GetUnitManaPercent takes unit whichUnit returns real
return GetUnitStatePercent(whichUnit,UNIT_STATE_MANA,UNIT_STATE_MAX_MANA)
endfunction
function SelectUnitSingle takes unit whichUnit returns nothing
call ClearSelection()
call SelectUnit(whichUnit,true)
endfunction
function SelectGroupBJEnum takes nothing returns nothing
call SelectUnit(GetEnumUnit(),true)
endfunction
function SelectGroupBJ takes group g returns nothing
call ClearSelection()
call ForGroup(g,function SelectGroupBJEnum)
endfunction
function SelectUnitAdd takes unit whichUnit returns nothing
call SelectUnit(whichUnit,true)
endfunction
function SelectUnitRemove takes unit whichUnit returns nothing
call SelectUnit(whichUnit,false)
endfunction
function ClearSelectionForPlayer takes player whichPlayer returns nothing
if(GetLocalPlayer()==whichPlayer)then
call ClearSelection()
endif
endfunction
function SelectUnitForPlayerSingle takes unit whichUnit,player whichPlayer returns nothing
if(GetLocalPlayer()==whichPlayer)then
call ClearSelection()
call SelectUnit(whichUnit,true)
endif
endfunction
function SelectGroupForPlayerBJ takes group g,player whichPlayer returns nothing
if(GetLocalPlayer()==whichPlayer)then
call ClearSelection()
call ForGroup(g,function SelectGroupBJEnum)
endif
endfunction
function SelectUnitAddForPlayer takes unit whichUnit,player whichPlayer returns nothing
if(GetLocalPlayer()==whichPlayer)then
call SelectUnit(whichUnit,true)
endif
endfunction
function SelectUnitRemoveForPlayer takes unit whichUnit,player whichPlayer returns nothing
if(GetLocalPlayer()==whichPlayer)then
call SelectUnit(whichUnit,false)
endif
endfunction
function SetUnitLifeBJ takes unit whichUnit,real newValue returns nothing
call SetUnitState(whichUnit,UNIT_STATE_LIFE,RMaxBJ(0,newValue))
endfunction
function SetUnitManaBJ takes unit whichUnit,real newValue returns nothing
call SetUnitState(whichUnit,UNIT_STATE_MANA,RMaxBJ(0,newValue))
endfunction
function SetUnitLifePercentBJ takes unit whichUnit,real percent returns nothing
call SetUnitState(whichUnit,UNIT_STATE_LIFE,GetUnitState(whichUnit,UNIT_STATE_MAX_LIFE)*RMaxBJ(0,percent)*0.01)
endfunction
function SetUnitManaPercentBJ takes unit whichUnit,real percent returns nothing
call SetUnitState(whichUnit,UNIT_STATE_MANA,GetUnitState(whichUnit,UNIT_STATE_MAX_MANA)*RMaxBJ(0,percent)*0.01)
endfunction
function IsUnitDeadBJ takes unit whichUnit returns boolean
return GetUnitState(whichUnit,UNIT_STATE_LIFE)<=0
endfunction
function IsUnitAliveBJ takes unit whichUnit returns boolean
return not IsUnitDeadBJ(whichUnit)
endfunction
function IsUnitGroupDeadBJEnum takes nothing returns nothing
if not IsUnitDeadBJ(GetEnumUnit())then
set bj_isUnitGroupDeadResult=false
endif
endfunction
function IsUnitGroupDeadBJ takes group g returns boolean
local boolean wantDestroy=bj_wantDestroyGroup
set bj_wantDestroyGroup=false
set bj_isUnitGroupDeadResult=true
call ForGroup(g,function IsUnitGroupDeadBJEnum)
if(wantDestroy)then
call DestroyGroup(g)
endif
return bj_isUnitGroupDeadResult
endfunction
function IsUnitGroupEmptyBJEnum takes nothing returns nothing
set bj_isUnitGroupEmptyResult=false
endfunction
function IsUnitGroupEmptyBJ takes group g returns boolean
local boolean wantDestroy=bj_wantDestroyGroup
set bj_wantDestroyGroup=false
set bj_isUnitGroupEmptyResult=true
call ForGroup(g,function IsUnitGroupEmptyBJEnum)
if(wantDestroy)then
call DestroyGroup(g)
endif
return bj_isUnitGroupEmptyResult
endfunction
function IsUnitGroupInRectBJEnum takes nothing returns nothing
if not RectContainsUnit(bj_isUnitGroupInRectRect,GetEnumUnit())then
set bj_isUnitGroupInRectResult=false
endif
endfunction
function IsUnitGroupInRectBJ takes group g,rect r returns boolean
set bj_isUnitGroupInRectResult=true
set bj_isUnitGroupInRectRect=r
call ForGroup(g,function IsUnitGroupInRectBJEnum)
return bj_isUnitGroupInRectResult
endfunction
function IsUnitHiddenBJ takes unit whichUnit returns boolean
return IsUnitHidden(whichUnit)
endfunction
function ShowUnitHide takes unit whichUnit returns nothing
call ShowUnit(whichUnit,false)
endfunction
function ShowUnitShow takes unit whichUnit returns nothing
if(IsUnitType(whichUnit,UNIT_TYPE_HERO)and IsUnitDeadBJ(whichUnit))then
return
endif
call ShowUnit(whichUnit,true)
endfunction
function IssueHauntOrderAtLocBJFilter takes nothing returns boolean
return GetUnitTypeId(GetFilterUnit())=='ngol'
endfunction
function IssueHauntOrderAtLocBJ takes unit whichPeon,location loc returns boolean
local group g=null
local unit goldMine=null
set g=CreateGroup()
call GroupEnumUnitsInRangeOfLoc(g,loc,2*bj_CELLWIDTH,filterIssueHauntOrderAtLocBJ)
set goldMine=FirstOfGroup(g)
call DestroyGroup(g)
if(goldMine==null)then
return false
endif
return IssueTargetOrderById(whichPeon,'ugol',goldMine)
endfunction
function IssueBuildOrderByIdLocBJ takes unit whichPeon,integer unitId,location loc returns boolean
if(unitId=='ugol')then
return IssueHauntOrderAtLocBJ(whichPeon,loc)
else
return IssueBuildOrderById(whichPeon,unitId,GetLocationX(loc),GetLocationY(loc))
endif
endfunction
function IssueTrainOrderByIdBJ takes unit whichUnit,integer unitId returns boolean
return IssueImmediateOrderById(whichUnit,unitId)
endfunction
function GroupTrainOrderByIdBJ takes group g,integer unitId returns boolean
return GroupImmediateOrderById(g,unitId)
endfunction
function IssueUpgradeOrderByIdBJ takes unit whichUnit,integer techId returns boolean
return IssueImmediateOrderById(whichUnit,techId)
endfunction
function GetAttackedUnitBJ takes nothing returns unit
return GetTriggerUnit()
endfunction
function SetUnitFlyHeightBJ takes unit whichUnit,real newHeight,real rate returns nothing
call SetUnitFlyHeight(whichUnit,newHeight,rate)
endfunction
function SetUnitTurnSpeedBJ takes unit whichUnit,real turnSpeed returns nothing
call SetUnitTurnSpeed(whichUnit,turnSpeed)
endfunction
function SetUnitPropWindowBJ takes unit whichUnit,real propWindow returns nothing
local real angle=propWindow
if(angle<=0)then
set angle=1
elseif(angle>=360)then
set angle=359
endif
set angle=angle*bj_DEGTORAD
call SetUnitPropWindow(whichUnit,angle)
endfunction
function GetUnitPropWindowBJ takes unit whichUnit returns real
return GetUnitPropWindow(whichUnit)*bj_RADTODEG
endfunction
function GetUnitDefaultPropWindowBJ takes unit whichUnit returns real
return GetUnitDefaultPropWindow(whichUnit)
endfunction
function SetUnitBlendTimeBJ takes unit whichUnit,real blendTime returns nothing
call SetUnitBlendTime(whichUnit,blendTime)
endfunction
function SetUnitAcquireRangeBJ takes unit whichUnit,real acquireRange returns nothing
call SetUnitAcquireRange(whichUnit,acquireRange)
endfunction
function UnitSetCanSleepBJ takes unit whichUnit,boolean canSleep returns nothing
call UnitAddSleep(whichUnit,canSleep)
endfunction
function UnitCanSleepBJ takes unit whichUnit returns boolean
return UnitCanSleep(whichUnit)
endfunction
function UnitWakeUpBJ takes unit whichUnit returns nothing
call UnitWakeUp(whichUnit)
endfunction
function UnitIsSleepingBJ takes unit whichUnit returns boolean
return UnitIsSleeping(whichUnit)
endfunction
function WakePlayerUnitsEnum takes nothing returns nothing
call UnitWakeUp(GetEnumUnit())
endfunction
function WakePlayerUnits takes player whichPlayer returns nothing
local group g=CreateGroup()
call GroupEnumUnitsOfPlayer(g,whichPlayer,null)
call ForGroup(g,function WakePlayerUnitsEnum)
call DestroyGroup(g)
endfunction
function EnableCreepSleepBJ takes boolean enable returns nothing
call SetPlayerState(Player(PLAYER_NEUTRAL_AGGRESSIVE),PLAYER_STATE_NO_CREEP_SLEEP,IntegerTertiaryOp(enable,0,1))
if(not enable)then
call WakePlayerUnits(Player(PLAYER_NEUTRAL_AGGRESSIVE))
endif
endfunction
function UnitGenerateAlarms takes unit whichUnit,boolean generate returns boolean
return UnitIgnoreAlarm(whichUnit,not generate)
endfunction
function DoesUnitGenerateAlarms takes unit whichUnit returns boolean
return not UnitIgnoreAlarmToggled(whichUnit)
endfunction
function PauseAllUnitsBJEnum takes nothing returns nothing
call PauseUnit(GetEnumUnit(),bj_pauseAllUnitsFlag)
endfunction
function PauseAllUnitsBJ takes boolean pause returns nothing
local integer index
local player indexPlayer
local group g
set bj_pauseAllUnitsFlag=pause
set g=CreateGroup()
set index=0
loop
set indexPlayer=Player(index)
if(GetPlayerController(indexPlayer)==MAP_CONTROL_COMPUTER)then
call PauseCompAI(indexPlayer,pause)
endif
call GroupEnumUnitsOfPlayer(g,indexPlayer,null)
call ForGroup(g,function PauseAllUnitsBJEnum)
call GroupClear(g)
set index=index+1
exitwhen index==bj_MAX_PLAYER_SLOTS
endloop
call DestroyGroup(g)
endfunction
function PauseUnitBJ takes boolean pause,unit whichUnit returns nothing
call PauseUnit(whichUnit,pause)
endfunction
function IsUnitPausedBJ takes unit whichUnit returns boolean
return IsUnitPaused(whichUnit)
endfunction
function UnitPauseTimedLifeBJ takes boolean flag,unit whichUnit returns nothing
call UnitPauseTimedLife(whichUnit,flag)
endfunction
function UnitApplyTimedLifeBJ takes real duration,integer buffId,unit whichUnit returns nothing
call UnitApplyTimedLife(whichUnit,buffId,duration)
endfunction
function UnitShareVisionBJ takes boolean share,unit whichUnit,player whichPlayer returns nothing
call UnitShareVision(whichUnit,whichPlayer,share)
endfunction
function UnitRemoveBuffsBJ takes integer buffType,unit whichUnit returns nothing
if(buffType==bj_REMOVEBUFFS_POSITIVE)then
call UnitRemoveBuffs(whichUnit,true,false)
elseif(buffType==bj_REMOVEBUFFS_NEGATIVE)then
call UnitRemoveBuffs(whichUnit,false,true)
elseif(buffType==bj_REMOVEBUFFS_ALL)then
call UnitRemoveBuffs(whichUnit,true,true)
elseif(buffType==bj_REMOVEBUFFS_NONTLIFE)then
call UnitRemoveBuffsEx(whichUnit,true,true,false,false,false,true,false)
else
endif
endfunction
function UnitRemoveBuffsExBJ takes integer polarity,integer resist,unit whichUnit,boolean bTLife,boolean bAura returns nothing
local boolean bPos=(polarity==bj_BUFF_POLARITY_EITHER)or(polarity==bj_BUFF_POLARITY_POSITIVE)
local boolean bNeg=(polarity==bj_BUFF_POLARITY_EITHER)or(polarity==bj_BUFF_POLARITY_NEGATIVE)
local boolean bMagic=(resist==bj_BUFF_RESIST_BOTH)or(resist==bj_BUFF_RESIST_MAGIC)
local boolean bPhys=(resist==bj_BUFF_RESIST_BOTH)or(resist==bj_BUFF_RESIST_PHYSICAL)
call UnitRemoveBuffsEx(whichUnit,bPos,bNeg,bMagic,bPhys,bTLife,bAura,false)
endfunction
function UnitCountBuffsExBJ takes integer polarity,integer resist,unit whichUnit,boolean bTLife,boolean bAura returns integer
local boolean bPos=(polarity==bj_BUFF_POLARITY_EITHER)or(polarity==bj_BUFF_POLARITY_POSITIVE)
local boolean bNeg=(polarity==bj_BUFF_POLARITY_EITHER)or(polarity==bj_BUFF_POLARITY_NEGATIVE)
local boolean bMagic=(resist==bj_BUFF_RESIST_BOTH)or(resist==bj_BUFF_RESIST_MAGIC)
local boolean bPhys=(resist==bj_BUFF_RESIST_BOTH)or(resist==bj_BUFF_RESIST_PHYSICAL)
return UnitCountBuffsEx(whichUnit,bPos,bNeg,bMagic,bPhys,bTLife,bAura,false)
endfunction
function UnitRemoveAbilityBJ takes integer abilityId,unit whichUnit returns boolean
return UnitRemoveAbility(whichUnit,abilityId)
endfunction
function UnitAddAbilityBJ takes integer abilityId,unit whichUnit returns boolean
return UnitAddAbility(whichUnit,abilityId)
endfunction
function UnitRemoveTypeBJ takes unittype whichType,unit whichUnit returns boolean
return UnitRemoveType(whichUnit,whichType)
endfunction
function UnitAddTypeBJ takes unittype whichType,unit whichUnit returns boolean
return UnitAddType(whichUnit,whichType)
endfunction
function UnitMakeAbilityPermanentBJ takes boolean permanent,integer abilityId,unit whichUnit returns boolean
return UnitMakeAbilityPermanent(whichUnit,permanent,abilityId)
endfunction
function SetUnitExplodedBJ takes unit whichUnit,boolean exploded returns nothing
call SetUnitExploded(whichUnit,exploded)
endfunction
function ExplodeUnitBJ takes unit whichUnit returns nothing
call SetUnitExploded(whichUnit,true)
call KillUnit(whichUnit)
endfunction
function GetTransportUnitBJ takes nothing returns unit
return GetTransportUnit()
endfunction
function GetLoadedUnitBJ takes nothing returns unit
return GetLoadedUnit()
endfunction
function IsUnitInTransportBJ takes unit whichUnit,unit whichTransport returns boolean
return IsUnitInTransport(whichUnit,whichTransport)
endfunction
function IsUnitLoadedBJ takes unit whichUnit returns boolean
return IsUnitLoaded(whichUnit)
endfunction
function IsUnitIllusionBJ takes unit whichUnit returns boolean
return IsUnitIllusion(whichUnit)
endfunction
function ReplaceUnitBJ takes unit whichUnit,integer newUnitId,integer unitStateMethod returns unit
local unit oldUnit=whichUnit
local unit newUnit
local boolean wasHidden
local integer index
local item indexItem
local real oldRatio
if(oldUnit==null)then
set bj_lastReplacedUnit=oldUnit
return oldUnit
endif
set wasHidden=IsUnitHidden(oldUnit)
call ShowUnit(oldUnit,false)
if(newUnitId=='ugol')then
set newUnit=CreateBlightedGoldmine(GetOwningPlayer(oldUnit),GetUnitX(oldUnit),GetUnitY(oldUnit),GetUnitFacing(oldUnit))
else
set newUnit=CreateUnit(GetOwningPlayer(oldUnit),newUnitId,GetUnitX(oldUnit),GetUnitY(oldUnit),GetUnitFacing(oldUnit))
endif
if(unitStateMethod==bj_UNIT_STATE_METHOD_RELATIVE)then
if(GetUnitState(oldUnit,UNIT_STATE_MAX_LIFE)>0)then
set oldRatio=GetUnitState(oldUnit,UNIT_STATE_LIFE)/GetUnitState(oldUnit,UNIT_STATE_MAX_LIFE)
call SetUnitState(newUnit,UNIT_STATE_LIFE,oldRatio*GetUnitState(newUnit,UNIT_STATE_MAX_LIFE))
endif
if(GetUnitState(oldUnit,UNIT_STATE_MAX_MANA)>0)and(GetUnitState(newUnit,UNIT_STATE_MAX_MANA)>0)then
set oldRatio=GetUnitState(oldUnit,UNIT_STATE_MANA)/GetUnitState(oldUnit,UNIT_STATE_MAX_MANA)
call SetUnitState(newUnit,UNIT_STATE_MANA,oldRatio*GetUnitState(newUnit,UNIT_STATE_MAX_MANA))
endif
elseif(unitStateMethod==bj_UNIT_STATE_METHOD_ABSOLUTE)then
call SetUnitState(newUnit,UNIT_STATE_LIFE,GetUnitState(oldUnit,UNIT_STATE_LIFE))
if(GetUnitState(newUnit,UNIT_STATE_MAX_MANA)>0)then
call SetUnitState(newUnit,UNIT_STATE_MANA,GetUnitState(oldUnit,UNIT_STATE_MANA))
endif
elseif(unitStateMethod==bj_UNIT_STATE_METHOD_DEFAULTS)then
elseif(unitStateMethod==bj_UNIT_STATE_METHOD_MAXIMUM)then
call SetUnitState(newUnit,UNIT_STATE_LIFE,GetUnitState(newUnit,UNIT_STATE_MAX_LIFE))
call SetUnitState(newUnit,UNIT_STATE_MANA,GetUnitState(newUnit,UNIT_STATE_MAX_MANA))
else
endif
call SetResourceAmount(newUnit,GetResourceAmount(oldUnit))
if(IsUnitType(oldUnit,UNIT_TYPE_HERO)and IsUnitType(newUnit,UNIT_TYPE_HERO))then
call SetHeroXP(newUnit,GetHeroXP(oldUnit),false)
set index=0
loop
set indexItem=UnitItemInSlot(oldUnit,index)
if(indexItem!=null)then
call UnitRemoveItem(oldUnit,indexItem)
call UnitAddItem(newUnit,indexItem)
endif
set index=index+1
exitwhen index>=bj_MAX_INVENTORY
endloop
endif
if wasHidden then
call KillUnit(oldUnit)
call RemoveUnit(oldUnit)
else
call RemoveUnit(oldUnit)
endif
set bj_lastReplacedUnit=newUnit
return newUnit
endfunction
function GetLastReplacedUnitBJ takes nothing returns unit
return bj_lastReplacedUnit
endfunction
function SetUnitPositionLocFacingBJ takes unit whichUnit,location loc,real facing returns nothing
call SetUnitPositionLoc(whichUnit,loc)
call SetUnitFacing(whichUnit,facing)
endfunction
function SetUnitPositionLocFacingLocBJ takes unit whichUnit,location loc,location lookAt returns nothing
call SetUnitPositionLoc(whichUnit,loc)
call SetUnitFacing(whichUnit,AngleBetweenPoints(loc,lookAt))
endfunction
function AddItemToStockBJ takes integer itemId,unit whichUnit,integer currentStock,integer stockMax returns nothing
call AddItemToStock(whichUnit,itemId,currentStock,stockMax)
endfunction
function AddUnitToStockBJ takes integer unitId,unit whichUnit,integer currentStock,integer stockMax returns nothing
call AddUnitToStock(whichUnit,unitId,currentStock,stockMax)
endfunction
function RemoveItemFromStockBJ takes integer itemId,unit whichUnit returns nothing
call RemoveItemFromStock(whichUnit,itemId)
endfunction
function RemoveUnitFromStockBJ takes integer unitId,unit whichUnit returns nothing
call RemoveUnitFromStock(whichUnit,unitId)
endfunction
function SetUnitUseFoodBJ takes boolean enable,unit whichUnit returns nothing
call SetUnitUseFood(whichUnit,enable)
endfunction
function UnitDamagePointLoc takes unit whichUnit,real delay,real radius,location loc,real amount,attacktype whichAttack,damagetype whichDamage returns boolean
return UnitDamagePoint(whichUnit,delay,radius,GetLocationX(loc),GetLocationY(loc),amount,true,false,whichAttack,whichDamage,WEAPON_TYPE_WHOKNOWS)
endfunction
function UnitDamageTargetBJ takes unit whichUnit,unit target,real amount,attacktype whichAttack,damagetype whichDamage returns boolean
return UnitDamageTarget(whichUnit,target,amount,true,false,whichAttack,whichDamage,WEAPON_TYPE_WHOKNOWS)
endfunction
function CreateDestructableLoc takes integer objectid,location loc,real facing,real scale,integer variation returns destructable
set bj_lastCreatedDestructable=CreateDestructable(objectid,GetLocationX(loc),GetLocationY(loc),facing,scale,variation)
return bj_lastCreatedDestructable
endfunction
function CreateDeadDestructableLocBJ takes integer objectid,location loc,real facing,real scale,integer variation returns destructable
set bj_lastCreatedDestructable=CreateDeadDestructable(objectid,GetLocationX(loc),GetLocationY(loc),facing,scale,variation)
return bj_lastCreatedDestructable
endfunction
function GetLastCreatedDestructable takes nothing returns destructable
return bj_lastCreatedDestructable
endfunction
function ShowDestructableBJ takes boolean flag,destructable d returns nothing
call ShowDestructable(d,flag)
endfunction
function SetDestructableInvulnerableBJ takes destructable d,boolean flag returns nothing
call SetDestructableInvulnerable(d,flag)
endfunction
function IsDestructableInvulnerableBJ takes destructable d returns boolean
return IsDestructableInvulnerable(d)
endfunction
function GetDestructableLoc takes destructable whichDestructable returns location
return Location(GetDestructableX(whichDestructable),GetDestructableY(whichDestructable))
endfunction
function EnumDestructablesInRectAll takes rect r,code actionFunc returns nothing
call EnumDestructablesInRect(r,null,actionFunc)
endfunction
function EnumDestructablesInCircleBJFilter takes nothing returns boolean
local location destLoc=GetDestructableLoc(GetFilterDestructable())
local boolean result
set result=DistanceBetweenPoints(destLoc,bj_enumDestructableCenter)<=bj_enumDestructableRadius
call RemoveLocation(destLoc)
return result
endfunction
function IsDestructableDeadBJ takes destructable d returns boolean
return GetDestructableLife(d)<=0
endfunction
function IsDestructableAliveBJ takes destructable d returns boolean
return not IsDestructableDeadBJ(d)
endfunction
function RandomDestructableInRectBJEnum takes nothing returns nothing
set bj_destRandomConsidered=bj_destRandomConsidered+1
if(GetRandomInt(1,bj_destRandomConsidered)==1)then
set bj_destRandomCurrentPick=GetEnumDestructable()
endif
endfunction
function RandomDestructableInRectBJ takes rect r,boolexpr filter returns destructable
set bj_destRandomConsidered=0
set bj_destRandomCurrentPick=null
call EnumDestructablesInRect(r,filter,function RandomDestructableInRectBJEnum)
call DestroyBoolExpr(filter)
return bj_destRandomCurrentPick
endfunction
function RandomDestructableInRectSimpleBJ takes rect r returns destructable
return RandomDestructableInRectBJ(r,null)
endfunction
function EnumDestructablesInCircleBJ takes real radius,location loc,code actionFunc returns nothing
local rect r
if(radius>=0)then
set bj_enumDestructableCenter=loc
set bj_enumDestructableRadius=radius
set r=GetRectFromCircleBJ(loc,radius)
call EnumDestructablesInRect(r,filterEnumDestructablesInCircleBJ,actionFunc)
call RemoveRect(r)
endif
endfunction
function SetDestructableLifePercentBJ takes destructable d,real percent returns nothing
call SetDestructableLife(d,GetDestructableMaxLife(d)*percent*0.01)
endfunction
function SetDestructableMaxLifeBJ takes destructable d,real max returns nothing
call SetDestructableMaxLife(d,max)
endfunction
function ModifyGateBJ takes integer gateOperation,destructable d returns nothing
if(gateOperation==bj_GATEOPERATION_CLOSE)then
if(GetDestructableLife(d)<=0)then
call DestructableRestoreLife(d,GetDestructableMaxLife(d),true)
endif
call SetDestructableAnimation(d,"stand")
elseif(gateOperation==bj_GATEOPERATION_OPEN)then
if(GetDestructableLife(d)>0)then
call KillDestructable(d)
endif
call SetDestructableAnimation(d,"death alternate")
elseif(gateOperation==bj_GATEOPERATION_DESTROY)then
if(GetDestructableLife(d)>0)then
call KillDestructable(d)
endif
call SetDestructableAnimation(d,"death")
else
endif
endfunction
function GetElevatorHeight takes destructable d returns integer
local integer height
set height=1+R2I(GetDestructableOccluderHeight(d)/bj_CLIFFHEIGHT)
if(height<1)or(height>3)then
set height=1
endif
return height
endfunction
function ChangeElevatorHeight takes destructable d,integer newHeight returns nothing
local integer oldHeight
set newHeight=IMaxBJ(1,newHeight)
set newHeight=IMinBJ(3,newHeight)
set oldHeight=GetElevatorHeight(d)
call SetDestructableOccluderHeight(d,bj_CLIFFHEIGHT*(newHeight-1))
if(newHeight==1)then
if(oldHeight==2)then
call SetDestructableAnimation(d,"birth")
call QueueDestructableAnimation(d,"stand")
elseif(oldHeight==3)then
call SetDestructableAnimation(d,"birth third")
call QueueDestructableAnimation(d,"stand")
else
call SetDestructableAnimation(d,"stand")
endif
elseif(newHeight==2)then
if(oldHeight==1)then
call SetDestructableAnimation(d,"death")
call QueueDestructableAnimation(d,"stand second")
elseif(oldHeight==3)then
call SetDestructableAnimation(d,"birth second")
call QueueDestructableAnimation(d,"stand second")
else
call SetDestructableAnimation(d,"stand second")
endif
elseif(newHeight==3)then
if(oldHeight==1)then
call SetDestructableAnimation(d,"death third")
call QueueDestructableAnimation(d,"stand third")
elseif(oldHeight==2)then
call SetDestructableAnimation(d,"death second")
call QueueDestructableAnimation(d,"stand third")
else
call SetDestructableAnimation(d,"stand third")
endif
else
endif
endfunction
function NudgeUnitsInRectEnum takes nothing returns nothing
local unit nudgee=GetEnumUnit()
call SetUnitPosition(nudgee,GetUnitX(nudgee),GetUnitY(nudgee))
endfunction
function NudgeItemsInRectEnum takes nothing returns nothing
local item nudgee=GetEnumItem()
call SetItemPosition(nudgee,GetItemX(nudgee),GetItemY(nudgee))
endfunction
function NudgeObjectsInRect takes rect nudgeArea returns nothing
local group g
set g=CreateGroup()
call GroupEnumUnitsInRect(g,nudgeArea,null)
call ForGroup(g,function NudgeUnitsInRectEnum)
call DestroyGroup(g)
call EnumItemsInRect(nudgeArea,null,function NudgeItemsInRectEnum)
endfunction
function NearbyElevatorExistsEnum takes nothing returns nothing
local destructable d=GetEnumDestructable()
local integer dType=GetDestructableTypeId(d)
if(dType==bj_ELEVATOR_CODE01)or(dType==bj_ELEVATOR_CODE02)then
set bj_elevatorNeighbor=d
endif
endfunction
function NearbyElevatorExists takes real x,real y returns boolean
local real findThreshold=32
local rect r
set r=Rect(x-findThreshold,y-findThreshold,x+findThreshold,y+findThreshold)
set bj_elevatorNeighbor=null
call EnumDestructablesInRect(r,null,function NearbyElevatorExistsEnum)
call RemoveRect(r)
return bj_elevatorNeighbor!=null
endfunction
function FindElevatorWallBlockerEnum takes nothing returns nothing
set bj_elevatorWallBlocker=GetEnumDestructable()
endfunction
function ChangeElevatorWallBlocker takes real x,real y,real facing,boolean open returns nothing
local destructable blocker=null
local real findThreshold=32
local real nudgeLength=4.25*bj_CELLWIDTH
local real nudgeWidth=1.25*bj_CELLWIDTH
local rect r
set r=Rect(x-findThreshold,y-findThreshold,x+findThreshold,y+findThreshold)
set bj_elevatorWallBlocker=null
call EnumDestructablesInRect(r,null,function FindElevatorWallBlockerEnum)
call RemoveRect(r)
set blocker=bj_elevatorWallBlocker
if(blocker==null)then
set blocker=CreateDeadDestructable(bj_ELEVATOR_BLOCKER_CODE,x,y,facing,1,0)
elseif(GetDestructableTypeId(blocker)!=bj_ELEVATOR_BLOCKER_CODE)then
return
endif
if(open)then
if(GetDestructableLife(blocker)>0)then
call KillDestructable(blocker)
endif
else
if(GetDestructableLife(blocker)<=0)then
call DestructableRestoreLife(blocker,GetDestructableMaxLife(blocker),false)
endif
if(facing==0)then
set r=Rect(x-nudgeWidth/2,y-nudgeLength/2,x+nudgeWidth/2,y+nudgeLength/2)
call NudgeObjectsInRect(r)
call RemoveRect(r)
elseif(facing==90)then
set r=Rect(x-nudgeLength/2,y-nudgeWidth/2,x+nudgeLength/2,y+nudgeWidth/2)
call NudgeObjectsInRect(r)
call RemoveRect(r)
else
endif
endif
endfunction
function ChangeElevatorWalls takes boolean open,integer walls,destructable d returns nothing
local real x=GetDestructableX(d)
local real y=GetDestructableY(d)
local real distToBlocker=192
local real distToNeighbor=256
if(walls==bj_ELEVATOR_WALL_TYPE_ALL)or(walls==bj_ELEVATOR_WALL_TYPE_EAST)then
if(not NearbyElevatorExists(x+distToNeighbor,y))then
call ChangeElevatorWallBlocker(x+distToBlocker,y,0,open)
endif
endif
if(walls==bj_ELEVATOR_WALL_TYPE_ALL)or(walls==bj_ELEVATOR_WALL_TYPE_NORTH)then
if(not NearbyElevatorExists(x,y+distToNeighbor))then
call ChangeElevatorWallBlocker(x,y+distToBlocker,90,open)
endif
endif
if(walls==bj_ELEVATOR_WALL_TYPE_ALL)or(walls==bj_ELEVATOR_WALL_TYPE_SOUTH)then
if(not NearbyElevatorExists(x,y-distToNeighbor))then
call ChangeElevatorWallBlocker(x,y-distToBlocker,90,open)
endif
endif
if(walls==bj_ELEVATOR_WALL_TYPE_ALL)or(walls==bj_ELEVATOR_WALL_TYPE_WEST)then
if(not NearbyElevatorExists(x-distToNeighbor,y))then
call ChangeElevatorWallBlocker(x-distToBlocker,y,0,open)
endif
endif
endfunction
function WaygateActivateBJ takes boolean activate,unit waygate returns nothing
call WaygateActivate(waygate,activate)
endfunction
function WaygateIsActiveBJ takes unit waygate returns boolean
return WaygateIsActive(waygate)
endfunction
function WaygateSetDestinationLocBJ takes unit waygate,location loc returns nothing
call WaygateSetDestination(waygate,GetLocationX(loc),GetLocationY(loc))
endfunction
function WaygateGetDestinationLocBJ takes unit waygate returns location
return Location(WaygateGetDestinationX(waygate),WaygateGetDestinationY(waygate))
endfunction
function UnitSetUsesAltIconBJ takes boolean flag,unit whichUnit returns nothing
call UnitSetUsesAltIcon(whichUnit,flag)
endfunction
function ForceUIKeyBJ takes player whichPlayer,string key returns nothing
if(GetLocalPlayer()==whichPlayer)then
call ForceUIKey(key)
endif
endfunction
function ForceUICancelBJ takes player whichPlayer returns nothing
if(GetLocalPlayer()==whichPlayer)then
call ForceUICancel()
endif
endfunction
function ForGroupBJ takes group whichGroup,code callback returns nothing
local boolean wantDestroy=bj_wantDestroyGroup
set bj_wantDestroyGroup=false
call ForGroup(whichGroup,callback)
if(wantDestroy)then
call DestroyGroup(whichGroup)
endif
endfunction
function GroupAddUnitSimple takes unit whichUnit,group whichGroup returns nothing
call GroupAddUnit(whichGroup,whichUnit)
endfunction
function GroupRemoveUnitSimple takes unit whichUnit,group whichGroup returns nothing
call GroupRemoveUnit(whichGroup,whichUnit)
endfunction
function GroupAddGroupEnum takes nothing returns nothing
call GroupAddUnit(bj_groupAddGroupDest,GetEnumUnit())
endfunction
function GroupAddGroup takes group sourceGroup,group destGroup returns nothing
local boolean wantDestroy=bj_wantDestroyGroup
set bj_wantDestroyGroup=false
set bj_groupAddGroupDest=destGroup
call ForGroup(sourceGroup,function GroupAddGroupEnum)
if(wantDestroy)then
call DestroyGroup(sourceGroup)
endif
endfunction
function GroupRemoveGroupEnum takes nothing returns nothing
call GroupRemoveUnit(bj_groupRemoveGroupDest,GetEnumUnit())
endfunction
function GroupRemoveGroup takes group sourceGroup,group destGroup returns nothing
local boolean wantDestroy=bj_wantDestroyGroup
set bj_wantDestroyGroup=false
set bj_groupRemoveGroupDest=destGroup
call ForGroup(sourceGroup,function GroupRemoveGroupEnum)
if(wantDestroy)then
call DestroyGroup(sourceGroup)
endif
endfunction
function ForceAddPlayerSimple takes player whichPlayer,force whichForce returns nothing
call ForceAddPlayer(whichForce,whichPlayer)
endfunction
function ForceRemovePlayerSimple takes player whichPlayer,force whichForce returns nothing
call ForceRemovePlayer(whichForce,whichPlayer)
endfunction
function GroupPickRandomUnitEnum takes nothing returns nothing
set bj_groupRandomConsidered=bj_groupRandomConsidered+1
if(GetRandomInt(1,bj_groupRandomConsidered)==1)then
set bj_groupRandomCurrentPick=GetEnumUnit()
endif
endfunction
function GroupPickRandomUnit takes group whichGroup returns unit
local boolean wantDestroy=bj_wantDestroyGroup
set bj_wantDestroyGroup=false
set bj_groupRandomConsidered=0
set bj_groupRandomCurrentPick=null
call ForGroup(whichGroup,function GroupPickRandomUnitEnum)
if(wantDestroy)then
call DestroyGroup(whichGroup)
endif
return bj_groupRandomCurrentPick
endfunction
function ForcePickRandomPlayerEnum takes nothing returns nothing
set bj_forceRandomConsidered=bj_forceRandomConsidered+1
if(GetRandomInt(1,bj_forceRandomConsidered)==1)then
set bj_forceRandomCurrentPick=GetEnumPlayer()
endif
endfunction
function ForcePickRandomPlayer takes force whichForce returns player
set bj_forceRandomConsidered=0
set bj_forceRandomCurrentPick=null
call ForForce(whichForce,function ForcePickRandomPlayerEnum)
return bj_forceRandomCurrentPick
endfunction
function EnumUnitsSelected takes player whichPlayer,boolexpr enumFilter,code enumAction returns nothing
local group g=CreateGroup()
call SyncSelections()
call GroupEnumUnitsSelected(g,whichPlayer,enumFilter)
call DestroyBoolExpr(enumFilter)
call ForGroup(g,enumAction)
call DestroyGroup(g)
endfunction
function GetUnitsInRectMatching takes rect r,boolexpr filter returns group
local group g=CreateGroup()
call GroupEnumUnitsInRect(g,r,filter)
call DestroyBoolExpr(filter)
return g
endfunction
function GetUnitsInRectAll takes rect r returns group
return GetUnitsInRectMatching(r,null)
endfunction
function GetUnitsInRectOfPlayerFilter takes nothing returns boolean
return GetOwningPlayer(GetFilterUnit())==bj_groupEnumOwningPlayer
endfunction
function GetUnitsInRectOfPlayer takes rect r,player whichPlayer returns group
local group g=CreateGroup()
set bj_groupEnumOwningPlayer=whichPlayer
call GroupEnumUnitsInRect(g,r,filterGetUnitsInRectOfPlayer)
return g
endfunction
function GetUnitsInRangeOfLocMatching takes real radius,location whichLocation,boolexpr filter returns group
local group g=CreateGroup()
call GroupEnumUnitsInRangeOfLoc(g,whichLocation,radius,filter)
call DestroyBoolExpr(filter)
return g
endfunction
function GetUnitsInRangeOfLocAll takes real radius,location whichLocation returns group
return GetUnitsInRangeOfLocMatching(radius,whichLocation,null)
endfunction
function GetUnitsOfTypeIdAllFilter takes nothing returns boolean
return GetUnitTypeId(GetFilterUnit())==bj_groupEnumTypeId
endfunction
function GetUnitsOfTypeIdAll takes integer unitid returns group
local group result=CreateGroup()
local group g=CreateGroup()
local integer index
set index=0
loop
set bj_groupEnumTypeId=unitid
call GroupClear(g)
call GroupEnumUnitsOfPlayer(g,Player(index),filterGetUnitsOfTypeIdAll)
call GroupAddGroup(g,result)
set index=index+1
exitwhen index==bj_MAX_PLAYER_SLOTS
endloop
call DestroyGroup(g)
return result
endfunction
function GetUnitsOfPlayerMatching takes player whichPlayer,boolexpr filter returns group
local group g=CreateGroup()
call GroupEnumUnitsOfPlayer(g,whichPlayer,filter)
call DestroyBoolExpr(filter)
return g
endfunction
function GetUnitsOfPlayerAll takes player whichPlayer returns group
return GetUnitsOfPlayerMatching(whichPlayer,null)
endfunction
function GetUnitsOfPlayerAndTypeIdFilter takes nothing returns boolean
return GetUnitTypeId(GetFilterUnit())==bj_groupEnumTypeId
endfunction
function GetUnitsOfPlayerAndTypeId takes player whichPlayer,integer unitid returns group
local group g=CreateGroup()
set bj_groupEnumTypeId=unitid
call GroupEnumUnitsOfPlayer(g,whichPlayer,filterGetUnitsOfPlayerAndTypeId)
return g
endfunction
function GetUnitsSelectedAll takes player whichPlayer returns group
local group g=CreateGroup()
call SyncSelections()
call GroupEnumUnitsSelected(g,whichPlayer,null)
return g
endfunction
function GetForceOfPlayer takes player whichPlayer returns force
local force f=CreateForce()
call ForceAddPlayer(f,whichPlayer)
return f
endfunction
function GetPlayersAll takes nothing returns force
return bj_FORCE_ALL_PLAYERS
endfunction
function GetPlayersByMapControl takes mapcontrol whichControl returns force
local force f=CreateForce()
local integer playerIndex
local player indexPlayer
set playerIndex=0
loop
set indexPlayer=Player(playerIndex)
if GetPlayerController(indexPlayer)==whichControl then
call ForceAddPlayer(f,indexPlayer)
endif
set playerIndex=playerIndex+1
exitwhen playerIndex==bj_MAX_PLAYER_SLOTS
endloop
return f
endfunction
function GetPlayersAllies takes player whichPlayer returns force
local force f=CreateForce()
call ForceEnumAllies(f,whichPlayer,null)
return f
endfunction
function GetPlayersEnemies takes player whichPlayer returns force
local force f=CreateForce()
call ForceEnumEnemies(f,whichPlayer,null)
return f
endfunction
function GetPlayersMatching takes boolexpr filter returns force
local force f=CreateForce()
call ForceEnumPlayers(f,filter)
call DestroyBoolExpr(filter)
return f
endfunction
function CountUnitsInGroupEnum takes nothing returns nothing
set bj_groupCountUnits=bj_groupCountUnits+1
endfunction
function CountUnitsInGroup takes group g returns integer
local boolean wantDestroy=bj_wantDestroyGroup
set bj_wantDestroyGroup=false
set bj_groupCountUnits=0
call ForGroup(g,function CountUnitsInGroupEnum)
if(wantDestroy)then
call DestroyGroup(g)
endif
return bj_groupCountUnits
endfunction
function CountPlayersInForceEnum takes nothing returns nothing
set bj_forceCountPlayers=bj_forceCountPlayers+1
endfunction
function CountPlayersInForceBJ takes force f returns integer
set bj_forceCountPlayers=0
call ForForce(f,function CountPlayersInForceEnum)
return bj_forceCountPlayers
endfunction
function GetRandomSubGroupEnum takes nothing returns nothing
if(bj_randomSubGroupWant>0)then
if(bj_randomSubGroupWant>=bj_randomSubGroupTotal)or(GetRandomReal(0,1)<bj_randomSubGroupChance)then
call GroupAddUnit(bj_randomSubGroupGroup,GetEnumUnit())
set bj_randomSubGroupWant=bj_randomSubGroupWant-1
endif
endif
set bj_randomSubGroupTotal=bj_randomSubGroupTotal-1
endfunction
function GetRandomSubGroup takes integer count,group sourceGroup returns group
local group g=CreateGroup()
set bj_randomSubGroupGroup=g
set bj_randomSubGroupWant=count
set bj_randomSubGroupTotal=CountUnitsInGroup(sourceGroup)
if(bj_randomSubGroupWant<=0 or bj_randomSubGroupTotal<=0)then
return g
endif
set bj_randomSubGroupChance=I2R(bj_randomSubGroupWant)/I2R(bj_randomSubGroupTotal)
call ForGroup(sourceGroup,function GetRandomSubGroupEnum)
return g
endfunction
function LivingPlayerUnitsOfTypeIdFilter takes nothing returns boolean
local unit filterUnit=GetFilterUnit()
return IsUnitAliveBJ(filterUnit)and GetUnitTypeId(filterUnit)==bj_livingPlayerUnitsTypeId
endfunction
function CountLivingPlayerUnitsOfTypeId takes integer unitId,player whichPlayer returns integer
local group g
local integer matchedCount
set g=CreateGroup()
set bj_livingPlayerUnitsTypeId=unitId
call GroupEnumUnitsOfPlayer(g,whichPlayer,filterLivingPlayerUnitsOfTypeId)
set matchedCount=CountUnitsInGroup(g)
call DestroyGroup(g)
return matchedCount
endfunction
function ResetUnitAnimation takes unit whichUnit returns nothing
call SetUnitAnimation(whichUnit,"stand")
endfunction
function SetUnitTimeScalePercent takes unit whichUnit,real percentScale returns nothing
call SetUnitTimeScale(whichUnit,percentScale*0.01)
endfunction
function SetUnitScalePercent takes unit whichUnit,real percentScaleX,real percentScaleY,real percentScaleZ returns nothing
call SetUnitScale(whichUnit,percentScaleX*0.01,percentScaleY*0.01,percentScaleZ*0.01)
endfunction
function SetUnitVertexColorBJ takes unit whichUnit,real red,real green,real blue,real transparency returns nothing
call SetUnitVertexColor(whichUnit,PercentTo255(red),PercentTo255(green),PercentTo255(blue),PercentTo255(100.0-transparency))
endfunction
function UnitAddIndicatorBJ takes unit whichUnit,real red,real green,real blue,real transparency returns nothing
call AddIndicator(whichUnit,PercentTo255(red),PercentTo255(green),PercentTo255(blue),PercentTo255(100.0-transparency))
endfunction
function DestructableAddIndicatorBJ takes destructable whichDestructable,real red,real green,real blue,real transparency returns nothing
call AddIndicator(whichDestructable,PercentTo255(red),PercentTo255(green),PercentTo255(blue),PercentTo255(100.0-transparency))
endfunction
function ItemAddIndicatorBJ takes item whichItem,real red,real green,real blue,real transparency returns nothing
call AddIndicator(whichItem,PercentTo255(red),PercentTo255(green),PercentTo255(blue),PercentTo255(100.0-transparency))
endfunction
function SetUnitFacingToFaceLocTimed takes unit whichUnit,location target,real duration returns nothing
local location unitLoc=GetUnitLoc(whichUnit)
call SetUnitFacingTimed(whichUnit,AngleBetweenPoints(unitLoc,target),duration)
call RemoveLocation(unitLoc)
endfunction
function SetUnitFacingToFaceUnitTimed takes unit whichUnit,unit target,real duration returns nothing
local location unitLoc=GetUnitLoc(target)
call SetUnitFacingToFaceLocTimed(whichUnit,unitLoc,duration)
call RemoveLocation(unitLoc)
endfunction
function QueueUnitAnimationBJ takes unit whichUnit,string whichAnimation returns nothing
call QueueUnitAnimation(whichUnit,whichAnimation)
endfunction
function SetDestructableAnimationBJ takes destructable d,string whichAnimation returns nothing
call SetDestructableAnimation(d,whichAnimation)
endfunction
function QueueDestructableAnimationBJ takes destructable d,string whichAnimation returns nothing
call QueueDestructableAnimation(d,whichAnimation)
endfunction
function SetDestAnimationSpeedPercent takes destructable d,real percentScale returns nothing
call SetDestructableAnimationSpeed(d,percentScale*0.01)
endfunction
function DialogDisplayBJ takes boolean flag,dialog whichDialog,player whichPlayer returns nothing
call DialogDisplay(whichPlayer,whichDialog,flag)
endfunction
function DialogSetMessageBJ takes dialog whichDialog,string message returns nothing
call DialogSetMessage(whichDialog,message)
endfunction
function DialogAddButtonBJ takes dialog whichDialog,string buttonText returns button
set bj_lastCreatedButton=DialogAddButton(whichDialog,buttonText,0)
return bj_lastCreatedButton
endfunction
function DialogAddButtonWithHotkeyBJ takes dialog whichDialog,string buttonText,integer hotkey returns button
set bj_lastCreatedButton=DialogAddButton(whichDialog,buttonText,hotkey)
return bj_lastCreatedButton
endfunction
function DialogClearBJ takes dialog whichDialog returns nothing
call DialogClear(whichDialog)
endfunction
function GetLastCreatedButtonBJ takes nothing returns button
return bj_lastCreatedButton
endfunction
function GetClickedButtonBJ takes nothing returns button
return GetClickedButton()
endfunction
function GetClickedDialogBJ takes nothing returns dialog
return GetClickedDialog()
endfunction
function SetPlayerAllianceBJ takes player sourcePlayer,alliancetype whichAllianceSetting,boolean value,player otherPlayer returns nothing
if(sourcePlayer==otherPlayer)then
return
endif
call SetPlayerAlliance(sourcePlayer,otherPlayer,whichAllianceSetting,value)
endfunction
function SetPlayerAllianceStateAllyBJ takes player sourcePlayer,player otherPlayer,boolean flag returns nothing
call SetPlayerAlliance(sourcePlayer,otherPlayer,ALLIANCE_PASSIVE,flag)
call SetPlayerAlliance(sourcePlayer,otherPlayer,ALLIANCE_HELP_REQUEST,flag)
call SetPlayerAlliance(sourcePlayer,otherPlayer,ALLIANCE_HELP_RESPONSE,flag)
call SetPlayerAlliance(sourcePlayer,otherPlayer,ALLIANCE_SHARED_XP,flag)
call SetPlayerAlliance(sourcePlayer,otherPlayer,ALLIANCE_SHARED_SPELLS,flag)
endfunction
function SetPlayerAllianceStateVisionBJ takes player sourcePlayer,player otherPlayer,boolean flag returns nothing
call SetPlayerAlliance(sourcePlayer,otherPlayer,ALLIANCE_SHARED_VISION,flag)
endfunction
function SetPlayerAllianceStateControlBJ takes player sourcePlayer,player otherPlayer,boolean flag returns nothing
call SetPlayerAlliance(sourcePlayer,otherPlayer,ALLIANCE_SHARED_CONTROL,flag)
endfunction
function SetPlayerAllianceStateFullControlBJ takes player sourcePlayer,player otherPlayer,boolean flag returns nothing
call SetPlayerAlliance(sourcePlayer,otherPlayer,ALLIANCE_SHARED_ADVANCED_CONTROL,flag)
endfunction
function SetPlayerAllianceStateBJ takes player sourcePlayer,player otherPlayer,integer allianceState returns nothing
if(sourcePlayer==otherPlayer)then
return
endif
if allianceState==bj_ALLIANCE_UNALLIED then
call SetPlayerAllianceStateAllyBJ(sourcePlayer,otherPlayer,false)
call SetPlayerAllianceStateVisionBJ(sourcePlayer,otherPlayer,false)
call SetPlayerAllianceStateControlBJ(sourcePlayer,otherPlayer,false)
call SetPlayerAllianceStateFullControlBJ(sourcePlayer,otherPlayer,false)
elseif allianceState==bj_ALLIANCE_UNALLIED_VISION then
call SetPlayerAllianceStateAllyBJ(sourcePlayer,otherPlayer,false)
call SetPlayerAllianceStateVisionBJ(sourcePlayer,otherPlayer,true)
call SetPlayerAllianceStateControlBJ(sourcePlayer,otherPlayer,false)
call SetPlayerAllianceStateFullControlBJ(sourcePlayer,otherPlayer,false)
elseif allianceState==bj_ALLIANCE_ALLIED then
call SetPlayerAllianceStateAllyBJ(sourcePlayer,otherPlayer,true)
call SetPlayerAllianceStateVisionBJ(sourcePlayer,otherPlayer,false)
call SetPlayerAllianceStateControlBJ(sourcePlayer,otherPlayer,false)
call SetPlayerAllianceStateFullControlBJ(sourcePlayer,otherPlayer,false)
elseif allianceState==bj_ALLIANCE_ALLIED_VISION then
call SetPlayerAllianceStateAllyBJ(sourcePlayer,otherPlayer,true)
call SetPlayerAllianceStateVisionBJ(sourcePlayer,otherPlayer,true)
call SetPlayerAllianceStateControlBJ(sourcePlayer,otherPlayer,false)
call SetPlayerAllianceStateFullControlBJ(sourcePlayer,otherPlayer,false)
elseif allianceState==bj_ALLIANCE_ALLIED_UNITS then
call SetPlayerAllianceStateAllyBJ(sourcePlayer,otherPlayer,true)
call SetPlayerAllianceStateVisionBJ(sourcePlayer,otherPlayer,true)
call SetPlayerAllianceStateControlBJ(sourcePlayer,otherPlayer,true)
call SetPlayerAllianceStateFullControlBJ(sourcePlayer,otherPlayer,false)
elseif allianceState==bj_ALLIANCE_ALLIED_ADVUNITS then
call SetPlayerAllianceStateAllyBJ(sourcePlayer,otherPlayer,true)
call SetPlayerAllianceStateVisionBJ(sourcePlayer,otherPlayer,true)
call SetPlayerAllianceStateControlBJ(sourcePlayer,otherPlayer,true)
call SetPlayerAllianceStateFullControlBJ(sourcePlayer,otherPlayer,true)
elseif allianceState==bj_ALLIANCE_NEUTRAL then
call SetPlayerAllianceStateAllyBJ(sourcePlayer,otherPlayer,false)
call SetPlayerAllianceStateVisionBJ(sourcePlayer,otherPlayer,false)
call SetPlayerAllianceStateControlBJ(sourcePlayer,otherPlayer,false)
call SetPlayerAllianceStateFullControlBJ(sourcePlayer,otherPlayer,false)
call SetPlayerAlliance(sourcePlayer,otherPlayer,ALLIANCE_PASSIVE,true)
elseif allianceState==bj_ALLIANCE_NEUTRAL_VISION then
call SetPlayerAllianceStateAllyBJ(sourcePlayer,otherPlayer,false)
call SetPlayerAllianceStateVisionBJ(sourcePlayer,otherPlayer,true)
call SetPlayerAllianceStateControlBJ(sourcePlayer,otherPlayer,false)
call SetPlayerAllianceStateFullControlBJ(sourcePlayer,otherPlayer,false)
call SetPlayerAlliance(sourcePlayer,otherPlayer,ALLIANCE_PASSIVE,true)
else
endif
endfunction
function SetForceAllianceStateBJ takes force sourceForce,force targetForce,integer allianceState returns nothing
local integer sourceIndex
local integer targetIndex
set sourceIndex=0
loop
if(sourceForce==bj_FORCE_ALL_PLAYERS or IsPlayerInForce(Player(sourceIndex),sourceForce))then
set targetIndex=0
loop
if(targetForce==bj_FORCE_ALL_PLAYERS or IsPlayerInForce(Player(targetIndex),targetForce))then
call SetPlayerAllianceStateBJ(Player(sourceIndex),Player(targetIndex),allianceState)
endif
set targetIndex=targetIndex+1
exitwhen targetIndex==bj_MAX_PLAYER_SLOTS
endloop
endif
set sourceIndex=sourceIndex+1
exitwhen sourceIndex==bj_MAX_PLAYER_SLOTS
endloop
endfunction
function PlayersAreCoAllied takes player playerA,player playerB returns boolean
if(playerA==playerB)then
return true
endif
if GetPlayerAlliance(playerA,playerB,ALLIANCE_PASSIVE)then
if GetPlayerAlliance(playerB,playerA,ALLIANCE_PASSIVE)then
return true
endif
endif
return false
endfunction
function ShareEverythingWithTeamAI takes player whichPlayer returns nothing
local integer playerIndex
local player indexPlayer
set playerIndex=0
loop
set indexPlayer=Player(playerIndex)
if(PlayersAreCoAllied(whichPlayer,indexPlayer)and whichPlayer!=indexPlayer)then
if(GetPlayerController(indexPlayer)==MAP_CONTROL_COMPUTER)then
call SetPlayerAlliance(whichPlayer,indexPlayer,ALLIANCE_SHARED_VISION,true)
call SetPlayerAlliance(whichPlayer,indexPlayer,ALLIANCE_SHARED_CONTROL,true)
call SetPlayerAlliance(whichPlayer,indexPlayer,ALLIANCE_SHARED_ADVANCED_CONTROL,true)
endif
endif
set playerIndex=playerIndex+1
exitwhen playerIndex==bj_MAX_PLAYERS
endloop
endfunction
function ShareEverythingWithTeam takes player whichPlayer returns nothing
local integer playerIndex
local player indexPlayer
set playerIndex=0
loop
set indexPlayer=Player(playerIndex)
if(PlayersAreCoAllied(whichPlayer,indexPlayer)and whichPlayer!=indexPlayer)then
call SetPlayerAlliance(whichPlayer,indexPlayer,ALLIANCE_SHARED_VISION,true)
call SetPlayerAlliance(whichPlayer,indexPlayer,ALLIANCE_SHARED_CONTROL,true)
call SetPlayerAlliance(indexPlayer,whichPlayer,ALLIANCE_SHARED_CONTROL,true)
call SetPlayerAlliance(whichPlayer,indexPlayer,ALLIANCE_SHARED_ADVANCED_CONTROL,true)
endif
set playerIndex=playerIndex+1
exitwhen playerIndex==bj_MAX_PLAYERS
endloop
endfunction
function ConfigureNeutralVictim takes nothing returns nothing
local integer index
local player indexPlayer
local player neutralVictim=Player(bj_PLAYER_NEUTRAL_VICTIM)
set index=0
loop
set indexPlayer=Player(index)
call SetPlayerAlliance(neutralVictim,indexPlayer,ALLIANCE_PASSIVE,true)
call SetPlayerAlliance(indexPlayer,neutralVictim,ALLIANCE_PASSIVE,false)
set index=index+1
exitwhen index==bj_MAX_PLAYERS
endloop
set indexPlayer=Player(PLAYER_NEUTRAL_AGGRESSIVE)
call SetPlayerAlliance(neutralVictim,indexPlayer,ALLIANCE_PASSIVE,true)
call SetPlayerAlliance(indexPlayer,neutralVictim,ALLIANCE_PASSIVE,true)
call SetPlayerState(neutralVictim,PLAYER_STATE_GIVES_BOUNTY,0)
endfunction
function MakeUnitsPassiveForPlayerEnum takes nothing returns nothing
call SetUnitOwner(GetEnumUnit(),Player(bj_PLAYER_NEUTRAL_VICTIM),false)
endfunction
function MakeUnitsPassiveForPlayer takes player whichPlayer returns nothing
local group playerUnits=CreateGroup()
call CachePlayerHeroData(whichPlayer)
call GroupEnumUnitsOfPlayer(playerUnits,whichPlayer,null)
call ForGroup(playerUnits,function MakeUnitsPassiveForPlayerEnum)
call DestroyGroup(playerUnits)
endfunction
function MakeUnitsPassiveForTeam takes player whichPlayer returns nothing
local integer playerIndex
local player indexPlayer
set playerIndex=0
loop
set indexPlayer=Player(playerIndex)
if PlayersAreCoAllied(whichPlayer,indexPlayer)then
call MakeUnitsPassiveForPlayer(indexPlayer)
endif
set playerIndex=playerIndex+1
exitwhen playerIndex==bj_MAX_PLAYERS
endloop
endfunction
function AllowVictoryDefeat takes playergameresult gameResult returns boolean
if(gameResult==PLAYER_GAME_RESULT_VICTORY)then
return not IsNoVictoryCheat()
endif
if(gameResult==PLAYER_GAME_RESULT_DEFEAT)then
return not IsNoDefeatCheat()
endif
if(gameResult==PLAYER_GAME_RESULT_NEUTRAL)then
return(not IsNoVictoryCheat())and(not IsNoDefeatCheat())
endif
return true
endfunction
function EndGameBJ takes nothing returns nothing
call EndGame(true)
endfunction
function MeleeVictoryDialogBJ takes player whichPlayer,boolean leftGame returns nothing
local trigger t=CreateTrigger()
local dialog d=DialogCreate()
local string formatString
if(leftGame)then
set formatString=GetLocalizedString("PLAYER_LEFT_GAME")
else
set formatString=GetLocalizedString("PLAYER_VICTORIOUS")
endif
call DisplayTimedTextFromPlayer(whichPlayer,0,0,60,formatString)
call DialogSetMessage(d,GetLocalizedString("GAMEOVER_VICTORY_MSG"))
call DialogAddButton(d,GetLocalizedString("GAMEOVER_CONTINUE_GAME"),GetLocalizedHotkey("GAMEOVER_CONTINUE_GAME"))
set t=CreateTrigger()
call TriggerRegisterDialogButtonEvent(t,DialogAddQuitButton(d,true,GetLocalizedString("GAMEOVER_QUIT_GAME"),GetLocalizedHotkey("GAMEOVER_QUIT_GAME")))
call DialogDisplay(whichPlayer,d,true)
call StartSoundForPlayerBJ(whichPlayer,bj_victoryDialogSound)
endfunction
function MeleeDefeatDialogBJ takes player whichPlayer,boolean leftGame returns nothing
local trigger t=CreateTrigger()
local dialog d=DialogCreate()
local string formatString
if(leftGame)then
set formatString=GetLocalizedString("PLAYER_LEFT_GAME")
else
set formatString=GetLocalizedString("PLAYER_DEFEATED")
endif
call DisplayTimedTextFromPlayer(whichPlayer,0,0,60,formatString)
call DialogSetMessage(d,GetLocalizedString("GAMEOVER_DEFEAT_MSG"))
if(not bj_meleeGameOver and IsMapFlagSet(MAP_OBSERVERS_ON_DEATH))then
call DialogAddButton(d,GetLocalizedString("GAMEOVER_CONTINUE_OBSERVING"),GetLocalizedHotkey("GAMEOVER_CONTINUE_OBSERVING"))
endif
set t=CreateTrigger()
call TriggerRegisterDialogButtonEvent(t,DialogAddQuitButton(d,true,GetLocalizedString("GAMEOVER_QUIT_GAME"),GetLocalizedHotkey("GAMEOVER_QUIT_GAME")))
call DialogDisplay(whichPlayer,d,true)
call StartSoundForPlayerBJ(whichPlayer,bj_defeatDialogSound)
endfunction
function GameOverDialogBJ takes player whichPlayer,boolean leftGame returns nothing
local trigger t=CreateTrigger()
local dialog d=DialogCreate()
local string s
call DisplayTimedTextFromPlayer(whichPlayer,0,0,60,GetLocalizedString("PLAYER_LEFT_GAME"))
if(GetIntegerGameState(GAME_STATE_DISCONNECTED)!=0)then
set s=GetLocalizedString("GAMEOVER_DISCONNECTED")
else
set s=GetLocalizedString("GAMEOVER_GAME_OVER")
endif
call DialogSetMessage(d,s)
set t=CreateTrigger()
call TriggerRegisterDialogButtonEvent(t,DialogAddQuitButton(d,true,GetLocalizedString("GAMEOVER_OK"),GetLocalizedHotkey("GAMEOVER_OK")))
call DialogDisplay(whichPlayer,d,true)
call StartSoundForPlayerBJ(whichPlayer,bj_defeatDialogSound)
endfunction
function RemovePlayerPreserveUnitsBJ takes player whichPlayer,playergameresult gameResult,boolean leftGame returns nothing
if AllowVictoryDefeat(gameResult)then
call RemovePlayer(whichPlayer,gameResult)
if(gameResult==PLAYER_GAME_RESULT_VICTORY)then
call MeleeVictoryDialogBJ(whichPlayer,leftGame)
return
elseif(gameResult==PLAYER_GAME_RESULT_DEFEAT)then
call MeleeDefeatDialogBJ(whichPlayer,leftGame)
else
call GameOverDialogBJ(whichPlayer,leftGame)
endif
endif
endfunction
function CustomVictoryOkBJ takes nothing returns nothing
if bj_isSinglePlayer then
call PauseGame(false)
call SetGameDifficulty(GetDefaultDifficulty())
endif
if(bj_changeLevelMapName==null)then
call EndGame(bj_changeLevelShowScores)
else
call ChangeLevel(bj_changeLevelMapName,bj_changeLevelShowScores)
endif
endfunction
function CustomVictoryQuitBJ takes nothing returns nothing
if bj_isSinglePlayer then
call PauseGame(false)
call SetGameDifficulty(GetDefaultDifficulty())
endif
call EndGame(bj_changeLevelShowScores)
endfunction
function CustomVictoryDialogBJ takes player whichPlayer returns nothing
local trigger t=CreateTrigger()
local dialog d=DialogCreate()
call DialogSetMessage(d,GetLocalizedString("GAMEOVER_VICTORY_MSG"))
set t=CreateTrigger()
call TriggerRegisterDialogButtonEvent(t,DialogAddButton(d,GetLocalizedString("GAMEOVER_CONTINUE"),GetLocalizedHotkey("GAMEOVER_CONTINUE")))
call TriggerAddAction(t,function CustomVictoryOkBJ)
set t=CreateTrigger()
call TriggerRegisterDialogButtonEvent(t,DialogAddButton(d,GetLocalizedString("GAMEOVER_QUIT_MISSION"),GetLocalizedHotkey("GAMEOVER_QUIT_MISSION")))
call TriggerAddAction(t,function CustomVictoryQuitBJ)
if(GetLocalPlayer()==whichPlayer)then
call EnableUserControl(true)
if bj_isSinglePlayer then
call PauseGame(true)
endif
call EnableUserUI(false)
endif
call DialogDisplay(whichPlayer,d,true)
call VolumeGroupSetVolumeForPlayerBJ(whichPlayer,SOUND_VOLUMEGROUP_UI,1.0)
call StartSoundForPlayerBJ(whichPlayer,bj_victoryDialogSound)
endfunction
function CustomVictorySkipBJ takes player whichPlayer returns nothing
if(GetLocalPlayer()==whichPlayer)then
if bj_isSinglePlayer then
call SetGameDifficulty(GetDefaultDifficulty())
endif
if(bj_changeLevelMapName==null)then
call EndGame(bj_changeLevelShowScores)
else
call ChangeLevel(bj_changeLevelMapName,bj_changeLevelShowScores)
endif
endif
endfunction
function CustomVictoryBJ takes player whichPlayer,boolean showDialog,boolean showScores returns nothing
if AllowVictoryDefeat(PLAYER_GAME_RESULT_VICTORY)then
call RemovePlayer(whichPlayer,PLAYER_GAME_RESULT_VICTORY)
if not bj_isSinglePlayer then
call DisplayTimedTextFromPlayer(whichPlayer,0,0,60,GetLocalizedString("PLAYER_VICTORIOUS"))
endif
if(GetPlayerController(whichPlayer)==MAP_CONTROL_USER)then
set bj_changeLevelShowScores=showScores
if showDialog then
call CustomVictoryDialogBJ(whichPlayer)
else
call CustomVictorySkipBJ(whichPlayer)
endif
endif
endif
endfunction
function CustomDefeatRestartBJ takes nothing returns nothing
call PauseGame(false)
call RestartGame(true)
endfunction
function CustomDefeatReduceDifficultyBJ takes nothing returns nothing
local gamedifficulty diff=GetGameDifficulty()
call PauseGame(false)
if(diff==MAP_DIFFICULTY_EASY)then
elseif(diff==MAP_DIFFICULTY_NORMAL)then
call SetGameDifficulty(MAP_DIFFICULTY_EASY)
elseif(diff==MAP_DIFFICULTY_HARD)then
call SetGameDifficulty(MAP_DIFFICULTY_NORMAL)
else
endif
call RestartGame(true)
endfunction
function CustomDefeatLoadBJ takes nothing returns nothing
call PauseGame(false)
call DisplayLoadDialog()
endfunction
function CustomDefeatQuitBJ takes nothing returns nothing
if bj_isSinglePlayer then
call PauseGame(false)
endif
call SetGameDifficulty(GetDefaultDifficulty())
call EndGame(true)
endfunction
function CustomDefeatDialogBJ takes player whichPlayer,string message returns nothing
local trigger t=CreateTrigger()
local dialog d=DialogCreate()
call DialogSetMessage(d,message)
if bj_isSinglePlayer then
set t=CreateTrigger()
call TriggerRegisterDialogButtonEvent(t,DialogAddButton(d,GetLocalizedString("GAMEOVER_RESTART"),GetLocalizedHotkey("GAMEOVER_RESTART")))
call TriggerAddAction(t,function CustomDefeatRestartBJ)
if(GetGameDifficulty()!=MAP_DIFFICULTY_EASY)then
set t=CreateTrigger()
call TriggerRegisterDialogButtonEvent(t,DialogAddButton(d,GetLocalizedString("GAMEOVER_REDUCE_DIFFICULTY"),GetLocalizedHotkey("GAMEOVER_REDUCE_DIFFICULTY")))
call TriggerAddAction(t,function CustomDefeatReduceDifficultyBJ)
endif
set t=CreateTrigger()
call TriggerRegisterDialogButtonEvent(t,DialogAddButton(d,GetLocalizedString("GAMEOVER_LOAD"),GetLocalizedHotkey("GAMEOVER_LOAD")))
call TriggerAddAction(t,function CustomDefeatLoadBJ)
endif
set t=CreateTrigger()
call TriggerRegisterDialogButtonEvent(t,DialogAddButton(d,GetLocalizedString("GAMEOVER_QUIT_MISSION"),GetLocalizedHotkey("GAMEOVER_QUIT_MISSION")))
call TriggerAddAction(t,function CustomDefeatQuitBJ)
if(GetLocalPlayer()==whichPlayer)then
call EnableUserControl(true)
if bj_isSinglePlayer then
call PauseGame(true)
endif
call EnableUserUI(false)
endif
call DialogDisplay(whichPlayer,d,true)
call VolumeGroupSetVolumeForPlayerBJ(whichPlayer,SOUND_VOLUMEGROUP_UI,1.0)
call StartSoundForPlayerBJ(whichPlayer,bj_defeatDialogSound)
endfunction
function CustomDefeatBJ takes player whichPlayer,string message returns nothing
if AllowVictoryDefeat(PLAYER_GAME_RESULT_DEFEAT)then
call RemovePlayer(whichPlayer,PLAYER_GAME_RESULT_DEFEAT)
if not bj_isSinglePlayer then
call DisplayTimedTextFromPlayer(whichPlayer,0,0,60,GetLocalizedString("PLAYER_DEFEATED"))
endif
if(GetPlayerController(whichPlayer)==MAP_CONTROL_USER)then
call CustomDefeatDialogBJ(whichPlayer,message)
endif
endif
endfunction
function SetNextLevelBJ takes string nextLevel returns nothing
if(nextLevel=="")then
set bj_changeLevelMapName=null
else
set bj_changeLevelMapName=nextLevel
endif
endfunction
function SetPlayerOnScoreScreenBJ takes boolean flag,player whichPlayer returns nothing
call SetPlayerOnScoreScreen(whichPlayer,flag)
endfunction
function CreateQuestBJ takes integer questType,string title,string description,string iconPath returns quest
local boolean required=(questType==bj_QUESTTYPE_REQ_DISCOVERED)or(questType==bj_QUESTTYPE_REQ_UNDISCOVERED)
local boolean discovered=(questType==bj_QUESTTYPE_REQ_DISCOVERED)or(questType==bj_QUESTTYPE_OPT_DISCOVERED)
set bj_lastCreatedQuest=CreateQuest()
call QuestSetTitle(bj_lastCreatedQuest,title)
call QuestSetDescription(bj_lastCreatedQuest,description)
call QuestSetIconPath(bj_lastCreatedQuest,iconPath)
call QuestSetRequired(bj_lastCreatedQuest,required)
call QuestSetDiscovered(bj_lastCreatedQuest,discovered)
call QuestSetCompleted(bj_lastCreatedQuest,false)
return bj_lastCreatedQuest
endfunction
function DestroyQuestBJ takes quest whichQuest returns nothing
call DestroyQuest(whichQuest)
endfunction
function QuestSetEnabledBJ takes boolean enabled,quest whichQuest returns nothing
call QuestSetEnabled(whichQuest,enabled)
endfunction
function QuestSetTitleBJ takes quest whichQuest,string title returns nothing
call QuestSetTitle(whichQuest,title)
endfunction
function QuestSetDescriptionBJ takes quest whichQuest,string description returns nothing
call QuestSetDescription(whichQuest,description)
endfunction
function QuestSetCompletedBJ takes quest whichQuest,boolean completed returns nothing
call QuestSetCompleted(whichQuest,completed)
endfunction
function QuestSetFailedBJ takes quest whichQuest,boolean failed returns nothing
call QuestSetFailed(whichQuest,failed)
endfunction
function QuestSetDiscoveredBJ takes quest whichQuest,boolean discovered returns nothing
call QuestSetDiscovered(whichQuest,discovered)
endfunction
function GetLastCreatedQuestBJ takes nothing returns quest
return bj_lastCreatedQuest
endfunction
function CreateQuestItemBJ takes quest whichQuest,string description returns questitem
set bj_lastCreatedQuestItem=QuestCreateItem(whichQuest)
call QuestItemSetDescription(bj_lastCreatedQuestItem,description)
call QuestItemSetCompleted(bj_lastCreatedQuestItem,false)
return bj_lastCreatedQuestItem
endfunction
function QuestItemSetDescriptionBJ takes questitem whichQuestItem,string description returns nothing
call QuestItemSetDescription(whichQuestItem,description)
endfunction
function QuestItemSetCompletedBJ takes questitem whichQuestItem,boolean completed returns nothing
call QuestItemSetCompleted(whichQuestItem,completed)
endfunction
function GetLastCreatedQuestItemBJ takes nothing returns questitem
return bj_lastCreatedQuestItem
endfunction
function CreateDefeatConditionBJ takes string description returns defeatcondition
set bj_lastCreatedDefeatCondition=CreateDefeatCondition()
call DefeatConditionSetDescription(bj_lastCreatedDefeatCondition,description)
return bj_lastCreatedDefeatCondition
endfunction
function DestroyDefeatConditionBJ takes defeatcondition whichCondition returns nothing
call DestroyDefeatCondition(whichCondition)
endfunction
function DefeatConditionSetDescriptionBJ takes defeatcondition whichCondition,string description returns nothing
call DefeatConditionSetDescription(whichCondition,description)
endfunction
function GetLastCreatedDefeatConditionBJ takes nothing returns defeatcondition
return bj_lastCreatedDefeatCondition
endfunction
function FlashQuestDialogButtonBJ takes nothing returns nothing
call FlashQuestDialogButton()
endfunction
function QuestMessageBJ takes force f,integer messageType,string message returns nothing
if(IsPlayerInForce(GetLocalPlayer(),f))then
if(messageType==bj_QUESTMESSAGE_DISCOVERED)then
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_QUEST," ")
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_QUEST,message)
call StartSound(bj_questDiscoveredSound)
call FlashQuestDialogButton()
elseif(messageType==bj_QUESTMESSAGE_UPDATED)then
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_QUESTUPDATE," ")
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_QUESTUPDATE,message)
call StartSound(bj_questUpdatedSound)
call FlashQuestDialogButton()
elseif(messageType==bj_QUESTMESSAGE_COMPLETED)then
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_QUESTDONE," ")
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_QUESTDONE,message)
call StartSound(bj_questCompletedSound)
call FlashQuestDialogButton()
elseif(messageType==bj_QUESTMESSAGE_FAILED)then
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_QUESTFAILED," ")
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_QUESTFAILED,message)
call StartSound(bj_questFailedSound)
call FlashQuestDialogButton()
elseif(messageType==bj_QUESTMESSAGE_REQUIREMENT)then
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_QUESTREQUIREMENT,message)
elseif(messageType==bj_QUESTMESSAGE_MISSIONFAILED)then
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_MISSIONFAILED," ")
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_MISSIONFAILED,message)
call StartSound(bj_questFailedSound)
elseif(messageType==bj_QUESTMESSAGE_HINT)then
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_HINT," ")
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_HINT,message)
call StartSound(bj_questHintSound)
elseif(messageType==bj_QUESTMESSAGE_ALWAYSHINT)then
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_ALWAYSHINT," ")
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_ALWAYSHINT,message)
call StartSound(bj_questHintSound)
elseif(messageType==bj_QUESTMESSAGE_SECRET)then
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_SECRET," ")
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_SECRET,message)
call StartSound(bj_questSecretSound)
elseif(messageType==bj_QUESTMESSAGE_UNITACQUIRED)then
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_UNITACQUIRED," ")
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_UNITACQUIRED,message)
call StartSound(bj_questHintSound)
elseif(messageType==bj_QUESTMESSAGE_UNITAVAILABLE)then
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_UNITAVAILABLE," ")
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_UNITAVAILABLE,message)
call StartSound(bj_questHintSound)
elseif(messageType==bj_QUESTMESSAGE_ITEMACQUIRED)then
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_ITEMACQUIRED," ")
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_ITEMACQUIRED,message)
call StartSound(bj_questItemAcquiredSound)
elseif(messageType==bj_QUESTMESSAGE_WARNING)then
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_WARNING," ")
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_TEXT_DELAY_WARNING,message)
call StartSound(bj_questWarningSound)
else
endif
endif
endfunction
function StartTimerBJ takes timer t,boolean periodic,real timeout returns timer
set bj_lastStartedTimer=t
call TimerStart(t,timeout,periodic,null)
return bj_lastStartedTimer
endfunction
function CreateTimerBJ takes boolean periodic,real timeout returns timer
set bj_lastStartedTimer=CreateTimer()
call TimerStart(bj_lastStartedTimer,timeout,periodic,null)
return bj_lastStartedTimer
endfunction
function DestroyTimerBJ takes timer whichTimer returns nothing
call DestroyTimer(whichTimer)
endfunction
function PauseTimerBJ takes boolean pause,timer whichTimer returns nothing
if pause then
call PauseTimer(whichTimer)
else
call ResumeTimer(whichTimer)
endif
endfunction
function GetLastCreatedTimerBJ takes nothing returns timer
return bj_lastStartedTimer
endfunction
function CreateTimerDialogBJ takes timer t,string title returns timerdialog
set bj_lastCreatedTimerDialog=CreateTimerDialog(t)
call TimerDialogSetTitle(bj_lastCreatedTimerDialog,title)
call TimerDialogDisplay(bj_lastCreatedTimerDialog,true)
return bj_lastCreatedTimerDialog
endfunction
function DestroyTimerDialogBJ takes timerdialog td returns nothing
call DestroyTimerDialog(td)
endfunction
function TimerDialogSetTitleBJ takes timerdialog td,string title returns nothing
call TimerDialogSetTitle(td,title)
endfunction
function TimerDialogSetTitleColorBJ takes timerdialog td,real red,real green,real blue,real transparency returns nothing
call TimerDialogSetTitleColor(td,PercentTo255(red),PercentTo255(green),PercentTo255(blue),PercentTo255(100.0-transparency))
endfunction
function TimerDialogSetTimeColorBJ takes timerdialog td,real red,real green,real blue,real transparency returns nothing
call TimerDialogSetTimeColor(td,PercentTo255(red),PercentTo255(green),PercentTo255(blue),PercentTo255(100.0-transparency))
endfunction
function TimerDialogSetSpeedBJ takes timerdialog td,real speedMultFactor returns nothing
call TimerDialogSetSpeed(td,speedMultFactor)
endfunction
function TimerDialogDisplayForPlayerBJ takes boolean show,timerdialog td,player whichPlayer returns nothing
if(GetLocalPlayer()==whichPlayer)then
call TimerDialogDisplay(td,show)
endif
endfunction
function TimerDialogDisplayBJ takes boolean show,timerdialog td returns nothing
call TimerDialogDisplay(td,show)
endfunction
function GetLastCreatedTimerDialogBJ takes nothing returns timerdialog
return bj_lastCreatedTimerDialog
endfunction
function LeaderboardResizeBJ takes leaderboard lb returns nothing
local integer size=LeaderboardGetItemCount(lb)
if(LeaderboardGetLabelText(lb)=="")then
set size=size-1
endif
call LeaderboardSetSizeByItemCount(lb,size)
endfunction
function LeaderboardSetPlayerItemValueBJ takes player whichPlayer,leaderboard lb,integer val returns nothing
call LeaderboardSetItemValue(lb,LeaderboardGetPlayerIndex(lb,whichPlayer),val)
endfunction
function LeaderboardSetPlayerItemLabelBJ takes player whichPlayer,leaderboard lb,string val returns nothing
call LeaderboardSetItemLabel(lb,LeaderboardGetPlayerIndex(lb,whichPlayer),val)
endfunction
function LeaderboardSetPlayerItemStyleBJ takes player whichPlayer,leaderboard lb,boolean showLabel,boolean showValue,boolean showIcon returns nothing
call LeaderboardSetItemStyle(lb,LeaderboardGetPlayerIndex(lb,whichPlayer),showLabel,showValue,showIcon)
endfunction
function LeaderboardSetPlayerItemLabelColorBJ takes player whichPlayer,leaderboard lb,real red,real green,real blue,real transparency returns nothing
call LeaderboardSetItemLabelColor(lb,LeaderboardGetPlayerIndex(lb,whichPlayer),PercentTo255(red),PercentTo255(green),PercentTo255(blue),PercentTo255(100.0-transparency))
endfunction
function LeaderboardSetPlayerItemValueColorBJ takes player whichPlayer,leaderboard lb,real red,real green,real blue,real transparency returns nothing
call LeaderboardSetItemValueColor(lb,LeaderboardGetPlayerIndex(lb,whichPlayer),PercentTo255(red),PercentTo255(green),PercentTo255(blue),PercentTo255(100.0-transparency))
endfunction
function LeaderboardSetLabelColorBJ takes leaderboard lb,real red,real green,real blue,real transparency returns nothing
call LeaderboardSetLabelColor(lb,PercentTo255(red),PercentTo255(green),PercentTo255(blue),PercentTo255(100.0-transparency))
endfunction
function LeaderboardSetValueColorBJ takes leaderboard lb,real red,real green,real blue,real transparency returns nothing
call LeaderboardSetValueColor(lb,PercentTo255(red),PercentTo255(green),PercentTo255(blue),PercentTo255(100.0-transparency))
endfunction
function LeaderboardSetLabelBJ takes leaderboard lb,string label returns nothing
call LeaderboardSetLabel(lb,label)
call LeaderboardResizeBJ(lb)
endfunction
function LeaderboardSetStyleBJ takes leaderboard lb,boolean showLabel,boolean showNames,boolean showValues,boolean showIcons returns nothing
call LeaderboardSetStyle(lb,showLabel,showNames,showValues,showIcons)
endfunction
function LeaderboardGetItemCountBJ takes leaderboard lb returns integer
return LeaderboardGetItemCount(lb)
endfunction
function LeaderboardHasPlayerItemBJ takes leaderboard lb,player whichPlayer returns boolean
return LeaderboardHasPlayerItem(lb,whichPlayer)
endfunction
function ForceSetLeaderboardBJ takes leaderboard lb,force toForce returns nothing
local integer index
local player indexPlayer
set index=0
loop
set indexPlayer=Player(index)
if IsPlayerInForce(indexPlayer,toForce)then
call PlayerSetLeaderboard(indexPlayer,lb)
endif
set index=index+1
exitwhen index==bj_MAX_PLAYERS
endloop
endfunction
function CreateLeaderboardBJ takes force toForce,string label returns leaderboard
set bj_lastCreatedLeaderboard=CreateLeaderboard()
call LeaderboardSetLabel(bj_lastCreatedLeaderboard,label)
call ForceSetLeaderboardBJ(bj_lastCreatedLeaderboard,toForce)
call LeaderboardDisplay(bj_lastCreatedLeaderboard,true)
return bj_lastCreatedLeaderboard
endfunction
function DestroyLeaderboardBJ takes leaderboard lb returns nothing
call DestroyLeaderboard(lb)
endfunction
function LeaderboardDisplayBJ takes boolean show,leaderboard lb returns nothing
call LeaderboardDisplay(lb,show)
endfunction
function LeaderboardAddItemBJ takes player whichPlayer,leaderboard lb,string label,integer value returns nothing
if(LeaderboardHasPlayerItem(lb,whichPlayer))then
call LeaderboardRemovePlayerItem(lb,whichPlayer)
endif
call LeaderboardAddItem(lb,label,value,whichPlayer)
call LeaderboardResizeBJ(lb)
endfunction
function LeaderboardRemovePlayerItemBJ takes player whichPlayer,leaderboard lb returns nothing
call LeaderboardRemovePlayerItem(lb,whichPlayer)
call LeaderboardResizeBJ(lb)
endfunction
function LeaderboardSortItemsBJ takes leaderboard lb,integer sortType,boolean ascending returns nothing
if(sortType==bj_SORTTYPE_SORTBYVALUE)then
call LeaderboardSortItemsByValue(lb,ascending)
elseif(sortType==bj_SORTTYPE_SORTBYPLAYER)then
call LeaderboardSortItemsByPlayer(lb,ascending)
elseif(sortType==bj_SORTTYPE_SORTBYLABEL)then
call LeaderboardSortItemsByLabel(lb,ascending)
else
endif
endfunction
function LeaderboardSortItemsByPlayerBJ takes leaderboard lb,boolean ascending returns nothing
call LeaderboardSortItemsByPlayer(lb,ascending)
endfunction
function LeaderboardSortItemsByLabelBJ takes leaderboard lb,boolean ascending returns nothing
call LeaderboardSortItemsByLabel(lb,ascending)
endfunction
function LeaderboardGetPlayerIndexBJ takes player whichPlayer,leaderboard lb returns integer
return LeaderboardGetPlayerIndex(lb,whichPlayer)+1
endfunction
function LeaderboardGetIndexedPlayerBJ takes integer position,leaderboard lb returns player
local integer index
local player indexPlayer
set index=0
loop
set indexPlayer=Player(index)
if(LeaderboardGetPlayerIndex(lb,indexPlayer)==position-1)then
return indexPlayer
endif
set index=index+1
exitwhen index==bj_MAX_PLAYERS
endloop
return Player(PLAYER_NEUTRAL_PASSIVE)
endfunction
function PlayerGetLeaderboardBJ takes player whichPlayer returns leaderboard
return PlayerGetLeaderboard(whichPlayer)
endfunction
function GetLastCreatedLeaderboard takes nothing returns leaderboard
return bj_lastCreatedLeaderboard
endfunction
function CreateMultiboardBJ takes integer cols,integer rows,string title returns multiboard
set bj_lastCreatedMultiboard=CreateMultiboard()
call MultiboardSetRowCount(bj_lastCreatedMultiboard,rows)
call MultiboardSetColumnCount(bj_lastCreatedMultiboard,cols)
call MultiboardSetTitleText(bj_lastCreatedMultiboard,title)
call MultiboardDisplay(bj_lastCreatedMultiboard,true)
return bj_lastCreatedMultiboard
endfunction
function DestroyMultiboardBJ takes multiboard mb returns nothing
call DestroyMultiboard(mb)
endfunction
function GetLastCreatedMultiboard takes nothing returns multiboard
return bj_lastCreatedMultiboard
endfunction
function MultiboardDisplayBJ takes boolean show,multiboard mb returns nothing
call MultiboardDisplay(mb,show)
endfunction
function MultiboardMinimizeBJ takes boolean minimize,multiboard mb returns nothing
call MultiboardMinimize(mb,minimize)
endfunction
function MultiboardSetTitleTextColorBJ takes multiboard mb,real red,real green,real blue,real transparency returns nothing
call MultiboardSetTitleTextColor(mb,PercentTo255(red),PercentTo255(green),PercentTo255(blue),PercentTo255(100.0-transparency))
endfunction
function MultiboardAllowDisplayBJ takes boolean flag returns nothing
call MultiboardSuppressDisplay(not flag)
endfunction
function MultiboardSetItemStyleBJ takes multiboard mb,integer col,integer row,boolean showValue,boolean showIcon returns nothing
local integer curRow=0
local integer curCol=0
local integer numRows=MultiboardGetRowCount(mb)
local integer numCols=MultiboardGetColumnCount(mb)
local multiboarditem mbitem=null
loop
set curRow=curRow+1
exitwhen curRow>numRows
if(row==0 or row==curRow)then
set curCol=0
loop
set curCol=curCol+1
exitwhen curCol>numCols
if(col==0 or col==curCol)then
set mbitem=MultiboardGetItem(mb,curRow-1,curCol-1)
call MultiboardSetItemStyle(mbitem,showValue,showIcon)
call MultiboardReleaseItem(mbitem)
endif
endloop
endif
endloop
endfunction
function MultiboardSetItemValueBJ takes multiboard mb,integer col,integer row,string val returns nothing
local integer curRow=0
local integer curCol=0
local integer numRows=MultiboardGetRowCount(mb)
local integer numCols=MultiboardGetColumnCount(mb)
local multiboarditem mbitem=null
loop
set curRow=curRow+1
exitwhen curRow>numRows
if(row==0 or row==curRow)then
set curCol=0
loop
set curCol=curCol+1
exitwhen curCol>numCols
if(col==0 or col==curCol)then
set mbitem=MultiboardGetItem(mb,curRow-1,curCol-1)
call MultiboardSetItemValue(mbitem,val)
call MultiboardReleaseItem(mbitem)
endif
endloop
endif
endloop
endfunction
function MultiboardSetItemColorBJ takes multiboard mb,integer col,integer row,real red,real green,real blue,real transparency returns nothing
local integer curRow=0
local integer curCol=0
local integer numRows=MultiboardGetRowCount(mb)
local integer numCols=MultiboardGetColumnCount(mb)
local multiboarditem mbitem=null
loop
set curRow=curRow+1
exitwhen curRow>numRows
if(row==0 or row==curRow)then
set curCol=0
loop
set curCol=curCol+1
exitwhen curCol>numCols
if(col==0 or col==curCol)then
set mbitem=MultiboardGetItem(mb,curRow-1,curCol-1)
call MultiboardSetItemValueColor(mbitem,PercentTo255(red),PercentTo255(green),PercentTo255(blue),PercentTo255(100.0-transparency))
call MultiboardReleaseItem(mbitem)
endif
endloop
endif
endloop
endfunction
function MultiboardSetItemWidthBJ takes multiboard mb,integer col,integer row,real width returns nothing
local integer curRow=0
local integer curCol=0
local integer numRows=MultiboardGetRowCount(mb)
local integer numCols=MultiboardGetColumnCount(mb)
local multiboarditem mbitem=null
loop
set curRow=curRow+1
exitwhen curRow>numRows
if(row==0 or row==curRow)then
set curCol=0
loop
set curCol=curCol+1
exitwhen curCol>numCols
if(col==0 or col==curCol)then
set mbitem=MultiboardGetItem(mb,curRow-1,curCol-1)
call MultiboardSetItemWidth(mbitem,width/100.0)
call MultiboardReleaseItem(mbitem)
endif
endloop
endif
endloop
endfunction
function MultiboardSetItemIconBJ takes multiboard mb,integer col,integer row,string iconFileName returns nothing
local integer curRow=0
local integer curCol=0
local integer numRows=MultiboardGetRowCount(mb)
local integer numCols=MultiboardGetColumnCount(mb)
local multiboarditem mbitem=null
loop
set curRow=curRow+1
exitwhen curRow>numRows
if(row==0 or row==curRow)then
set curCol=0
loop
set curCol=curCol+1
exitwhen curCol>numCols
if(col==0 or col==curCol)then
set mbitem=MultiboardGetItem(mb,curRow-1,curCol-1)
call MultiboardSetItemIcon(mbitem,iconFileName)
call MultiboardReleaseItem(mbitem)
endif
endloop
endif
endloop
endfunction
function TextTagSize2Height takes real size returns real
return size*0.023/10
endfunction
function TextTagSpeed2Velocity takes real speed returns real
return speed*0.071/128
endfunction
function SetTextTagColorBJ takes texttag tt,real red,real green,real blue,real transparency returns nothing
call SetTextTagColor(tt,PercentTo255(red),PercentTo255(green),PercentTo255(blue),PercentTo255(100.0-transparency))
endfunction
function SetTextTagVelocityBJ takes texttag tt,real speed,real angle returns nothing
local real vel=TextTagSpeed2Velocity(speed)
local real xvel=vel*Cos(angle*bj_DEGTORAD)
local real yvel=vel*Sin(angle*bj_DEGTORAD)
call SetTextTagVelocity(tt,xvel,yvel)
endfunction
function SetTextTagTextBJ takes texttag tt,string s,real size returns nothing
local real textHeight=TextTagSize2Height(size)
call SetTextTagText(tt,s,textHeight)
endfunction
function SetTextTagPosBJ takes texttag tt,location loc,real zOffset returns nothing
call SetTextTagPos(tt,GetLocationX(loc),GetLocationY(loc),zOffset)
endfunction
function SetTextTagPosUnitBJ takes texttag tt,unit whichUnit,real zOffset returns nothing
call SetTextTagPosUnit(tt,whichUnit,zOffset)
endfunction
function SetTextTagSuspendedBJ takes texttag tt,boolean flag returns nothing
call SetTextTagSuspended(tt,flag)
endfunction
function SetTextTagPermanentBJ takes texttag tt,boolean flag returns nothing
call SetTextTagPermanent(tt,flag)
endfunction
function SetTextTagAgeBJ takes texttag tt,real age returns nothing
call SetTextTagAge(tt,age)
endfunction
function SetTextTagLifespanBJ takes texttag tt,real lifespan returns nothing
call SetTextTagLifespan(tt,lifespan)
endfunction
function SetTextTagFadepointBJ takes texttag tt,real fadepoint returns nothing
call SetTextTagFadepoint(tt,fadepoint)
endfunction
function CreateTextTagLocBJ takes string s,location loc,real zOffset,real size,real red,real green,real blue,real transparency returns texttag
set bj_lastCreatedTextTag=CreateTextTag()
call SetTextTagTextBJ(bj_lastCreatedTextTag,s,size)
call SetTextTagPosBJ(bj_lastCreatedTextTag,loc,zOffset)
call SetTextTagColorBJ(bj_lastCreatedTextTag,red,green,blue,transparency)
return bj_lastCreatedTextTag
endfunction
function CreateTextTagUnitBJ takes string s,unit whichUnit,real zOffset,real size,real red,real green,real blue,real transparency returns texttag
set bj_lastCreatedTextTag=CreateTextTag()
call SetTextTagTextBJ(bj_lastCreatedTextTag,s,size)
call SetTextTagPosUnitBJ(bj_lastCreatedTextTag,whichUnit,zOffset)
call SetTextTagColorBJ(bj_lastCreatedTextTag,red,green,blue,transparency)
return bj_lastCreatedTextTag
endfunction
function DestroyTextTagBJ takes texttag tt returns nothing
call DestroyTextTag(tt)
endfunction
function ShowTextTagForceBJ takes boolean show,texttag tt,force whichForce returns nothing
if(IsPlayerInForce(GetLocalPlayer(),whichForce))then
call SetTextTagVisibility(tt,show)
endif
endfunction
function GetLastCreatedTextTag takes nothing returns texttag
return bj_lastCreatedTextTag
endfunction
function PauseGameOn takes nothing returns nothing
call PauseGame(true)
endfunction
function PauseGameOff takes nothing returns nothing
call PauseGame(false)
endfunction
function SetUserControlForceOn takes force whichForce returns nothing
if(IsPlayerInForce(GetLocalPlayer(),whichForce))then
call EnableUserControl(true)
endif
endfunction
function SetUserControlForceOff takes force whichForce returns nothing
if(IsPlayerInForce(GetLocalPlayer(),whichForce))then
call EnableUserControl(false)
endif
endfunction
function ShowInterfaceForceOn takes force whichForce,real fadeDuration returns nothing
if(IsPlayerInForce(GetLocalPlayer(),whichForce))then
call ShowInterface(true,fadeDuration)
endif
endfunction
function ShowInterfaceForceOff takes force whichForce,real fadeDuration returns nothing
if(IsPlayerInForce(GetLocalPlayer(),whichForce))then
call ShowInterface(false,fadeDuration)
endif
endfunction
function PingMinimapForForce takes force whichForce,real x,real y,real duration returns nothing
if(IsPlayerInForce(GetLocalPlayer(),whichForce))then
call PingMinimap(x,y,duration)
endif
endfunction
function PingMinimapLocForForce takes force whichForce,location loc,real duration returns nothing
call PingMinimapForForce(whichForce,GetLocationX(loc),GetLocationY(loc),duration)
endfunction
function PingMinimapForPlayer takes player whichPlayer,real x,real y,real duration returns nothing
if(GetLocalPlayer()==whichPlayer)then
call PingMinimap(x,y,duration)
endif
endfunction
function PingMinimapLocForPlayer takes player whichPlayer,location loc,real duration returns nothing
call PingMinimapForPlayer(whichPlayer,GetLocationX(loc),GetLocationY(loc),duration)
endfunction
function PingMinimapForForceEx takes force whichForce,real x,real y,real duration,integer style,real red,real green,real blue returns nothing
local integer red255=PercentTo255(red)
local integer green255=PercentTo255(green)
local integer blue255=PercentTo255(blue)
if(IsPlayerInForce(GetLocalPlayer(),whichForce))then
if(red255==255)and(green255==0)and(blue255==0)then
set red255=254
endif
if(style==bj_MINIMAPPINGSTYLE_SIMPLE)then
call PingMinimapEx(x,y,duration,red255,green255,blue255,false)
elseif(style==bj_MINIMAPPINGSTYLE_FLASHY)then
call PingMinimapEx(x,y,duration,red255,green255,blue255,true)
elseif(style==bj_MINIMAPPINGSTYLE_ATTACK)then
call PingMinimapEx(x,y,duration,255,0,0,false)
else
endif
endif
endfunction
function PingMinimapLocForForceEx takes force whichForce,location loc,real duration,integer style,real red,real green,real blue returns nothing
call PingMinimapForForceEx(whichForce,GetLocationX(loc),GetLocationY(loc),duration,style,red,green,blue)
endfunction
function EnableWorldFogBoundaryBJ takes boolean enable,force f returns nothing
if(IsPlayerInForce(GetLocalPlayer(),f))then
call EnableWorldFogBoundary(enable)
endif
endfunction
function EnableOcclusionBJ takes boolean enable,force f returns nothing
if(IsPlayerInForce(GetLocalPlayer(),f))then
call EnableOcclusion(enable)
endif
endfunction
function CancelCineSceneBJ takes nothing returns nothing
call StopSoundBJ(bj_cineSceneLastSound,true)
call EndCinematicScene()
endfunction
function TryInitCinematicBehaviorBJ takes nothing returns nothing
local integer index
if(bj_cineSceneBeingSkipped==null)then
set bj_cineSceneBeingSkipped=CreateTrigger()
set index=0
loop
call TriggerRegisterPlayerEvent(bj_cineSceneBeingSkipped,Player(index),EVENT_PLAYER_END_CINEMATIC)
set index=index+1
exitwhen index==bj_MAX_PLAYERS
endloop
call TriggerAddAction(bj_cineSceneBeingSkipped,function CancelCineSceneBJ)
endif
endfunction
function SetCinematicSceneBJ takes sound soundHandle,integer portraitUnitId,playercolor color,string speakerTitle,string text,real sceneDuration,real voiceoverDuration returns nothing
set bj_cineSceneLastSound=soundHandle
call PlaySoundBJ(soundHandle)
call SetCinematicScene(portraitUnitId,color,speakerTitle,text,sceneDuration,voiceoverDuration)
endfunction
function GetTransmissionDuration takes sound soundHandle,integer timeType,real timeVal returns real
local real duration
if(timeType==bj_TIMETYPE_ADD)then
set duration=GetSoundDurationBJ(soundHandle)+timeVal
elseif(timeType==bj_TIMETYPE_SET)then
set duration=timeVal
elseif(timeType==bj_TIMETYPE_SUB)then
set duration=GetSoundDurationBJ(soundHandle)-timeVal
else
set duration=GetSoundDurationBJ(soundHandle)
endif
if(duration<0)then
set duration=0
endif
return duration
endfunction
function WaitTransmissionDuration takes sound soundHandle,integer timeType,real timeVal returns nothing
if(timeType==bj_TIMETYPE_SET)then
call TriggerSleepAction(timeVal)
elseif(soundHandle==null)then
call TriggerSleepAction(bj_NOTHING_SOUND_DURATION)
elseif(timeType==bj_TIMETYPE_SUB)then
call WaitForSoundBJ(soundHandle,timeVal)
elseif(timeType==bj_TIMETYPE_ADD)then
call WaitForSoundBJ(soundHandle,0)
call TriggerSleepAction(timeVal)
else
endif
endfunction
function DoTransmissionBasicsXYBJ takes integer unitId,playercolor color,real x,real y,sound soundHandle,string unitName,string message,real duration returns nothing
call SetCinematicSceneBJ(soundHandle,unitId,color,unitName,message,duration+bj_TRANSMISSION_PORT_HANGTIME,duration)
if(unitId!=0)then
call PingMinimap(x,y,bj_TRANSMISSION_PING_TIME)
endif
endfunction
function TransmissionFromUnitWithNameBJ takes force toForce,unit whichUnit,string unitName,sound soundHandle,string message,integer timeType,real timeVal,boolean wait returns nothing
call TryInitCinematicBehaviorBJ()
set timeVal=RMaxBJ(timeVal,0)
set bj_lastTransmissionDuration=GetTransmissionDuration(soundHandle,timeType,timeVal)
set bj_lastPlayedSound=soundHandle
if(IsPlayerInForce(GetLocalPlayer(),toForce))then
if(whichUnit==null)then
call DoTransmissionBasicsXYBJ(0,PLAYER_COLOR_RED,0,0,soundHandle,unitName,message,bj_lastTransmissionDuration)
else
call DoTransmissionBasicsXYBJ(GetUnitTypeId(whichUnit),GetPlayerColor(GetOwningPlayer(whichUnit)),GetUnitX(whichUnit),GetUnitY(whichUnit),soundHandle,unitName,message,bj_lastTransmissionDuration)
if(not IsUnitHidden(whichUnit))then
call UnitAddIndicator(whichUnit,bj_TRANSMISSION_IND_RED,bj_TRANSMISSION_IND_BLUE,bj_TRANSMISSION_IND_GREEN,bj_TRANSMISSION_IND_ALPHA)
endif
endif
endif
if wait and(bj_lastTransmissionDuration>0)then
call WaitTransmissionDuration(soundHandle,timeType,timeVal)
endif
endfunction
function TransmissionFromUnitTypeWithNameBJ takes force toForce,player fromPlayer,integer unitId,string unitName,location loc,sound soundHandle,string message,integer timeType,real timeVal,boolean wait returns nothing
call TryInitCinematicBehaviorBJ()
set timeVal=RMaxBJ(timeVal,0)
set bj_lastTransmissionDuration=GetTransmissionDuration(soundHandle,timeType,timeVal)
set bj_lastPlayedSound=soundHandle
if(IsPlayerInForce(GetLocalPlayer(),toForce))then
call DoTransmissionBasicsXYBJ(unitId,GetPlayerColor(fromPlayer),GetLocationX(loc),GetLocationY(loc),soundHandle,unitName,message,bj_lastTransmissionDuration)
endif
if wait and(bj_lastTransmissionDuration>0)then
call WaitTransmissionDuration(soundHandle,timeType,timeVal)
endif
endfunction
function GetLastTransmissionDurationBJ takes nothing returns real
return bj_lastTransmissionDuration
endfunction
function ForceCinematicSubtitlesBJ takes boolean flag returns nothing
call ForceCinematicSubtitles(flag)
endfunction
function CinematicModeExBJ takes boolean cineMode,force forForce,real interfaceFadeTime returns nothing
if(not bj_gameStarted)then
set interfaceFadeTime=0
endif
if(cineMode)then
if(not bj_cineModeAlreadyIn)then
set bj_cineModeAlreadyIn=true
set bj_cineModePriorSpeed=GetGameSpeed()
set bj_cineModePriorFogSetting=IsFogEnabled()
set bj_cineModePriorMaskSetting=IsFogMaskEnabled()
set bj_cineModePriorDawnDusk=IsDawnDuskEnabled()
set bj_cineModeSavedSeed=GetRandomInt(0,1000000)
endif
if(IsPlayerInForce(GetLocalPlayer(),forForce))then
call ClearTextMessages()
call ShowInterface(false,interfaceFadeTime)
call EnableUserControl(false)
call EnableOcclusion(false)
call SetCineModeVolumeGroupsBJ()
endif
call SetGameSpeed(bj_CINEMODE_GAMESPEED)
call SetMapFlag(MAP_LOCK_SPEED,true)
call FogMaskEnable(false)
call FogEnable(false)
call EnableWorldFogBoundary(false)
call EnableDawnDusk(false)
call SetRandomSeed(0)
else
set bj_cineModeAlreadyIn=false
if(IsPlayerInForce(GetLocalPlayer(),forForce))then
call ShowInterface(true,interfaceFadeTime)
call EnableUserControl(true)
call EnableOcclusion(true)
call VolumeGroupReset()
call EndThematicMusic()
call CameraResetSmoothingFactorBJ()
endif
call SetMapFlag(MAP_LOCK_SPEED,false)
call SetGameSpeed(bj_cineModePriorSpeed)
call FogMaskEnable(bj_cineModePriorMaskSetting)
call FogEnable(bj_cineModePriorFogSetting)
call EnableWorldFogBoundary(true)
call EnableDawnDusk(bj_cineModePriorDawnDusk)
call SetRandomSeed(bj_cineModeSavedSeed)
endif
endfunction
function CinematicModeBJ takes boolean cineMode,force forForce returns nothing
call CinematicModeExBJ(cineMode,forForce,bj_CINEMODE_INTERFACEFADE)
endfunction
function DisplayCineFilterBJ takes boolean flag returns nothing
call DisplayCineFilter(flag)
endfunction
function CinematicFadeCommonBJ takes real red,real green,real blue,real duration,string tex,real startTrans,real endTrans returns nothing
if(duration==0)then
set startTrans=endTrans
endif
call EnableUserUI(false)
call SetCineFilterTexture(tex)
call SetCineFilterBlendMode(BLEND_MODE_BLEND)
call SetCineFilterTexMapFlags(TEXMAP_FLAG_NONE)
call SetCineFilterStartUV(0,0,1,1)
call SetCineFilterEndUV(0,0,1,1)
call SetCineFilterStartColor(PercentTo255(red),PercentTo255(green),PercentTo255(blue),PercentTo255(100-startTrans))
call SetCineFilterEndColor(PercentTo255(red),PercentTo255(green),PercentTo255(blue),PercentTo255(100-endTrans))
call SetCineFilterDuration(duration)
call DisplayCineFilter(true)
endfunction
function FinishCinematicFadeBJ takes nothing returns nothing
call DestroyTimer(bj_cineFadeFinishTimer)
set bj_cineFadeFinishTimer=null
call DisplayCineFilter(false)
call EnableUserUI(true)
endfunction
function FinishCinematicFadeAfterBJ takes real duration returns nothing
set bj_cineFadeFinishTimer=CreateTimer()
call TimerStart(bj_cineFadeFinishTimer,duration,false,function FinishCinematicFadeBJ)
endfunction
function ContinueCinematicFadeBJ takes nothing returns nothing
call DestroyTimer(bj_cineFadeContinueTimer)
set bj_cineFadeContinueTimer=null
call CinematicFadeCommonBJ(bj_cineFadeContinueRed,bj_cineFadeContinueGreen,bj_cineFadeContinueBlue,bj_cineFadeContinueDuration,bj_cineFadeContinueTex,bj_cineFadeContinueTrans,100)
endfunction
function ContinueCinematicFadeAfterBJ takes real duration,real red,real green,real blue,real trans,string tex returns nothing
set bj_cineFadeContinueRed=red
set bj_cineFadeContinueGreen=green
set bj_cineFadeContinueBlue=blue
set bj_cineFadeContinueTrans=trans
set bj_cineFadeContinueDuration=duration
set bj_cineFadeContinueTex=tex
set bj_cineFadeContinueTimer=CreateTimer()
call TimerStart(bj_cineFadeContinueTimer,duration,false,function ContinueCinematicFadeBJ)
endfunction
function AbortCinematicFadeBJ takes nothing returns nothing
if(bj_cineFadeContinueTimer!=null)then
call DestroyTimer(bj_cineFadeContinueTimer)
endif
if(bj_cineFadeFinishTimer!=null)then
call DestroyTimer(bj_cineFadeFinishTimer)
endif
endfunction
function CinematicFadeBJ takes integer fadetype,real duration,string tex,real red,real green,real blue,real trans returns nothing
if(fadetype==bj_CINEFADETYPE_FADEOUT)then
call AbortCinematicFadeBJ()
call CinematicFadeCommonBJ(red,green,blue,duration,tex,100,trans)
elseif(fadetype==bj_CINEFADETYPE_FADEIN)then
call AbortCinematicFadeBJ()
call CinematicFadeCommonBJ(red,green,blue,duration,tex,trans,100)
call FinishCinematicFadeAfterBJ(duration)
elseif(fadetype==bj_CINEFADETYPE_FADEOUTIN)then
if(duration>0)then
call AbortCinematicFadeBJ()
call CinematicFadeCommonBJ(red,green,blue,duration*0.5,tex,100,trans)
call ContinueCinematicFadeAfterBJ(duration*0.5,red,green,blue,trans,tex)
call FinishCinematicFadeAfterBJ(duration)
endif
else
endif
endfunction
function CinematicFilterGenericBJ takes real duration,blendmode bmode,string tex,real red0,real green0,real blue0,real trans0,real red1,real green1,real blue1,real trans1 returns nothing
call AbortCinematicFadeBJ()
call SetCineFilterTexture(tex)
call SetCineFilterBlendMode(bmode)
call SetCineFilterTexMapFlags(TEXMAP_FLAG_NONE)
call SetCineFilterStartUV(0,0,1,1)
call SetCineFilterEndUV(0,0,1,1)
call SetCineFilterStartColor(PercentTo255(red0),PercentTo255(green0),PercentTo255(blue0),PercentTo255(100-trans0))
call SetCineFilterEndColor(PercentTo255(red1),PercentTo255(green1),PercentTo255(blue1),PercentTo255(100-trans1))
call SetCineFilterDuration(duration)
call DisplayCineFilter(true)
endfunction
function RescueUnitBJ takes unit whichUnit,player rescuer,boolean changeColor returns nothing
if IsUnitDeadBJ(whichUnit)or(GetOwningPlayer(whichUnit)==rescuer)then
return
endif
call StartSound(bj_rescueSound)
call SetUnitOwner(whichUnit,rescuer,changeColor)
call UnitAddIndicator(whichUnit,0,255,0,255)
call PingMinimapForPlayer(rescuer,GetUnitX(whichUnit),GetUnitY(whichUnit),bj_RESCUE_PING_TIME)
endfunction
function TriggerActionUnitRescuedBJ takes nothing returns nothing
local unit theUnit=GetTriggerUnit()
if IsUnitType(theUnit,UNIT_TYPE_STRUCTURE)then
call RescueUnitBJ(theUnit,GetOwningPlayer(GetRescuer()),bj_rescueChangeColorBldg)
else
call RescueUnitBJ(theUnit,GetOwningPlayer(GetRescuer()),bj_rescueChangeColorUnit)
endif
endfunction
function TryInitRescuableTriggersBJ takes nothing returns nothing
local integer index
if(bj_rescueUnitBehavior==null)then
set bj_rescueUnitBehavior=CreateTrigger()
set index=0
loop
call TriggerRegisterPlayerUnitEvent(bj_rescueUnitBehavior,Player(index),EVENT_PLAYER_UNIT_RESCUED,null)
set index=index+1
exitwhen index==bj_MAX_PLAYER_SLOTS
endloop
call TriggerAddAction(bj_rescueUnitBehavior,function TriggerActionUnitRescuedBJ)
endif
endfunction
function SetRescueUnitColorChangeBJ takes boolean changeColor returns nothing
set bj_rescueChangeColorUnit=changeColor
endfunction
function SetRescueBuildingColorChangeBJ takes boolean changeColor returns nothing
set bj_rescueChangeColorBldg=changeColor
endfunction
function MakeUnitRescuableToForceBJEnum takes nothing returns nothing
call TryInitRescuableTriggersBJ()
call SetUnitRescuable(bj_makeUnitRescuableUnit,GetEnumPlayer(),bj_makeUnitRescuableFlag)
endfunction
function MakeUnitRescuableToForceBJ takes unit whichUnit,boolean isRescuable,force whichForce returns nothing
set bj_makeUnitRescuableUnit=whichUnit
set bj_makeUnitRescuableFlag=isRescuable
call ForForce(whichForce,function MakeUnitRescuableToForceBJEnum)
endfunction
function InitRescuableBehaviorBJ takes nothing returns nothing
local integer index
set index=0
loop
if(GetPlayerController(Player(index))==MAP_CONTROL_RESCUABLE)then
call TryInitRescuableTriggersBJ()
return
endif
set index=index+1
exitwhen index==bj_MAX_PLAYERS
endloop
endfunction
function SetPlayerTechResearchedSwap takes integer techid,integer levels,player whichPlayer returns nothing
call SetPlayerTechResearched(whichPlayer,techid,levels)
endfunction
function SetPlayerTechMaxAllowedSwap takes integer techid,integer maximum,player whichPlayer returns nothing
call SetPlayerTechMaxAllowed(whichPlayer,techid,maximum)
endfunction
function SetPlayerMaxHeroesAllowed takes integer maximum,player whichPlayer returns nothing
call SetPlayerTechMaxAllowed(whichPlayer,'HERO',maximum)
endfunction
function GetPlayerTechCountSimple takes integer techid,player whichPlayer returns integer
return GetPlayerTechCount(whichPlayer,techid,true)
endfunction
function GetPlayerTechMaxAllowedSwap takes integer techid,player whichPlayer returns integer
return GetPlayerTechMaxAllowed(whichPlayer,techid)
endfunction
function SetPlayerAbilityAvailableBJ takes boolean avail,integer abilid,player whichPlayer returns nothing
call SetPlayerAbilityAvailable(whichPlayer,abilid,avail)
endfunction
function SetCampaignMenuRaceBJ takes integer campaignNumber returns nothing
if(campaignNumber==bj_CAMPAIGN_INDEX_T)then
call SetCampaignMenuRace(RACE_OTHER)
elseif(campaignNumber==bj_CAMPAIGN_INDEX_H)then
call SetCampaignMenuRace(RACE_HUMAN)
elseif(campaignNumber==bj_CAMPAIGN_INDEX_U)then
call SetCampaignMenuRace(RACE_UNDEAD)
elseif(campaignNumber==bj_CAMPAIGN_INDEX_O)then
call SetCampaignMenuRace(RACE_ORC)
elseif(campaignNumber==bj_CAMPAIGN_INDEX_N)then
call SetCampaignMenuRace(RACE_NIGHTELF)
elseif(campaignNumber==bj_CAMPAIGN_INDEX_XN)then
call SetCampaignMenuRaceEx(bj_CAMPAIGN_OFFSET_XN)
elseif(campaignNumber==bj_CAMPAIGN_INDEX_XH)then
call SetCampaignMenuRaceEx(bj_CAMPAIGN_OFFSET_XH)
elseif(campaignNumber==bj_CAMPAIGN_INDEX_XU)then
call SetCampaignMenuRaceEx(bj_CAMPAIGN_OFFSET_XU)
elseif(campaignNumber==bj_CAMPAIGN_INDEX_XO)then
call SetCampaignMenuRaceEx(bj_CAMPAIGN_OFFSET_XO)
else
endif
endfunction
function SetMissionAvailableBJ takes boolean available,integer missionIndex returns nothing
local integer campaignNumber=missionIndex/1000
local integer missionNumber=missionIndex-campaignNumber*1000
call SetMissionAvailable(campaignNumber,missionNumber,available)
endfunction
function SetCampaignAvailableBJ takes boolean available,integer campaignNumber returns nothing
local integer campaignOffset
if(campaignNumber==bj_CAMPAIGN_INDEX_H)then
call SetTutorialCleared(true)
endif
if(campaignNumber==bj_CAMPAIGN_INDEX_XN)then
set campaignOffset=bj_CAMPAIGN_OFFSET_XN
elseif(campaignNumber==bj_CAMPAIGN_INDEX_XH)then
set campaignOffset=bj_CAMPAIGN_OFFSET_XH
elseif(campaignNumber==bj_CAMPAIGN_INDEX_XU)then
set campaignOffset=bj_CAMPAIGN_OFFSET_XU
elseif(campaignNumber==bj_CAMPAIGN_INDEX_XO)then
set campaignOffset=bj_CAMPAIGN_OFFSET_XO
else
set campaignOffset=campaignNumber
endif
call SetCampaignAvailable(campaignOffset,available)
call SetCampaignMenuRaceBJ(campaignNumber)
call ForceCampaignSelectScreen()
endfunction
function SetCinematicAvailableBJ takes boolean available,integer cinematicIndex returns nothing
if(cinematicIndex==bj_CINEMATICINDEX_TOP)then
call SetOpCinematicAvailable(bj_CAMPAIGN_INDEX_T,available)
call PlayCinematic("TutorialOp")
elseif(cinematicIndex==bj_CINEMATICINDEX_HOP)then
call SetOpCinematicAvailable(bj_CAMPAIGN_INDEX_H,available)
call PlayCinematic("HumanOp")
elseif(cinematicIndex==bj_CINEMATICINDEX_HED)then
call SetEdCinematicAvailable(bj_CAMPAIGN_INDEX_H,available)
call PlayCinematic("HumanEd")
elseif(cinematicIndex==bj_CINEMATICINDEX_OOP)then
call SetOpCinematicAvailable(bj_CAMPAIGN_INDEX_O,available)
call PlayCinematic("OrcOp")
elseif(cinematicIndex==bj_CINEMATICINDEX_OED)then
call SetEdCinematicAvailable(bj_CAMPAIGN_INDEX_O,available)
call PlayCinematic("OrcEd")
elseif(cinematicIndex==bj_CINEMATICINDEX_UOP)then
call SetEdCinematicAvailable(bj_CAMPAIGN_INDEX_U,available)
call PlayCinematic("UndeadOp")
elseif(cinematicIndex==bj_CINEMATICINDEX_UED)then
call SetEdCinematicAvailable(bj_CAMPAIGN_INDEX_U,available)
call PlayCinematic("UndeadEd")
elseif(cinematicIndex==bj_CINEMATICINDEX_NOP)then
call SetEdCinematicAvailable(bj_CAMPAIGN_INDEX_N,available)
call PlayCinematic("NightElfOp")
elseif(cinematicIndex==bj_CINEMATICINDEX_NED)then
call SetEdCinematicAvailable(bj_CAMPAIGN_INDEX_N,available)
call PlayCinematic("NightElfEd")
elseif(cinematicIndex==bj_CINEMATICINDEX_XOP)then
call SetOpCinematicAvailable(bj_CAMPAIGN_OFFSET_XN,available)
call PlayCinematic("IntroX")
elseif(cinematicIndex==bj_CINEMATICINDEX_XED)then
call SetEdCinematicAvailable(bj_CAMPAIGN_OFFSET_XU,available)
call PlayCinematic("OutroX")
else
endif
endfunction
function InitGameCacheBJ takes string campaignFile returns gamecache
set bj_lastCreatedGameCache=InitGameCache(campaignFile)
return bj_lastCreatedGameCache
endfunction
function SaveGameCacheBJ takes gamecache cache returns boolean
return SaveGameCache(cache)
endfunction
function GetLastCreatedGameCacheBJ takes nothing returns gamecache
return bj_lastCreatedGameCache
endfunction
function StoreRealBJ takes real value,string key,string missionKey,gamecache cache returns nothing
call StoreReal(cache,missionKey,key,value)
endfunction
function StoreIntegerBJ takes integer value,string key,string missionKey,gamecache cache returns nothing
call StoreInteger(cache,missionKey,key,value)
endfunction
function StoreBooleanBJ takes boolean value,string key,string missionKey,gamecache cache returns nothing
call StoreBoolean(cache,missionKey,key,value)
endfunction
function StoreStringBJ takes string value,string key,string missionKey,gamecache cache returns boolean
return StoreString(cache,missionKey,key,value)
endfunction
function StoreUnitBJ takes unit whichUnit,string key,string missionKey,gamecache cache returns boolean
return StoreUnit(cache,missionKey,key,whichUnit)
endfunction
function GetStoredRealBJ takes string key,string missionKey,gamecache cache returns real
return GetStoredReal(cache,missionKey,key)
endfunction
function GetStoredIntegerBJ takes string key,string missionKey,gamecache cache returns integer
return GetStoredInteger(cache,missionKey,key)
endfunction
function GetStoredBooleanBJ takes string key,string missionKey,gamecache cache returns boolean
return GetStoredBoolean(cache,missionKey,key)
endfunction
function GetStoredStringBJ takes string key,string missionKey,gamecache cache returns string
local string s
set s=GetStoredString(cache,missionKey,key)
if(s==null)then
return ""
else
return s
endif
endfunction
function RestoreUnitLocFacingAngleBJ takes string key,string missionKey,gamecache cache,player forWhichPlayer,location loc,real facing returns unit
set bj_lastLoadedUnit=RestoreUnit(cache,missionKey,key,forWhichPlayer,GetLocationX(loc),GetLocationY(loc),facing)
return bj_lastLoadedUnit
endfunction
function RestoreUnitLocFacingPointBJ takes string key,string missionKey,gamecache cache,player forWhichPlayer,location loc,location lookAt returns unit
return RestoreUnitLocFacingAngleBJ(key,missionKey,cache,forWhichPlayer,loc,AngleBetweenPoints(loc,lookAt))
endfunction
function GetLastRestoredUnitBJ takes nothing returns unit
return bj_lastLoadedUnit
endfunction
function FlushGameCacheBJ takes gamecache cache returns nothing
call FlushGameCache(cache)
endfunction
function FlushStoredMissionBJ takes string missionKey,gamecache cache returns nothing
call FlushStoredMission(cache,missionKey)
endfunction
function HaveStoredValue takes string key,integer valueType,string missionKey,gamecache cache returns boolean
if(valueType==bj_GAMECACHE_BOOLEAN)then
return HaveStoredBoolean(cache,missionKey,key)
elseif(valueType==bj_GAMECACHE_INTEGER)then
return HaveStoredInteger(cache,missionKey,key)
elseif(valueType==bj_GAMECACHE_REAL)then
return HaveStoredReal(cache,missionKey,key)
elseif(valueType==bj_GAMECACHE_UNIT)then
return HaveStoredUnit(cache,missionKey,key)
elseif(valueType==bj_GAMECACHE_STRING)then
return HaveStoredString(cache,missionKey,key)
else
return false
endif
endfunction
function ShowCustomCampaignButton takes boolean show,integer whichButton returns nothing
call SetCustomCampaignButtonVisible(whichButton-1,show)
endfunction
function IsCustomCampaignButtonVisibile takes integer whichButton returns boolean
return GetCustomCampaignButtonVisible(whichButton-1)
endfunction
function LoadGameBJ takes string loadFileName,boolean doScoreScreen returns nothing
call LoadGame(loadFileName,doScoreScreen)
endfunction
function SaveAndChangeLevelBJ takes string saveFileName,string newLevel,boolean doScoreScreen returns nothing
call SaveGame(saveFileName)
call ChangeLevel(newLevel,doScoreScreen)
endfunction
function SaveAndLoadGameBJ takes string saveFileName,string loadFileName,boolean doScoreScreen returns nothing
call SaveGame(saveFileName)
call LoadGame(loadFileName,doScoreScreen)
endfunction
function RenameSaveDirectoryBJ takes string sourceDirName,string destDirName returns boolean
return RenameSaveDirectory(sourceDirName,destDirName)
endfunction
function RemoveSaveDirectoryBJ takes string sourceDirName returns boolean
return RemoveSaveDirectory(sourceDirName)
endfunction
function CopySaveGameBJ takes string sourceSaveName,string destSaveName returns boolean
return CopySaveGame(sourceSaveName,destSaveName)
endfunction
function GetPlayerStartLocationX takes player whichPlayer returns real
return GetStartLocationX(GetPlayerStartLocation(whichPlayer))
endfunction
function GetPlayerStartLocationY takes player whichPlayer returns real
return GetStartLocationY(GetPlayerStartLocation(whichPlayer))
endfunction
function GetPlayerStartLocationLoc takes player whichPlayer returns location
return GetStartLocationLoc(GetPlayerStartLocation(whichPlayer))
endfunction
function GetRectCenter takes rect whichRect returns location
return Location(GetRectCenterX(whichRect),GetRectCenterY(whichRect))
endfunction
function IsPlayerSlotState takes player whichPlayer,playerslotstate whichState returns boolean
return GetPlayerSlotState(whichPlayer)==whichState
endfunction
function GetFadeFromSeconds takes real seconds returns integer
if(seconds!=0)then
return 128/seconds
else
return 10000
endif
endfunction
function AdjustPlayerStateSimpleBJ takes player whichPlayer,playerstate whichPlayerState,integer delta returns nothing
call SetPlayerState(whichPlayer,whichPlayerState,GetPlayerState(whichPlayer,whichPlayerState)+delta)
endfunction
function AdjustPlayerStateBJ takes integer delta,player whichPlayer,playerstate whichPlayerState returns nothing
if(delta>0)then
if(whichPlayerState==PLAYER_STATE_RESOURCE_GOLD)then
call AdjustPlayerStateSimpleBJ(whichPlayer,PLAYER_STATE_GOLD_GATHERED,delta)
elseif(whichPlayerState==PLAYER_STATE_RESOURCE_LUMBER)then
call AdjustPlayerStateSimpleBJ(whichPlayer,PLAYER_STATE_LUMBER_GATHERED,delta)
endif
endif
call AdjustPlayerStateSimpleBJ(whichPlayer,whichPlayerState,delta)
endfunction
function SetPlayerStateBJ takes player whichPlayer,playerstate whichPlayerState,integer value returns nothing
local integer oldValue=GetPlayerState(whichPlayer,whichPlayerState)
call AdjustPlayerStateBJ(value-oldValue,whichPlayer,whichPlayerState)
endfunction
function SetPlayerFlagBJ takes playerstate whichPlayerFlag,boolean flag,player whichPlayer returns nothing
call SetPlayerState(whichPlayer,whichPlayerFlag,IntegerTertiaryOp(flag,1,0))
endfunction
function SetPlayerTaxRateBJ takes integer rate,playerstate whichResource,player sourcePlayer,player otherPlayer returns nothing
call SetPlayerTaxRate(sourcePlayer,otherPlayer,whichResource,rate)
endfunction
function GetPlayerTaxRateBJ takes playerstate whichResource,player sourcePlayer,player otherPlayer returns integer
return GetPlayerTaxRate(sourcePlayer,otherPlayer,whichResource)
endfunction
function IsPlayerFlagSetBJ takes playerstate whichPlayerFlag,player whichPlayer returns boolean
return GetPlayerState(whichPlayer,whichPlayerFlag)==1
endfunction
function AddResourceAmountBJ takes integer delta,unit whichUnit returns nothing
call AddResourceAmount(whichUnit,delta)
endfunction
function GetConvertedPlayerId takes player whichPlayer returns integer
return GetPlayerId(whichPlayer)+1
endfunction
function ConvertedPlayer takes integer convertedPlayerId returns player
return Player(convertedPlayerId-1)
endfunction
function GetRectWidthBJ takes rect r returns real
return GetRectMaxX(r)-GetRectMinX(r)
endfunction
function GetRectHeightBJ takes rect r returns real
return GetRectMaxY(r)-GetRectMinY(r)
endfunction
function BlightGoldMineForPlayerBJ takes unit goldMine,player whichPlayer returns unit
local real mineX
local real mineY
local integer mineGold
local unit newMine
if GetUnitTypeId(goldMine)!='ngol' then
return null
endif
set mineX=GetUnitX(goldMine)
set mineY=GetUnitY(goldMine)
set mineGold=GetResourceAmount(goldMine)
call RemoveUnit(goldMine)
set newMine=CreateBlightedGoldmine(whichPlayer,mineX,mineY,bj_UNIT_FACING)
call SetResourceAmount(newMine,mineGold)
return newMine
endfunction
function BlightGoldMineForPlayer takes unit goldMine,player whichPlayer returns unit
set bj_lastHauntedGoldMine=BlightGoldMineForPlayerBJ(goldMine,whichPlayer)
return bj_lastHauntedGoldMine
endfunction
function GetLastHauntedGoldMine takes nothing returns unit
return bj_lastHauntedGoldMine
endfunction
function IsPointBlightedBJ takes location where returns boolean
return IsPointBlighted(GetLocationX(where),GetLocationY(where))
endfunction
function SetPlayerColorBJEnum takes nothing returns nothing
call SetUnitColor(GetEnumUnit(),bj_setPlayerTargetColor)
endfunction
function SetPlayerColorBJ takes player whichPlayer,playercolor color,boolean changeExisting returns nothing
local group g
call SetPlayerColor(whichPlayer,color)
if changeExisting then
set bj_setPlayerTargetColor=color
set g=CreateGroup()
call GroupEnumUnitsOfPlayer(g,whichPlayer,null)
call ForGroup(g,function SetPlayerColorBJEnum)
call DestroyGroup(g)
endif
endfunction
function SetPlayerUnitAvailableBJ takes integer unitId,boolean allowed,player whichPlayer returns nothing
if allowed then
call SetPlayerTechMaxAllowed(whichPlayer,unitId,-1)
else
call SetPlayerTechMaxAllowed(whichPlayer,unitId,0)
endif
endfunction
function LockGameSpeedBJ takes nothing returns nothing
call SetMapFlag(MAP_LOCK_SPEED,true)
endfunction
function UnlockGameSpeedBJ takes nothing returns nothing
call SetMapFlag(MAP_LOCK_SPEED,false)
endfunction
function IssueTargetOrderBJ takes unit whichUnit,string order,widget targetWidget returns boolean
return IssueTargetOrder(whichUnit,order,targetWidget)
endfunction
function IssuePointOrderLocBJ takes unit whichUnit,string order,location whichLocation returns boolean
return IssuePointOrderLoc(whichUnit,order,whichLocation)
endfunction
function IssueTargetDestructableOrder takes unit whichUnit,string order,widget targetWidget returns boolean
return IssueTargetOrder(whichUnit,order,targetWidget)
endfunction
function IssueTargetItemOrder takes unit whichUnit,string order,widget targetWidget returns boolean
return IssueTargetOrder(whichUnit,order,targetWidget)
endfunction
function IssueImmediateOrderBJ takes unit whichUnit,string order returns boolean
return IssueImmediateOrder(whichUnit,order)
endfunction
function GroupTargetOrderBJ takes group whichGroup,string order,widget targetWidget returns boolean
return GroupTargetOrder(whichGroup,order,targetWidget)
endfunction
function GroupPointOrderLocBJ takes group whichGroup,string order,location whichLocation returns boolean
return GroupPointOrderLoc(whichGroup,order,whichLocation)
endfunction
function GroupImmediateOrderBJ takes group whichGroup,string order returns boolean
return GroupImmediateOrder(whichGroup,order)
endfunction
function GroupTargetDestructableOrder takes group whichGroup,string order,widget targetWidget returns boolean
return GroupTargetOrder(whichGroup,order,targetWidget)
endfunction
function GroupTargetItemOrder takes group whichGroup,string order,widget targetWidget returns boolean
return GroupTargetOrder(whichGroup,order,targetWidget)
endfunction
function GetDyingDestructable takes nothing returns destructable
return GetTriggerWidget()
endfunction
function SetUnitRallyPoint takes unit whichUnit,location targPos returns nothing
call IssuePointOrderLocBJ(whichUnit,"setrally",targPos)
endfunction
function SetUnitRallyUnit takes unit whichUnit,unit targUnit returns nothing
call IssueTargetOrder(whichUnit,"setrally",targUnit)
endfunction
function SetUnitRallyDestructable takes unit whichUnit,destructable targDest returns nothing
call IssueTargetOrder(whichUnit,"setrally",targDest)
endfunction
function SaveDyingWidget takes nothing returns nothing
set bj_lastDyingWidget=GetTriggerWidget()
endfunction
function SetBlightRectBJ takes boolean addBlight,player whichPlayer,rect r returns nothing
call SetBlightRect(whichPlayer,r,addBlight)
endfunction
function SetBlightRadiusLocBJ takes boolean addBlight,player whichPlayer,location loc,real radius returns nothing
call SetBlightLoc(whichPlayer,loc,radius,addBlight)
endfunction
function GetAbilityName takes integer abilcode returns string
return GetObjectName(abilcode)
endfunction
function MeleeStartingVisibility takes nothing returns nothing
call SetFloatGameState(GAME_STATE_TIME_OF_DAY,bj_MELEE_STARTING_TOD)
endfunction
function MeleeStartingResources takes nothing returns nothing
local integer index
local player indexPlayer
local version v
local integer startingGold
local integer startingLumber
set v=VersionGet()
if(v==VERSION_REIGN_OF_CHAOS)then
set startingGold=bj_MELEE_STARTING_GOLD_V0
set startingLumber=bj_MELEE_STARTING_LUMBER_V0
else
set startingGold=bj_MELEE_STARTING_GOLD_V1
set startingLumber=bj_MELEE_STARTING_LUMBER_V1
endif
set index=0
loop
set indexPlayer=Player(index)
if(GetPlayerSlotState(indexPlayer)==PLAYER_SLOT_STATE_PLAYING)then
call SetPlayerState(indexPlayer,PLAYER_STATE_RESOURCE_GOLD,startingGold)
call SetPlayerState(indexPlayer,PLAYER_STATE_RESOURCE_LUMBER,startingLumber)
endif
set index=index+1
exitwhen index==bj_MAX_PLAYERS
endloop
endfunction
function ReducePlayerTechMaxAllowed takes player whichPlayer,integer techId,integer limit returns nothing
local integer oldMax=GetPlayerTechMaxAllowed(whichPlayer,techId)
if(oldMax<0 or oldMax>limit)then
call SetPlayerTechMaxAllowed(whichPlayer,techId,limit)
endif
endfunction
function MeleeStartingHeroLimit takes nothing returns nothing
local integer index
set index=0
loop
call SetPlayerMaxHeroesAllowed(bj_MELEE_HERO_LIMIT,Player(index))
call ReducePlayerTechMaxAllowed(Player(index),'Hamg',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Hmkg',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Hpal',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Hblm',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Obla',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Ofar',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Otch',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Oshd',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Edem',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Ekee',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Emoo',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Ewar',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Udea',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Udre',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Ulic',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Ucrl',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Npbm',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Nbrn',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Nngs',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Nplh',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Nbst',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Nalc',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Ntin',bj_MELEE_HERO_TYPE_LIMIT)
call ReducePlayerTechMaxAllowed(Player(index),'Nfir',bj_MELEE_HERO_TYPE_LIMIT)
set index=index+1
exitwhen index==bj_MAX_PLAYERS
endloop
endfunction
function MeleeTrainedUnitIsHeroBJFilter takes nothing returns boolean
return IsUnitType(GetFilterUnit(),UNIT_TYPE_HERO)
endfunction
function MeleeGrantItemsToHero takes unit whichUnit returns nothing
local integer owner=GetPlayerId(GetOwningPlayer(whichUnit))
if(bj_meleeTwinkedHeroes[owner]<bj_MELEE_MAX_TWINKED_HEROES)then
call UnitAddItemById(whichUnit,'stwp')
set bj_meleeTwinkedHeroes[owner]=bj_meleeTwinkedHeroes[owner]+1
endif
endfunction
function MeleeGrantItemsToTrainedHero takes nothing returns nothing
call MeleeGrantItemsToHero(GetTrainedUnit())
endfunction
function MeleeGrantItemsToHiredHero takes nothing returns nothing
call MeleeGrantItemsToHero(GetSoldUnit())
endfunction
function MeleeGrantHeroItems takes nothing returns nothing
local integer index
local trigger trig
set index=0
loop
set bj_meleeTwinkedHeroes[index]=0
set index=index+1
exitwhen index==bj_MAX_PLAYER_SLOTS
endloop
set index=0
loop
set trig=CreateTrigger()
call TriggerRegisterPlayerUnitEvent(trig,Player(index),EVENT_PLAYER_UNIT_TRAIN_FINISH,filterMeleeTrainedUnitIsHeroBJ)
call TriggerAddAction(trig,function MeleeGrantItemsToTrainedHero)
set index=index+1
exitwhen index==bj_MAX_PLAYERS
endloop
set trig=CreateTrigger()
call TriggerRegisterPlayerUnitEvent(trig,Player(PLAYER_NEUTRAL_PASSIVE),EVENT_PLAYER_UNIT_SELL,filterMeleeTrainedUnitIsHeroBJ)
call TriggerAddAction(trig,function MeleeGrantItemsToHiredHero)
set bj_meleeGrantHeroItems=true
endfunction
function MeleeClearExcessUnit takes nothing returns nothing
local unit theUnit=GetEnumUnit()
local integer owner=GetPlayerId(GetOwningPlayer(theUnit))
if(owner==PLAYER_NEUTRAL_AGGRESSIVE)then
call RemoveUnit(GetEnumUnit())
elseif(owner==PLAYER_NEUTRAL_PASSIVE)then
if not IsUnitType(theUnit,UNIT_TYPE_STRUCTURE)then
call RemoveUnit(GetEnumUnit())
endif
endif
endfunction
function MeleeClearNearbyUnits takes real x,real y,real range returns nothing
local group nearbyUnits
set nearbyUnits=CreateGroup()
call GroupEnumUnitsInRange(nearbyUnits,x,y,range,null)
call ForGroup(nearbyUnits,function MeleeClearExcessUnit)
call DestroyGroup(nearbyUnits)
endfunction
function MeleeClearExcessUnits takes nothing returns nothing
local integer index
local real locX
local real locY
local player indexPlayer
set index=0
loop
set indexPlayer=Player(index)
if(GetPlayerSlotState(indexPlayer)==PLAYER_SLOT_STATE_PLAYING)then
set locX=GetStartLocationX(GetPlayerStartLocation(indexPlayer))
set locY=GetStartLocationY(GetPlayerStartLocation(indexPlayer))
call MeleeClearNearbyUnits(locX,locY,bj_MELEE_CLEAR_UNITS_RADIUS)
endif
set index=index+1
exitwhen index==bj_MAX_PLAYERS
endloop
endfunction
function MeleeEnumFindNearestMine takes nothing returns nothing
local unit enumUnit=GetEnumUnit()
local real dist
local location unitLoc
if(GetUnitTypeId(enumUnit)=='ngol')then
set unitLoc=GetUnitLoc(enumUnit)
set dist=DistanceBetweenPoints(unitLoc,bj_meleeNearestMineToLoc)
call RemoveLocation(unitLoc)
if(bj_meleeNearestMineDist<0)or(dist<bj_meleeNearestMineDist)then
set bj_meleeNearestMine=enumUnit
set bj_meleeNearestMineDist=dist
endif
endif
endfunction
function MeleeFindNearestMine takes location src,real range returns unit
local group nearbyMines
set bj_meleeNearestMine=null
set bj_meleeNearestMineDist=-1
set bj_meleeNearestMineToLoc=src
set nearbyMines=CreateGroup()
call GroupEnumUnitsInRangeOfLoc(nearbyMines,src,range,null)
call ForGroup(nearbyMines,function MeleeEnumFindNearestMine)
call DestroyGroup(nearbyMines)
return bj_meleeNearestMine
endfunction
function MeleeRandomHeroLoc takes player p,integer id1,integer id2,integer id3,integer id4,location loc returns unit
local unit hero=null
local integer roll
local integer pick
local version v
set v=VersionGet()
if(v==VERSION_REIGN_OF_CHAOS)then
set roll=GetRandomInt(1,3)
else
set roll=GetRandomInt(1,4)
endif
if roll==1 then
set pick=id1
elseif roll==2 then
set pick=id2
elseif roll==3 then
set pick=id3
elseif roll==4 then
set pick=id4
else
set pick=id1
endif
set hero=CreateUnitAtLoc(p,pick,loc,bj_UNIT_FACING)
if bj_meleeGrantHeroItems then
call MeleeGrantItemsToHero(hero)
endif
return hero
endfunction
function MeleeGetProjectedLoc takes location src,location targ,real distance,real deltaAngle returns location
local real srcX=GetLocationX(src)
local real srcY=GetLocationY(src)
local real direction=Atan2(GetLocationY(targ)-srcY,GetLocationX(targ)-srcX)+deltaAngle
return Location(srcX+distance*Cos(direction),srcY+distance*Sin(direction))
endfunction
function MeleeGetNearestValueWithin takes real val,real minVal,real maxVal returns real
if(val<minVal)then
return minVal
elseif(val>maxVal)then
return maxVal
else
return val
endif
endfunction
function MeleeGetLocWithinRect takes location src,rect r returns location
local real withinX=MeleeGetNearestValueWithin(GetLocationX(src),GetRectMinX(r),GetRectMaxX(r))
local real withinY=MeleeGetNearestValueWithin(GetLocationY(src),GetRectMinY(r),GetRectMaxY(r))
return Location(withinX,withinY)
endfunction
function MeleeStartingUnitsHuman takes player whichPlayer,location startLoc,boolean doHeroes,boolean doCamera,boolean doPreload returns nothing
local boolean useRandomHero=IsMapFlagSet(MAP_RANDOM_HERO)
local real unitSpacing=64.00
local unit nearestMine
local location nearMineLoc
local location heroLoc
local real peonX
local real peonY
local unit townHall=null
if(doPreload)then
call Preloader("scripts\\HumanMelee.pld")
endif
set nearestMine=MeleeFindNearestMine(startLoc,bj_MELEE_MINE_SEARCH_RADIUS)
if(nearestMine!=null)then
set townHall=CreateUnitAtLoc(whichPlayer,'htow',startLoc,bj_UNIT_FACING)
set nearMineLoc=MeleeGetProjectedLoc(GetUnitLoc(nearestMine),startLoc,320,0)
set peonX=GetLocationX(nearMineLoc)
set peonY=GetLocationY(nearMineLoc)
call CreateUnit(whichPlayer,'hpea',peonX+0.00*unitSpacing,peonY+1.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'hpea',peonX+1.00*unitSpacing,peonY+0.15*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'hpea',peonX-1.00*unitSpacing,peonY+0.15*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'hpea',peonX+0.60*unitSpacing,peonY-1.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'hpea',peonX-0.60*unitSpacing,peonY-1.00*unitSpacing,bj_UNIT_FACING)
set heroLoc=MeleeGetProjectedLoc(GetUnitLoc(nearestMine),startLoc,384,45)
else
set townHall=CreateUnitAtLoc(whichPlayer,'htow',startLoc,bj_UNIT_FACING)
set peonX=GetLocationX(startLoc)
set peonY=GetLocationY(startLoc)-224.00
call CreateUnit(whichPlayer,'hpea',peonX+2.00*unitSpacing,peonY+0.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'hpea',peonX+1.00*unitSpacing,peonY+0.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'hpea',peonX+0.00*unitSpacing,peonY+0.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'hpea',peonX-1.00*unitSpacing,peonY+0.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'hpea',peonX-2.00*unitSpacing,peonY+0.00*unitSpacing,bj_UNIT_FACING)
set heroLoc=Location(peonX,peonY-2.00*unitSpacing)
endif
if(townHall!=null)then
call UnitAddAbilityBJ('Amic',townHall)
call UnitMakeAbilityPermanentBJ(true,'Amic',townHall)
endif
if(doHeroes)then
if useRandomHero then
call MeleeRandomHeroLoc(whichPlayer,'Hamg', 'Hmkg', 'Hpal', 'Hblm',heroLoc)
else
call SetPlayerState(whichPlayer,PLAYER_STATE_RESOURCE_HERO_TOKENS,bj_MELEE_STARTING_HERO_TOKENS)
endif
endif
if(doCamera)then
call SetCameraPositionForPlayer(whichPlayer,peonX,peonY)
call SetCameraQuickPositionForPlayer(whichPlayer,peonX,peonY)
endif
endfunction
function MeleeStartingUnitsOrc takes player whichPlayer,location startLoc,boolean doHeroes,boolean doCamera,boolean doPreload returns nothing
local boolean useRandomHero=IsMapFlagSet(MAP_RANDOM_HERO)
local real unitSpacing=64.00
local unit nearestMine
local location nearMineLoc
local location heroLoc
local real peonX
local real peonY
if(doPreload)then
call Preloader("scripts\\OrcMelee.pld")
endif
set nearestMine=MeleeFindNearestMine(startLoc,bj_MELEE_MINE_SEARCH_RADIUS)
if(nearestMine!=null)then
call CreateUnitAtLoc(whichPlayer,'ogre',startLoc,bj_UNIT_FACING)
set nearMineLoc=MeleeGetProjectedLoc(GetUnitLoc(nearestMine),startLoc,320,0)
set peonX=GetLocationX(nearMineLoc)
set peonY=GetLocationY(nearMineLoc)
call CreateUnit(whichPlayer,'opeo',peonX+0.00*unitSpacing,peonY+1.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'opeo',peonX+1.00*unitSpacing,peonY+0.15*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'opeo',peonX-1.00*unitSpacing,peonY+0.15*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'opeo',peonX+0.60*unitSpacing,peonY-1.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'opeo',peonX-0.60*unitSpacing,peonY-1.00*unitSpacing,bj_UNIT_FACING)
set heroLoc=MeleeGetProjectedLoc(GetUnitLoc(nearestMine),startLoc,384,45)
else
call CreateUnitAtLoc(whichPlayer,'ogre',startLoc,bj_UNIT_FACING)
set peonX=GetLocationX(startLoc)
set peonY=GetLocationY(startLoc)-224.00
call CreateUnit(whichPlayer,'opeo',peonX+2.00*unitSpacing,peonY+0.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'opeo',peonX+1.00*unitSpacing,peonY+0.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'opeo',peonX+0.00*unitSpacing,peonY+0.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'opeo',peonX-1.00*unitSpacing,peonY+0.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'opeo',peonX-2.00*unitSpacing,peonY+0.00*unitSpacing,bj_UNIT_FACING)
set heroLoc=Location(peonX,peonY-2.00*unitSpacing)
endif
if(doHeroes)then
if useRandomHero then
call MeleeRandomHeroLoc(whichPlayer,'Obla', 'Ofar', 'Otch', 'Oshd',heroLoc)
else
call SetPlayerState(whichPlayer,PLAYER_STATE_RESOURCE_HERO_TOKENS,bj_MELEE_STARTING_HERO_TOKENS)
endif
endif
if(doCamera)then
call SetCameraPositionForPlayer(whichPlayer,peonX,peonY)
call SetCameraQuickPositionForPlayer(whichPlayer,peonX,peonY)
endif
endfunction
function MeleeStartingUnitsUndead takes player whichPlayer,location startLoc,boolean doHeroes,boolean doCamera,boolean doPreload returns nothing
local boolean useRandomHero=IsMapFlagSet(MAP_RANDOM_HERO)
local real unitSpacing=64.00
local unit nearestMine
local location nearMineLoc
local location nearTownLoc
local location heroLoc
local real peonX
local real peonY
local real ghoulX
local real ghoulY
if(doPreload)then
call Preloader("scripts\\UndeadMelee.pld")
endif
set nearestMine=MeleeFindNearestMine(startLoc,bj_MELEE_MINE_SEARCH_RADIUS)
if(nearestMine!=null)then
call CreateUnitAtLoc(whichPlayer,'unpl',startLoc,bj_UNIT_FACING)
set nearestMine=BlightGoldMineForPlayerBJ(nearestMine,whichPlayer)
set nearTownLoc=MeleeGetProjectedLoc(startLoc,GetUnitLoc(nearestMine),288,0)
set ghoulX=GetLocationX(nearTownLoc)
set ghoulY=GetLocationY(nearTownLoc)
set bj_ghoul[GetPlayerId(whichPlayer)]=CreateUnit(whichPlayer,'ugho',ghoulX+0.00*unitSpacing,ghoulY+0.00*unitSpacing,bj_UNIT_FACING)
set nearMineLoc=MeleeGetProjectedLoc(GetUnitLoc(nearestMine),startLoc,320,0)
set peonX=GetLocationX(nearMineLoc)
set peonY=GetLocationY(nearMineLoc)
call CreateUnit(whichPlayer,'uaco',peonX+0.00*unitSpacing,peonY+0.50*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'uaco',peonX+0.65*unitSpacing,peonY-0.50*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'uaco',peonX-0.65*unitSpacing,peonY-0.50*unitSpacing,bj_UNIT_FACING)
call SetBlightLoc(whichPlayer,nearMineLoc,768,true)
set heroLoc=MeleeGetProjectedLoc(GetUnitLoc(nearestMine),startLoc,384,45)
else
call CreateUnitAtLoc(whichPlayer,'unpl',startLoc,bj_UNIT_FACING)
set peonX=GetLocationX(startLoc)
set peonY=GetLocationY(startLoc)-224.00
call CreateUnit(whichPlayer,'uaco',peonX-1.50*unitSpacing,peonY+0.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'uaco',peonX-0.50*unitSpacing,peonY+0.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'uaco',peonX+0.50*unitSpacing,peonY+0.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'ugho',peonX+1.50*unitSpacing,peonY+0.00*unitSpacing,bj_UNIT_FACING)
call SetBlightLoc(whichPlayer,startLoc,768,true)
set heroLoc=Location(peonX,peonY-2.00*unitSpacing)
endif
if(doHeroes)then
if useRandomHero then
call MeleeRandomHeroLoc(whichPlayer,'Udea', 'Udre', 'Ulic', 'Ucrl',heroLoc)
else
call SetPlayerState(whichPlayer,PLAYER_STATE_RESOURCE_HERO_TOKENS,bj_MELEE_STARTING_HERO_TOKENS)
endif
endif
if(doCamera)then
call SetCameraPositionForPlayer(whichPlayer,peonX,peonY)
call SetCameraQuickPositionForPlayer(whichPlayer,peonX,peonY)
endif
endfunction
function MeleeStartingUnitsNightElf takes player whichPlayer,location startLoc,boolean doHeroes,boolean doCamera,boolean doPreload returns nothing
local boolean useRandomHero=IsMapFlagSet(MAP_RANDOM_HERO)
local real unitSpacing=64.00
local real minTreeDist=3.50*bj_CELLWIDTH
local real minWispDist=1.75*bj_CELLWIDTH
local unit nearestMine
local location nearMineLoc
local location wispLoc
local location heroLoc
local real peonX
local real peonY
local unit tree
if(doPreload)then
call Preloader("scripts\\NightElfMelee.pld")
endif
set nearestMine=MeleeFindNearestMine(startLoc,bj_MELEE_MINE_SEARCH_RADIUS)
if(nearestMine!=null)then
set nearMineLoc=MeleeGetProjectedLoc(GetUnitLoc(nearestMine),startLoc,650,0)
set nearMineLoc=MeleeGetLocWithinRect(nearMineLoc,GetRectFromCircleBJ(GetUnitLoc(nearestMine),minTreeDist))
set tree=CreateUnitAtLoc(whichPlayer,'etol',nearMineLoc,bj_UNIT_FACING)
call IssueTargetOrder(tree,"entangleinstant",nearestMine)
set wispLoc=MeleeGetProjectedLoc(GetUnitLoc(nearestMine),startLoc,320,0)
set wispLoc=MeleeGetLocWithinRect(wispLoc,GetRectFromCircleBJ(GetUnitLoc(nearestMine),minWispDist))
set peonX=GetLocationX(wispLoc)
set peonY=GetLocationY(wispLoc)
call CreateUnit(whichPlayer,'ewsp',peonX+0.00*unitSpacing,peonY+1.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'ewsp',peonX+1.00*unitSpacing,peonY+0.15*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'ewsp',peonX-1.00*unitSpacing,peonY+0.15*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'ewsp',peonX+0.58*unitSpacing,peonY-1.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'ewsp',peonX-0.58*unitSpacing,peonY-1.00*unitSpacing,bj_UNIT_FACING)
set heroLoc=MeleeGetProjectedLoc(GetUnitLoc(nearestMine),startLoc,384,45)
else
call CreateUnitAtLoc(whichPlayer,'etol',startLoc,bj_UNIT_FACING)
set peonX=GetLocationX(startLoc)
set peonY=GetLocationY(startLoc)-224.00
call CreateUnit(whichPlayer,'ewsp',peonX-2.00*unitSpacing,peonY+0.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'ewsp',peonX-1.00*unitSpacing,peonY+0.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'ewsp',peonX+0.00*unitSpacing,peonY+0.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'ewsp',peonX+1.00*unitSpacing,peonY+0.00*unitSpacing,bj_UNIT_FACING)
call CreateUnit(whichPlayer,'ewsp',peonX+2.00*unitSpacing,peonY+0.00*unitSpacing,bj_UNIT_FACING)
set heroLoc=Location(peonX,peonY-2.00*unitSpacing)
endif
if(doHeroes)then
if useRandomHero then
call MeleeRandomHeroLoc(whichPlayer,'Edem', 'Ekee', 'Emoo', 'Ewar',heroLoc)
else
call SetPlayerState(whichPlayer,PLAYER_STATE_RESOURCE_HERO_TOKENS,bj_MELEE_STARTING_HERO_TOKENS)
endif
endif
if(doCamera)then
call SetCameraPositionForPlayer(whichPlayer,peonX,peonY)
call SetCameraQuickPositionForPlayer(whichPlayer,peonX,peonY)
endif
endfunction
function MeleeStartingUnitsUnknownRace takes player whichPlayer,location startLoc,boolean doHeroes,boolean doCamera,boolean doPreload returns nothing
local integer index
if(doPreload)then
endif
set index=0
loop
call CreateUnit(whichPlayer,'nshe',GetLocationX(startLoc)+GetRandomReal(-256,256),GetLocationY(startLoc)+GetRandomReal(-256,256),GetRandomReal(0,360))
set index=index+1
exitwhen index==12
endloop
if(doHeroes)then
call SetPlayerState(whichPlayer,PLAYER_STATE_RESOURCE_HERO_TOKENS,bj_MELEE_STARTING_HERO_TOKENS)
endif
if(doCamera)then
call SetCameraPositionLocForPlayer(whichPlayer,startLoc)
call SetCameraQuickPositionLocForPlayer(whichPlayer,startLoc)
endif
endfunction
function MeleeStartingUnits takes nothing returns nothing
local integer index
local player indexPlayer
local location indexStartLoc
local race indexRace
call Preloader("scripts\\SharedMelee.pld")
set index=0
loop
set indexPlayer=Player(index)
if(GetPlayerSlotState(indexPlayer)==PLAYER_SLOT_STATE_PLAYING)then
set indexStartLoc=GetStartLocationLoc(GetPlayerStartLocation(indexPlayer))
set indexRace=GetPlayerRace(indexPlayer)
if(indexRace==RACE_HUMAN)then
call MeleeStartingUnitsHuman(indexPlayer,indexStartLoc,true,true,true)
elseif(indexRace==RACE_ORC)then
call MeleeStartingUnitsOrc(indexPlayer,indexStartLoc,true,true,true)
elseif(indexRace==RACE_UNDEAD)then
call MeleeStartingUnitsUndead(indexPlayer,indexStartLoc,true,true,true)
elseif(indexRace==RACE_NIGHTELF)then
call MeleeStartingUnitsNightElf(indexPlayer,indexStartLoc,true,true,true)
else
call MeleeStartingUnitsUnknownRace(indexPlayer,indexStartLoc,true,true,true)
endif
endif
set index=index+1
exitwhen index==bj_MAX_PLAYERS
endloop
endfunction
function MeleeStartingUnitsForPlayer takes race whichRace,player whichPlayer,location loc,boolean doHeroes returns nothing
if(whichRace==RACE_HUMAN)then
call MeleeStartingUnitsHuman(whichPlayer,loc,doHeroes,false,false)
elseif(whichRace==RACE_ORC)then
call MeleeStartingUnitsOrc(whichPlayer,loc,doHeroes,false,false)
elseif(whichRace==RACE_UNDEAD)then
call MeleeStartingUnitsUndead(whichPlayer,loc,doHeroes,false,false)
elseif(whichRace==RACE_NIGHTELF)then
call MeleeStartingUnitsNightElf(whichPlayer,loc,doHeroes,false,false)
else
endif
endfunction
function PickMeleeAI takes player num,string s1,string s2,string s3 returns nothing
local integer pick
if GetAIDifficulty(num)==AI_DIFFICULTY_NEWBIE then
call StartMeleeAI(num,s1)
return
endif
if s2==null then
set pick=1
elseif s3==null then
set pick=GetRandomInt(1,2)
else
set pick=GetRandomInt(1,3)
endif
if pick==1 then
call StartMeleeAI(num,s1)
elseif pick==2 then
call StartMeleeAI(num,s2)
else
call StartMeleeAI(num,s3)
endif
endfunction
function MeleeStartingAI takes nothing returns nothing
local integer index
local player indexPlayer
local race indexRace
set index=0
loop
set indexPlayer=Player(index)
if(GetPlayerSlotState(indexPlayer)==PLAYER_SLOT_STATE_PLAYING)then
set indexRace=GetPlayerRace(indexPlayer)
if(GetPlayerController(indexPlayer)==MAP_CONTROL_COMPUTER)then
if(indexRace==RACE_HUMAN)then
call PickMeleeAI(indexPlayer,"human.ai",null,null)
elseif(indexRace==RACE_ORC)then
call PickMeleeAI(indexPlayer,"orc.ai",null,null)
elseif(indexRace==RACE_UNDEAD)then
call PickMeleeAI(indexPlayer,"undead.ai",null,null)
call RecycleGuardPosition(bj_ghoul[index])
elseif(indexRace==RACE_NIGHTELF)then
call PickMeleeAI(indexPlayer,"elf.ai",null,null)
else
endif
call ShareEverythingWithTeamAI(indexPlayer)
endif
endif
set index=index+1
exitwhen index==bj_MAX_PLAYERS
endloop
endfunction
function LockGuardPosition takes unit targ returns nothing
call SetUnitCreepGuard(targ,true)
endfunction
function MeleePlayerIsOpponent takes integer playerIndex,integer opponentIndex returns boolean
local player thePlayer=Player(playerIndex)
local player theOpponent=Player(opponentIndex)
if(playerIndex==opponentIndex)then
return false
endif
if(GetPlayerSlotState(theOpponent)!=PLAYER_SLOT_STATE_PLAYING)then
return false
endif
if(bj_meleeDefeated[opponentIndex])then
return false
endif
if GetPlayerAlliance(thePlayer,theOpponent,ALLIANCE_PASSIVE)then
if GetPlayerAlliance(theOpponent,thePlayer,ALLIANCE_PASSIVE)then
if(GetPlayerState(thePlayer,PLAYER_STATE_ALLIED_VICTORY)==1)then
if(GetPlayerState(theOpponent,PLAYER_STATE_ALLIED_VICTORY)==1)then
return false
endif
endif
endif
endif
return true
endfunction
function MeleeGetAllyStructureCount takes player whichPlayer returns integer
local integer playerIndex
local integer buildingCount
local player indexPlayer
set buildingCount=0
set playerIndex=0
loop
set indexPlayer=Player(playerIndex)
if(PlayersAreCoAllied(whichPlayer,indexPlayer))then
set buildingCount=buildingCount+GetPlayerStructureCount(indexPlayer,true)
endif
set playerIndex=playerIndex+1
exitwhen playerIndex==bj_MAX_PLAYERS
endloop
return buildingCount
endfunction
function MeleeGetAllyCount takes player whichPlayer returns integer
local integer playerIndex
local integer playerCount
local player indexPlayer
set playerCount=0
set playerIndex=0
loop
set indexPlayer=Player(playerIndex)
if PlayersAreCoAllied(whichPlayer,indexPlayer)and not bj_meleeDefeated[playerIndex]and(whichPlayer!=indexPlayer)then
set playerCount=playerCount+1
endif
set playerIndex=playerIndex+1
exitwhen playerIndex==bj_MAX_PLAYERS
endloop
return playerCount
endfunction
function MeleeGetAllyKeyStructureCount takes player whichPlayer returns integer
local integer playerIndex
local player indexPlayer
local integer keyStructs
set keyStructs=0
set playerIndex=0
loop
set indexPlayer=Player(playerIndex)
if(PlayersAreCoAllied(whichPlayer,indexPlayer))then
set keyStructs=keyStructs+GetPlayerTypedUnitCount(indexPlayer,"townhall",true,true)
set keyStructs=keyStructs+GetPlayerTypedUnitCount(indexPlayer,"greathall",true,true)
set keyStructs=keyStructs+GetPlayerTypedUnitCount(indexPlayer,"treeoflife",true,true)
set keyStructs=keyStructs+GetPlayerTypedUnitCount(indexPlayer,"necropolis",true,true)
endif
set playerIndex=playerIndex+1
exitwhen playerIndex==bj_MAX_PLAYERS
endloop
return keyStructs
endfunction
function MeleeDoDrawEnum takes nothing returns nothing
local player thePlayer=GetEnumPlayer()
call CachePlayerHeroData(thePlayer)
call RemovePlayerPreserveUnitsBJ(thePlayer,PLAYER_GAME_RESULT_TIE,false)
endfunction
function MeleeDoVictoryEnum takes nothing returns nothing
local player thePlayer=GetEnumPlayer()
local integer playerIndex=GetPlayerId(thePlayer)
if(not bj_meleeVictoried[playerIndex])then
set bj_meleeVictoried[playerIndex]=true
call CachePlayerHeroData(thePlayer)
call RemovePlayerPreserveUnitsBJ(thePlayer,PLAYER_GAME_RESULT_VICTORY,false)
endif
endfunction
function MeleeDoDefeat takes player whichPlayer returns nothing
set bj_meleeDefeated[GetPlayerId(whichPlayer)]=true
call RemovePlayerPreserveUnitsBJ(whichPlayer,PLAYER_GAME_RESULT_DEFEAT,false)
endfunction
function MeleeDoDefeatEnum takes nothing returns nothing
local player thePlayer=GetEnumPlayer()
call CachePlayerHeroData(thePlayer)
call MakeUnitsPassiveForTeam(thePlayer)
call MeleeDoDefeat(thePlayer)
endfunction
function MeleeDoLeave takes player whichPlayer returns nothing
if(GetIntegerGameState(GAME_STATE_DISCONNECTED)!=0)then
call GameOverDialogBJ(whichPlayer,true)
else
set bj_meleeDefeated[GetPlayerId(whichPlayer)]=true
call RemovePlayerPreserveUnitsBJ(whichPlayer,PLAYER_GAME_RESULT_DEFEAT,true)
endif
endfunction
function MeleeRemoveObservers takes nothing returns nothing
local integer playerIndex
local player indexPlayer
set playerIndex=0
loop
set indexPlayer=Player(playerIndex)
if(IsPlayerObserver(indexPlayer))then
call RemovePlayerPreserveUnitsBJ(indexPlayer,PLAYER_GAME_RESULT_NEUTRAL,false)
endif
set playerIndex=playerIndex+1
exitwhen playerIndex==bj_MAX_PLAYERS
endloop
endfunction
function MeleeCheckForVictors takes nothing returns force
local integer playerIndex
local integer opponentIndex
local force opponentlessPlayers=CreateForce()
local boolean gameOver=false
set playerIndex=0
loop
if(not bj_meleeDefeated[playerIndex])then
set opponentIndex=0
loop
if MeleePlayerIsOpponent(playerIndex,opponentIndex)then
return CreateForce()
endif
set opponentIndex=opponentIndex+1
exitwhen opponentIndex==bj_MAX_PLAYERS
endloop
call ForceAddPlayer(opponentlessPlayers,Player(playerIndex))
set gameOver=true
endif
set playerIndex=playerIndex+1
exitwhen playerIndex==bj_MAX_PLAYERS
endloop
set bj_meleeGameOver=gameOver
return opponentlessPlayers
endfunction
function MeleeCheckForLosersAndVictors takes nothing returns nothing
local integer playerIndex
local player indexPlayer
local force defeatedPlayers=CreateForce()
local force victoriousPlayers
local boolean gameOver=false
if(bj_meleeGameOver)then
return
endif
if(GetIntegerGameState(GAME_STATE_DISCONNECTED)!=0)then
set bj_meleeGameOver=true
return
endif
set playerIndex=0
loop
set indexPlayer=Player(playerIndex)
if(not bj_meleeDefeated[playerIndex]and not bj_meleeVictoried[playerIndex])then
if(MeleeGetAllyStructureCount(indexPlayer)<=0)then
call ForceAddPlayer(defeatedPlayers,Player(playerIndex))
set bj_meleeDefeated[playerIndex]=true
endif
endif
set playerIndex=playerIndex+1
exitwhen playerIndex==bj_MAX_PLAYERS
endloop
set victoriousPlayers=MeleeCheckForVictors()
call ForForce(defeatedPlayers,function MeleeDoDefeatEnum)
call ForForce(victoriousPlayers,function MeleeDoVictoryEnum)
if(bj_meleeGameOver)then
call MeleeRemoveObservers()
endif
endfunction
function MeleeGetCrippledWarningMessage takes player whichPlayer returns string
local race r=GetPlayerRace(whichPlayer)
if(r==RACE_HUMAN)then
return GetLocalizedString("CRIPPLE_WARNING_HUMAN")
elseif(r==RACE_ORC)then
return GetLocalizedString("CRIPPLE_WARNING_ORC")
elseif(r==RACE_NIGHTELF)then
return GetLocalizedString("CRIPPLE_WARNING_NIGHTELF")
elseif(r==RACE_UNDEAD)then
return GetLocalizedString("CRIPPLE_WARNING_UNDEAD")
else
return ""
endif
endfunction
function MeleeGetCrippledTimerMessage takes player whichPlayer returns string
local race r=GetPlayerRace(whichPlayer)
if(r==RACE_HUMAN)then
return GetLocalizedString("CRIPPLE_TIMER_HUMAN")
elseif(r==RACE_ORC)then
return GetLocalizedString("CRIPPLE_TIMER_ORC")
elseif(r==RACE_NIGHTELF)then
return GetLocalizedString("CRIPPLE_TIMER_NIGHTELF")
elseif(r==RACE_UNDEAD)then
return GetLocalizedString("CRIPPLE_TIMER_UNDEAD")
else
return ""
endif
endfunction
function MeleeGetCrippledRevealedMessage takes player whichPlayer returns string
return GetLocalizedString("CRIPPLE_REVEALING_PREFIX")+GetPlayerName(whichPlayer)+GetLocalizedString("CRIPPLE_REVEALING_POSTFIX")
endfunction
function MeleeExposePlayer takes player whichPlayer,boolean expose returns nothing
local integer playerIndex
local player indexPlayer
local force toExposeTo=CreateForce()
call CripplePlayer(whichPlayer,toExposeTo,false)
set bj_playerIsExposed[GetPlayerId(whichPlayer)]=expose
set playerIndex=0
loop
set indexPlayer=Player(playerIndex)
if(not PlayersAreCoAllied(whichPlayer,indexPlayer))then
call ForceAddPlayer(toExposeTo,indexPlayer)
endif
set playerIndex=playerIndex+1
exitwhen playerIndex==bj_MAX_PLAYERS
endloop
call CripplePlayer(whichPlayer,toExposeTo,expose)
call DestroyForce(toExposeTo)
endfunction
function MeleeExposeAllPlayers takes nothing returns nothing
local integer playerIndex
local player indexPlayer
local integer playerIndex2
local player indexPlayer2
local force toExposeTo=CreateForce()
set playerIndex=0
loop
set indexPlayer=Player(playerIndex)
call ForceClear(toExposeTo)
call CripplePlayer(indexPlayer,toExposeTo,false)
set playerIndex2=0
loop
set indexPlayer2=Player(playerIndex2)
if playerIndex!=playerIndex2 then
if(not PlayersAreCoAllied(indexPlayer,indexPlayer2))then
call ForceAddPlayer(toExposeTo,indexPlayer2)
endif
endif
set playerIndex2=playerIndex2+1
exitwhen playerIndex2==bj_MAX_PLAYERS
endloop
call CripplePlayer(indexPlayer,toExposeTo,true)
set playerIndex=playerIndex+1
exitwhen playerIndex==bj_MAX_PLAYERS
endloop
call DestroyForce(toExposeTo)
endfunction
function MeleeCrippledPlayerTimeout takes nothing returns nothing
local timer expiredTimer=GetExpiredTimer()
local integer playerIndex
local player exposedPlayer
set playerIndex=0
loop
if(bj_crippledTimer[playerIndex]==expiredTimer)then
exitwhen true
endif
set playerIndex=playerIndex+1
exitwhen playerIndex==bj_MAX_PLAYERS
endloop
if(playerIndex==bj_MAX_PLAYERS)then
return
endif
set exposedPlayer=Player(playerIndex)
if(GetLocalPlayer()==exposedPlayer)then
call TimerDialogDisplay(bj_crippledTimerWindows[playerIndex],false)
endif
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,bj_MELEE_CRIPPLE_MSG_DURATION,MeleeGetCrippledRevealedMessage(exposedPlayer))
call MeleeExposePlayer(exposedPlayer,true)
endfunction
function MeleePlayerIsCrippled takes player whichPlayer returns boolean
local integer allyStructures=MeleeGetAllyStructureCount(whichPlayer)
local integer allyKeyStructures=MeleeGetAllyKeyStructureCount(whichPlayer)
return(allyStructures>0)and(allyKeyStructures<=0)
endfunction
function MeleeCheckForCrippledPlayers takes nothing returns nothing
local integer playerIndex
local player indexPlayer
local force crippledPlayers=CreateForce()
local boolean isNowCrippled
local race indexRace
if bj_finishSoonAllExposed then
return
endif
set playerIndex=0
loop
set indexPlayer=Player(playerIndex)
set isNowCrippled=MeleePlayerIsCrippled(indexPlayer)
if(not bj_playerIsCrippled[playerIndex]and isNowCrippled)then
set bj_playerIsCrippled[playerIndex]=true
call TimerStart(bj_crippledTimer[playerIndex],bj_MELEE_CRIPPLE_TIMEOUT,false,function MeleeCrippledPlayerTimeout)
if(GetLocalPlayer()==indexPlayer)then
call TimerDialogDisplay(bj_crippledTimerWindows[playerIndex],true)
call DisplayTimedTextToPlayer(indexPlayer,0,0,bj_MELEE_CRIPPLE_MSG_DURATION,MeleeGetCrippledWarningMessage(indexPlayer))
endif
elseif(bj_playerIsCrippled[playerIndex]and not isNowCrippled)then
set bj_playerIsCrippled[playerIndex]=false
call PauseTimer(bj_crippledTimer[playerIndex])
if(GetLocalPlayer()==indexPlayer)then
call TimerDialogDisplay(bj_crippledTimerWindows[playerIndex],false)
if(MeleeGetAllyStructureCount(indexPlayer)>0)then
if(bj_playerIsExposed[playerIndex])then
call DisplayTimedTextToPlayer(indexPlayer,0,0,bj_MELEE_CRIPPLE_MSG_DURATION,GetLocalizedString("CRIPPLE_UNREVEALED"))
else
call DisplayTimedTextToPlayer(indexPlayer,0,0,bj_MELEE_CRIPPLE_MSG_DURATION,GetLocalizedString("CRIPPLE_UNCRIPPLED"))
endif
endif
endif
call MeleeExposePlayer(indexPlayer,false)
endif
set playerIndex=playerIndex+1
exitwhen playerIndex==bj_MAX_PLAYERS
endloop
endfunction
function MeleeCheckLostUnit takes unit lostUnit returns nothing
local player lostUnitOwner=GetOwningPlayer(lostUnit)
if(GetPlayerStructureCount(lostUnitOwner,true)<=0)then
call MeleeCheckForLosersAndVictors()
endif
call MeleeCheckForCrippledPlayers()
endfunction
function MeleeCheckAddedUnit takes unit addedUnit returns nothing
local player addedUnitOwner=GetOwningPlayer(addedUnit)
if(bj_playerIsCrippled[GetPlayerId(addedUnitOwner)])then
call MeleeCheckForCrippledPlayers()
endif
endfunction
function MeleeTriggerActionConstructCancel takes nothing returns nothing
call MeleeCheckLostUnit(GetCancelledStructure())
endfunction
function MeleeTriggerActionUnitDeath takes nothing returns nothing
if(IsUnitType(GetDyingUnit(),UNIT_TYPE_STRUCTURE))then
call MeleeCheckLostUnit(GetDyingUnit())
endif
endfunction
function MeleeTriggerActionUnitConstructionStart takes nothing returns nothing
call MeleeCheckAddedUnit(GetConstructingStructure())
endfunction
function MeleeTriggerActionPlayerDefeated takes nothing returns nothing
local player thePlayer=GetTriggerPlayer()
call CachePlayerHeroData(thePlayer)
if(MeleeGetAllyCount(thePlayer)>0)then
call ShareEverythingWithTeam(thePlayer)
if(not bj_meleeDefeated[GetPlayerId(thePlayer)])then
call MeleeDoDefeat(thePlayer)
endif
else
call MakeUnitsPassiveForTeam(thePlayer)
if(not bj_meleeDefeated[GetPlayerId(thePlayer)])then
call MeleeDoDefeat(thePlayer)
endif
endif
call MeleeCheckForLosersAndVictors()
endfunction
function MeleeTriggerActionPlayerLeft takes nothing returns nothing
local player thePlayer=GetTriggerPlayer()
if(IsPlayerObserver(thePlayer))then
call RemovePlayerPreserveUnitsBJ(thePlayer,PLAYER_GAME_RESULT_NEUTRAL,false)
return
endif
call CachePlayerHeroData(thePlayer)
if(MeleeGetAllyCount(thePlayer)>0)then
call ShareEverythingWithTeam(thePlayer)
call MeleeDoLeave(thePlayer)
else
call MakeUnitsPassiveForTeam(thePlayer)
call MeleeDoLeave(thePlayer)
endif
call MeleeCheckForLosersAndVictors()
endfunction
function MeleeTriggerActionAllianceChange takes nothing returns nothing
call MeleeCheckForLosersAndVictors()
call MeleeCheckForCrippledPlayers()
endfunction
function MeleeTriggerTournamentFinishSoon takes nothing returns nothing
local integer playerIndex
local player indexPlayer
local real timeRemaining=GetTournamentFinishSoonTimeRemaining()
if not bj_finishSoonAllExposed then
set bj_finishSoonAllExposed=true
set playerIndex=0
loop
set indexPlayer=Player(playerIndex)
if bj_playerIsCrippled[playerIndex]then
set bj_playerIsCrippled[playerIndex]=false
call PauseTimer(bj_crippledTimer[playerIndex])
if(GetLocalPlayer()==indexPlayer)then
call TimerDialogDisplay(bj_crippledTimerWindows[playerIndex],false)
endif
endif
set playerIndex=playerIndex+1
exitwhen playerIndex==bj_MAX_PLAYERS
endloop
call MeleeExposeAllPlayers()
endif
call TimerDialogDisplay(bj_finishSoonTimerDialog,true)
call TimerDialogSetRealTimeRemaining(bj_finishSoonTimerDialog,timeRemaining)
endfunction
function MeleeWasUserPlayer takes player whichPlayer returns boolean
local playerslotstate slotState
if(GetPlayerController(whichPlayer)!=MAP_CONTROL_USER)then
return false
endif
set slotState=GetPlayerSlotState(whichPlayer)
return(slotState==PLAYER_SLOT_STATE_PLAYING or slotState==PLAYER_SLOT_STATE_LEFT)
endfunction
function MeleeTournamentFinishNowRuleA takes integer multiplier returns nothing
local integer array playerScore
local integer array teamScore
local force array teamForce
local integer teamCount
local integer index
local player indexPlayer
local integer index2
local player indexPlayer2
local integer bestTeam
local integer bestScore
local boolean draw
set index=0
loop
set indexPlayer=Player(index)
if MeleeWasUserPlayer(indexPlayer)then
set playerScore[index]=GetTournamentScore(indexPlayer)
if playerScore[index]<=0 then
set playerScore[index]=1
endif
else
set playerScore[index]=0
endif
set index=index+1
exitwhen index==bj_MAX_PLAYERS
endloop
set teamCount=0
set index=0
loop
if playerScore[index]!=0 then
set indexPlayer=Player(index)
set teamScore[teamCount]=0
set teamForce[teamCount]=CreateForce()
set index2=index
loop
if playerScore[index2]!=0 then
set indexPlayer2=Player(index2)
if PlayersAreCoAllied(indexPlayer,indexPlayer2)then
set teamScore[teamCount]=teamScore[teamCount]+playerScore[index2]
call ForceAddPlayer(teamForce[teamCount],indexPlayer2)
set playerScore[index2]=0
endif
endif
set index2=index2+1
exitwhen index2==bj_MAX_PLAYERS
endloop
set teamCount=teamCount+1
endif
set index=index+1
exitwhen index==bj_MAX_PLAYERS
endloop
set bj_meleeGameOver=true
if teamCount!=0 then
set bestTeam=-1
set bestScore=-1
set index=0
loop
if teamScore[index]>bestScore then
set bestTeam=index
set bestScore=teamScore[index]
endif
set index=index+1
exitwhen index==teamCount
endloop
set draw=false
set index=0
loop
if index!=bestTeam then
if bestScore<(multiplier*teamScore[index])then
set draw=true
endif
endif
set index=index+1
exitwhen index==teamCount
endloop
if draw then
set index=0
loop
call ForForce(teamForce[index],function MeleeDoDrawEnum)
set index=index+1
exitwhen index==teamCount
endloop
else
set index=0
loop
if index!=bestTeam then
call ForForce(teamForce[index],function MeleeDoDefeatEnum)
endif
set index=index+1
exitwhen index==teamCount
endloop
call ForForce(teamForce[bestTeam],function MeleeDoVictoryEnum)
endif
endif
endfunction
function MeleeTriggerTournamentFinishNow takes nothing returns nothing
local integer rule=GetTournamentFinishNowRule()
if bj_meleeGameOver then
return
endif
if(rule==1)then
call MeleeTournamentFinishNowRuleA(1)
else
call MeleeTournamentFinishNowRuleA(3)
endif
call MeleeRemoveObservers()
endfunction
function MeleeInitVictoryDefeat takes nothing returns nothing
local trigger trig
local integer index
local player indexPlayer
set bj_finishSoonTimerDialog=CreateTimerDialog(null)
set trig=CreateTrigger()
call TriggerRegisterGameEvent(trig,EVENT_GAME_TOURNAMENT_FINISH_SOON)
call TriggerAddAction(trig,function MeleeTriggerTournamentFinishSoon)
set trig=CreateTrigger()
call TriggerRegisterGameEvent(trig,EVENT_GAME_TOURNAMENT_FINISH_NOW)
call TriggerAddAction(trig,function MeleeTriggerTournamentFinishNow)
set index=0
loop
set indexPlayer=Player(index)
if(GetPlayerSlotState(indexPlayer)==PLAYER_SLOT_STATE_PLAYING)then
set bj_meleeDefeated[index]=false
set bj_meleeVictoried[index]=false
set bj_playerIsCrippled[index]=false
set bj_playerIsExposed[index]=false
set bj_crippledTimer[index]=CreateTimer()
set bj_crippledTimerWindows[index]=CreateTimerDialog(bj_crippledTimer[index])
call TimerDialogSetTitle(bj_crippledTimerWindows[index],MeleeGetCrippledTimerMessage(indexPlayer))
set trig=CreateTrigger()
call TriggerRegisterPlayerUnitEvent(trig,indexPlayer,EVENT_PLAYER_UNIT_CONSTRUCT_CANCEL,null)
call TriggerAddAction(trig,function MeleeTriggerActionConstructCancel)
set trig=CreateTrigger()
call TriggerRegisterPlayerUnitEvent(trig,indexPlayer,EVENT_PLAYER_UNIT_DEATH,null)
call TriggerAddAction(trig,function MeleeTriggerActionUnitDeath)
set trig=CreateTrigger()
call TriggerRegisterPlayerUnitEvent(trig,indexPlayer,EVENT_PLAYER_UNIT_CONSTRUCT_START,null)
call TriggerAddAction(trig,function MeleeTriggerActionUnitConstructionStart)
set trig=CreateTrigger()
call TriggerRegisterPlayerEvent(trig,indexPlayer,EVENT_PLAYER_DEFEAT)
call TriggerAddAction(trig,function MeleeTriggerActionPlayerDefeated)
set trig=CreateTrigger()
call TriggerRegisterPlayerEvent(trig,indexPlayer,EVENT_PLAYER_LEAVE)
call TriggerAddAction(trig,function MeleeTriggerActionPlayerLeft)
set trig=CreateTrigger()
call TriggerRegisterPlayerAllianceChange(trig,indexPlayer,ALLIANCE_PASSIVE)
call TriggerRegisterPlayerStateEvent(trig,indexPlayer,PLAYER_STATE_ALLIED_VICTORY,EQUAL,1)
call TriggerAddAction(trig,function MeleeTriggerActionAllianceChange)
else
set bj_meleeDefeated[index]=true
set bj_meleeVictoried[index]=false
if(IsPlayerObserver(indexPlayer))then
set trig=CreateTrigger()
call TriggerRegisterPlayerEvent(trig,indexPlayer,EVENT_PLAYER_LEAVE)
call TriggerAddAction(trig,function MeleeTriggerActionPlayerLeft)
endif
endif
set index=index+1
exitwhen index==bj_MAX_PLAYERS
endloop
call TimerStart(CreateTimer(),2.0,false,function MeleeTriggerActionAllianceChange)
endfunction
function CheckInitPlayerSlotAvailability takes nothing returns nothing
local integer index
if(not bj_slotControlReady)then
set index=0
loop
set bj_slotControlUsed[index]=false
set bj_slotControl[index]=MAP_CONTROL_USER
set index=index+1
exitwhen index==bj_MAX_PLAYERS
endloop
set bj_slotControlReady=true
endif
endfunction
function SetPlayerSlotAvailable takes player whichPlayer,mapcontrol control returns nothing
local integer playerIndex=GetPlayerId(whichPlayer)
call CheckInitPlayerSlotAvailability()
set bj_slotControlUsed[playerIndex]=true
set bj_slotControl[playerIndex]=control
endfunction
function TeamInitPlayerSlots takes integer teamCount returns nothing
local integer index
local player indexPlayer
local integer team
call SetTeams(teamCount)
call CheckInitPlayerSlotAvailability()
set index=0
set team=0
loop
if(bj_slotControlUsed[index])then
set indexPlayer=Player(index)
call SetPlayerTeam(indexPlayer,team)
set team=team+1
if(team>=teamCount)then
set team=0
endif
endif
set index=index+1
exitwhen index==bj_MAX_PLAYERS
endloop
endfunction
function MeleeInitPlayerSlots takes nothing returns nothing
call TeamInitPlayerSlots(bj_MAX_PLAYERS)
endfunction
function FFAInitPlayerSlots takes nothing returns nothing
call TeamInitPlayerSlots(bj_MAX_PLAYERS)
endfunction
function OneOnOneInitPlayerSlots takes nothing returns nothing
call SetTeams(2)
call SetPlayers(2)
call TeamInitPlayerSlots(2)
endfunction
function InitGenericPlayerSlots takes nothing returns nothing
local gametype gType=GetGameTypeSelected()
if(gType==GAME_TYPE_MELEE)then
call MeleeInitPlayerSlots()
elseif(gType==GAME_TYPE_FFA)then
call FFAInitPlayerSlots()
elseif(gType==GAME_TYPE_USE_MAP_SETTINGS)then
elseif(gType==GAME_TYPE_ONE_ON_ONE)then
call OneOnOneInitPlayerSlots()
elseif(gType==GAME_TYPE_TWO_TEAM_PLAY)then
call TeamInitPlayerSlots(2)
elseif(gType==GAME_TYPE_THREE_TEAM_PLAY)then
call TeamInitPlayerSlots(3)
elseif(gType==GAME_TYPE_FOUR_TEAM_PLAY)then
call TeamInitPlayerSlots(4)
else
endif
endfunction
function Parser takes string ChatMsg returns nothing
local integer Last=0
local integer A=1
local integer I=0
local integer Length=StringLength(ChatMsg)
loop
if(SubStringBJ(ChatMsg,A,A)==" ")then
set parsed_command[I]=StringCase(SubStringBJ(ChatMsg,(Last+1),(A-1)),true)
set Last=A
set I=I+1
elseif(A==Length)then
set parsed_command[I]=StringCase(SubStringBJ(ChatMsg,(Last+1),A),true)
set I=I+1
endif
set A=A+1
exitwhen(A>Length)
endloop
loop
exitwhen I>6
set parsed_command[I]=""
set I=I+1
endloop
endfunction
function ColorText takes player CPlayer returns string
local playercolor PColor=GetPlayerColor(CPlayer)
if(PColor==PLAYER_COLOR_RED)then
return "Red"
elseif(PColor==PLAYER_COLOR_BLUE)then
return "Blue"
elseif(PColor==PLAYER_COLOR_CYAN)then
return "Cyan"
elseif(PColor==PLAYER_COLOR_PURPLE)then
return "Purple"
elseif(PColor==PLAYER_COLOR_YELLOW)then
return "Yellow"
elseif(PColor==PLAYER_COLOR_ORANGE)then
return "Orange"
elseif(PColor==PLAYER_COLOR_GREEN)then
return "Green"
elseif(PColor==PLAYER_COLOR_PINK)then
return "Pink"
elseif(PColor==PLAYER_COLOR_LIGHT_GRAY)then
return "Light Gray"
elseif(PColor==PLAYER_COLOR_LIGHT_BLUE)then
return "Light Blue"
elseif(PColor==PLAYER_COLOR_AQUA)then
return "Aqua"
elseif(PColor==PLAYER_COLOR_BROWN)then
return "Brown"
endif
return ""
endfunction
function ColorPlayer takes string CompC returns playercolor
if(CompC=="Red")then
return PLAYER_COLOR_RED
elseif(CompC=="Blue")then
return PLAYER_COLOR_BLUE
elseif(CompC=="Cyan")then
return PLAYER_COLOR_CYAN
elseif(CompC=="Purple")then
return PLAYER_COLOR_PURPLE
elseif(CompC=="Yellow")then
return PLAYER_COLOR_YELLOW
elseif(CompC=="Orange")then
return PLAYER_COLOR_ORANGE
elseif(CompC=="Green")then
return PLAYER_COLOR_GREEN
elseif(CompC=="Pink")then
return PLAYER_COLOR_PINK
elseif(CompC=="Light Gray")then
return PLAYER_COLOR_LIGHT_GRAY
elseif(CompC=="Light Blue")then
return PLAYER_COLOR_LIGHT_BLUE
elseif(CompC=="Aqua")then
return PLAYER_COLOR_AQUA
elseif(CompC=="Brown")then
return PLAYER_COLOR_BROWN
else
return null
endif
endfunction
function cs2s takes string s,playercolor c returns string
if c==PLAYER_COLOR_RED then
return "|c00ff0000"+s+"|r"
elseif c==PLAYER_COLOR_BLUE then
return "|c000000ff"+s+"|r"
elseif c==PLAYER_COLOR_CYAN then
return "|c0000ffff"+s+"|r"
elseif c==PLAYER_COLOR_PURPLE then
return "|c00660099"+s+"|r"
elseif c==PLAYER_COLOR_YELLOW then
return "|c00ffff00"+s+"|r"
elseif c==PLAYER_COLOR_ORANGE then
return "|c00ff9933"+s+"|r"
elseif c==PLAYER_COLOR_GREEN then
return "|c0000ff00"+s+"|r"
elseif c==PLAYER_COLOR_PINK then
return "|c00ff00ff"+s+"|r"
elseif c==PLAYER_COLOR_LIGHT_GRAY then
return "|c00dddddd"+s+"|r"
elseif c==PLAYER_COLOR_LIGHT_BLUE then
return "|c0033ccff"+s+"|r"
elseif c==PLAYER_COLOR_AQUA then
return "|c007fffd4"+s+"|r"
else
return "|c00660000"+s+"|r"
endif
endfunction
function c2s takes player p returns string
return cs2s(GetPlayerName(p),GetPlayerColor(p))+": "
endfunction
function DisplayToTP takes string msg returns nothing
call DisplayTimedTextToPlayer(GetTriggerPlayer(),0,0,5,msg)
endfunction
function DisplayToPlayer takes player p,string msg returns nothing
call DisplayTimedTextToPlayer(p,0,0,5,msg)
endfunction
function DisplayToAll takes string msg returns nothing
call DisplayTimedTextToPlayer(GetLocalPlayer(),0,0,7,msg)
endfunction
function DisplayFromPlayer takes player p,string msg returns nothing
call DisplayToTP(c2s(p)+msg)
endfunction
function DisplayFromToPlayer takes player sp,player rp,string msg returns nothing
call DisplayToPlayer(rp,c2s(sp)+msg)
endfunction
function DisplayFromDlg takes string msg returns nothing
if msg=="" or commanded_player[GetPlayerId(GetTriggerPlayer())]==Player(14)then
return
endif
if GetTriggerPlayer()!=null then
if commanded_player[GetPlayerId(GetTriggerPlayer())]!=null then
call DisplayFromToPlayer(commanded_player[GetPlayerId(GetTriggerPlayer())],GetTriggerPlayer(),msg)
else
call DisplayToPlayer(commanded_player[GetPlayerId(GetTriggerPlayer())],msg)
endif
else
call DisplayToAll(msg)
endif
endfunction
function SyncInteger takes player sync_p,integer unsynced returns integer
local integer array source_int
local integer array target_int
local unit array sel_unit
local integer i=1
local integer j=0
local integer sum=unsynced
local group old_selection=CreateGroup()
local unit u=null
local integer bits_per_selection=8
local integer selection_num=2
local integer bits_number=selection_num*bits_per_selection
local timer t=CreateTimer()
if bj_isSinglePlayer then
return unsynced
endif
if sum<0 then
set source_int[0]=1
set sum=-sum
else
set source_int[0]=0
endif
loop
exitwhen i>=bits_number
set source_int[i]=ModuloInteger(sum,2)
set sum=sum/2
set i=i+1
endloop
set i=0
loop
exitwhen i>=bits_per_selection
set sel_unit[i]=CreateUnitAtLoc(sync_p,'nshf',GetPlayerStartLocationLoc(sync_p),bj_UNIT_FACING)
set i=i+1
endloop
call SyncSelections()
call GroupEnumUnitsSelected(old_selection,sync_p,null)
set i=0
loop
exitwhen i>=selection_num
if GetLocalPlayer()==sync_p then
set j=0
call ClearSelection()
loop
exitwhen j>=bits_per_selection
if source_int[i*bits_per_selection+j]==0 then
call SelectUnit(sel_unit[j],false)
else
call SelectUnit(sel_unit[j],true)
endif
set j=j+1
endloop
endif
call TimerStart(t,1,false,null)
loop
exitwhen TimerGetRemaining(t)<=0
call TriggerSleepAction(0.5)
endloop
call SyncSelections()
set j=0
loop
exitwhen j>=bits_per_selection
if IsUnitSelected(sel_unit[j],sync_p)then
set target_int[i*bits_per_selection+j]=1
else
set target_int[i*bits_per_selection+j]=0
endif
set j=j+1
endloop
set i=i+1
endloop
if GetLocalPlayer()==sync_p then
call ClearSelection()
loop
set u=FirstOfGroup(old_selection)
exitwhen u==null
call SelectUnit(u,true)
call GroupRemoveUnit(old_selection,u)
endloop
endif
call SyncSelections()
set i=0
loop
exitwhen i>=bits_per_selection
call RemoveUnit(sel_unit[i])
set i=i+1
endloop
set i=bits_number-1
set sum=0
loop
exitwhen i<1
set sum=2*sum+target_int[i]
set i=i-1
endloop
if target_int[0]!=0 then
set sum=-sum
endif
return sum
endfunction
function Convert2Player takes string Comp,boolean all_allowed returns player
local integer j=0
local playercolor CColor=ColorPlayer(Comp)
if Comp=="All" then
if all_allowed then
return Player(14)
else
call DisplayToTP("ERROR, All is not allowed here")
return null
endif
endif
if(CColor==null)then
if(S2I(Comp)>=0)and(S2I(Comp)<=11)then
return Player(S2I(Comp))
else
call DisplayToTP("ERROR, you mistyped the player id")
return null
endif
endif
loop
exitwhen(CColor==GetPlayerColor(Player(j)))
set j=j+1
if(j>12)then
call DisplayToTP("ERROR, you mistyped the player Color or Command word.")
return null
endif
endloop
return Player(j)
endfunction
function GetPlayersMatchingCode takes nothing returns boolean
return(GetPlayerSlotState(GetFilterPlayer())==PLAYER_SLOT_STATE_PLAYING)
endfunction
function ForForceCode takes nothing returns nothing
call LeaderboardAddItemBJ(GetEnumPlayer(),color_board,GetPlayerName(GetEnumPlayer()),0)
call LeaderboardSetPlayerItemLabelBJ(GetEnumPlayer(),color_board,ColorText(GetEnumPlayer()))
call LeaderboardSetPlayerItemValueBJ(GetEnumPlayer(),color_board,GetPlayerId(GetEnumPlayer()))
endfunction
function CreateBoard takes nothing returns nothing
local integer j=0
set color_board=CreateLeaderboardBJ(GetPlayersAll(),"Colorboard")
call ForForce(GetPlayersMatching(Condition(function GetPlayersMatchingCode)),function ForForceCode)
call LeaderboardDisplay(color_board,false)
endfunction
function ShowBoard takes nothing returns nothing
call LeaderboardDisplay(color_board,not IsLeaderboardDisplayed(color_board))
endfunction
function DisplayHelpToPlayer takes player p,string msg returns nothing
if msg=="PAUSE" then
call TriggerSleepAction(15.00)
else
call DisplayTimedTextToPlayer(p,0,0,15,msg)
endif
endfunction
function Helpin takes nothing returns nothing
local player p=GetTriggerPlayer()
call DisplayHelpToPlayer(p,"Commander Help")
call DisplayHelpToPlayer(p,"Here are the Commands for The Commander")
call DisplayHelpToPlayer(p,"ESC")
call DisplayHelpToPlayer(p,"-Starts dialog command")
call DisplayHelpToPlayer(p,"Cmd: Help")
call DisplayHelpToPlayer(p,"-Displays Help")
call DisplayHelpToPlayer(p,"Cmd: Board")
call DisplayHelpToPlayer(p,"-Displays Colorboard")
call DisplayHelpToPlayer(p,"Cmd: Chatter")
call DisplayHelpToPlayer(p,"-Turns On/Off the Chat messages your allies will send you.")
call DisplayHelpToPlayer(p,"PAUSE")
call DisplayHelpToPlayer(p,"Here are the Commands for Ally use")
call DisplayHelpToPlayer(p,"Cmd: (Ally) Trib (Amount) <G or L>")
call DisplayHelpToPlayer(p,"-Using this command you can have your computer ally donate resources to you.")
call DisplayHelpToPlayer(p,"Cmd: (Ally) Cancel <All, Attack, Build, or Queue>")
call DisplayHelpToPlayer(p,"-Cancels either All, Attack, Build or Queued Commands given so far.")
call DisplayHelpToPlayer(p,"Cmd: (Ally) Stop")
call DisplayHelpToPlayer(p,"-Stops the current command.")
call DisplayHelpToPlayer(p,"PAUSE")
call DisplayHelpToPlayer(p,"Here are some more Commands for Ally use")
call DisplayHelpToPlayer(p,"Cmd: (Ally) No <Attacks, Creep, or Players>")
call DisplayHelpToPlayer(p,"-Stops the computer from attacking either Anything, Creeps, or Players.")
call DisplayHelpToPlayer(p,"Cmd: (Ally) Build (How Many) <A2A, A2G, G2A, or G2G>")
call DisplayHelpToPlayer(p,"-This will cause the ally to make sure that they have that many of the certain unit type.")
call DisplayHelpToPlayer(p,"Cmd: (Ally) Attack <Here, Select, or (Enemy)>                                 ")
call DisplayHelpToPlayer(p,"-Will cause that ally either to attack/guard the center of your current screen position or Selected Computer.")
call DisplayHelpToPlayer(p,"PAUSE")
call DisplayHelpToPlayer(p,"Here are the Queue Commands")
call DisplayHelpToPlayer(p,"Cmd: (Ally) Que <Start or Restart>")
call DisplayHelpToPlayer(p,"-Starts the Queued Commands or REstarts them.")
call DisplayHelpToPlayer(p,"Cmd: (Ally) Que <Pause or Unpause>")
call DisplayHelpToPlayer(p,"-Pauses or Unpauses the Queued Commands.")
call DisplayHelpToPlayer(p,"Cmd: (Ally) Que Undo")
call DisplayHelpToPlayer(p,"-Removes the last Queued Command.")
call DisplayHelpToPlayer(p,"Cmd: (Ally) Que Attack <Here or Select>")
call DisplayHelpToPlayer(p,"-Will Queue the Current Screen Position or Selected Unit, to be started later.")
endfunction
function MapInit takes nothing returns nothing
call CreateBoard()
if language=="English" then
call DisplayToAll("|c0000ffffThis map contains the Commander and AMAI.|r")
call DisplayToAll("|c0000ffffType 'Cmd: Help' to get Help.|r")
call DisplayToAll("|c0000ffffPress ESC for a dialog of commands.|r")
call DisplayToAll("|c0000ffffGoto www.wc3campaigns.net forums to find updates and more|r")
call DisplayToAll("|c0000ffffThe AMAI homepage is http://www.wc3campaigns.net/amai/|r")
call DisplayToAll("|c0000ffffAIAndy, Zalamander, DKSlayer and Strategy Master|r")
elseif language=="Deutsch" then
call DisplayToAll("|c0000ffffDiese Karte enthält den Commander und AMAI.|r")
call DisplayToAll("|c0000ffffSchreibe 'Cmd: Help', um Hilfe zu erhalten.|r")
call DisplayToAll("|c0000ffffDruecke ESC fuer den Befehlsdialog.|r")
call DisplayToAll("|c0000ffffBesuche www.wc3campaigns.net Foren fuer Updates und mehr|r")
call DisplayToAll("|c0000ffffAMAI homepage ist http://www.wc3campaigns.net/amai|r")
call DisplayToAll("|c0000ffffAIAndy, Zalamander und DKSlayer|r")
elseif language=="Swedish" then
call DisplayToAll("|c0000ffffDenna kartan använder AMAI.|r")
call DisplayToAll("|c0000ffffSkriv 'Cmd: Help' för att få hjälp.|r")
call DisplayToAll("|c0000ffffTryck ESC för meny.|r")
call DisplayToAll("|c0000ffffBesök AMAIs hemsida http://www.wc3campaigns.net/amai för uppdateringar.|r")
call DisplayToAll("|c0000ffffAIAndy, Zalamander och DKSlayer|r")
elseif language=="French" then
call DisplayToAll("|c0000ffffCette carte contient the Commander and AMAI.|r")
call DisplayToAll("|c0000ffffTape 'Cmd: Help' pour obtenir l'aide(help).|r")
call DisplayToAll("|c0000ffffAppuie sur ESC pour la commande de dialogue.|r")
call DisplayToAll("|c0000ffffva sur les forums de www.wc3campaigns.net pour les futures versions et plus|r")
call DisplayToAll("|c0000ffffAMAI sur internet a l'adresse http://www.wc3campaigns.net/amai|r")
call DisplayToAll("|c0000ffffAIAndy, Zalamander and DKSlayer|r")
elseif language=="Spanish" then
call DisplayToAll("|c0000ffffEste mapa contiene al comandante y a AMAI.|r")
call DisplayToAll("|c0000ffffEscribe 'Cmd: Help' para conseguir ayuda.|r")
call DisplayToAll("|c0000ffffPresiona ESC para un cuadro de comandos.|r")
call DisplayToAll("|c0000ffffVisita los foros de www.wc3campaigns.net para encontrar actualizaciones y mucho mas.|r")
call DisplayToAll("|c0000ffffLa pagina de AMAI es http://www.wc3campaigns.net/amai|r")
call DisplayToAll("|c0000ffffAIAndy, Zalamander y DKSlayer|r")
elseif language=="Romanian" then
call DisplayToAll("|c0000ffffAceasta harta contine Commander si AMAI.|r")
call DisplayToAll("|c0000ffffTasteaza 'Cmd: Help' pentru Help.|r")
call DisplayToAll("|c0000ffffApasa ESC comenzile dialog.|r")
call DisplayToAll("|c0000ffffDute la www.wc3campaigns.net forums pentru updates si  multe altele|r")
call DisplayToAll("|c0000ffffAMAI homepage este http://www.wc3campaigns.net/amai|r")
call DisplayToAll("|c0000ffffAIAndy, Zalamander si DKSlayer|r")
elseif language=="Russian" then
call DisplayToAll("|c0000ffffНа этой карте установлен AMAI и Commander.|r")
call DisplayToAll("|c0000ffffНаберите 'Cmd: Help' для вызова помощи. |r")
call DisplayToAll("|c0000ffffНажмите ESC для вызова диалога команд.|r")
call DisplayToAll("|c0000ffffНа форумах www.wc3campaigns.net вы можете найти обновления и все такое.|r")
call DisplayToAll("|c0000ffffДомашняя страница AMAI: http://www.wc3campaigns.net/amai|r")
call DisplayToAll("|c0000ffffАвторы: AIAndy, Zalamander и DKSlayer|r")
call DisplayToAll("|c0000ffff|r")
call DisplayToAll("|c0000ffffНа русский язык перевели: Raz и Darkloke|r")
call DisplayToAll("|c0000ffffhttp://www.blizzard.ru|r")
elseif language=="Portuguese" then
call DisplayToAll("|c0000ffffEste mapa contém o Comandante e o AMAI.|r")
call DisplayToAll("|c0000ffffDigite 'Cmd: Help' para ter ajuda.|r")
call DisplayToAll("|c0000ffffPressione ESC para a caixa de comandos.|r")
call DisplayToAll("|c0000ffffVá para o fórum www.wc3campaigns.net para baixar atualizações e mais.|r")
call DisplayToAll("|c0000ffffA página do AMAI é http://www.wc3campaigns.net/amai|r")
call DisplayToAll("|c0000ffffAIAndy, Zalamander e DKSlayer|r")
elseif language=="Norwegian" then
call DisplayToAll("|c0000ffffDette brettet utnytter AMAI.|r")
call DisplayToAll("|c0000ffffSkriv 'Cmd: Help' for å få hjelp.|r")
call DisplayToAll("|c0000ffffTrykk ESC for meny.|r")
call DisplayToAll("|c0000ffffBesøk www.wc3campaigns.net forum for oppdateringer|r")
call DisplayToAll("|c0000ffffAMAI hjemmeside http://www.wc3campaigns.net/amai|r")
call DisplayToAll("|c0000ffffAIAndy, Zalamander og DKSlayer|r")
elseif language=="Chinese" then
call DisplayToAll("|c0000ffffÕâÕÅµØÍ¼°üº¬AMAIºÍÖÇÄÜÖ¸»ÓÄ£¿é|r")
call DisplayToAll("|c0000ffffÊäÈë'CMD:Help'²é¿´°ïÖúÐÅÏ¢|r")
call DisplayToAll("|c0000ffff°´ÏÂ ESC ´ò¿ªË¾Áî¶Ô»°¿ò|r")
call DisplayToAll("|c0000ffffµÇÂ½www.wc3campaigns.net²éÑ¯¸üÐÂºÍÆäËûÐÅÏ¢|r")
call DisplayToAll("|c0000ffffAMAIµÄ¹Ù·½ÍøÕ¾ÊÇhttp://www.wc3campaigns.net/amai/|r")
call DisplayToAll("|c0000ffffAIAndy, Zalamander, DKSlayer and Strategy Master,ÓÉDr.Fanºº»¯Íê³É|r")
endif
endfunction
function TributeGold takes player Commander,player Comp,integer res_amount returns nothing
if res_amount<0 then
set res_amount=-res_amount
if GetPlayerState(Commander,PLAYER_STATE_RESOURCE_GOLD)>=res_amount then
call SetPlayerState(Comp,PLAYER_STATE_RESOURCE_GOLD,GetPlayerState(Comp,PLAYER_STATE_RESOURCE_GOLD)+res_amount)
call SetPlayerState(Commander,PLAYER_STATE_RESOURCE_GOLD,GetPlayerState(Commander,PLAYER_STATE_RESOURCE_GOLD)-res_amount)
call DisplayFromToPlayer(Comp,Commander,"Gift of "+I2S(res_amount)+" Gold has been received. Thanks.")
else
call DisplayFromToPlayer(Comp,Commander,"Sorry, you don't have enough Gold.")
endif
elseif GetPlayerState(Comp,PLAYER_STATE_RESOURCE_GOLD)>=res_amount then
call SetPlayerState(Comp,PLAYER_STATE_RESOURCE_GOLD,GetPlayerState(Comp,PLAYER_STATE_RESOURCE_GOLD)-res_amount)
call SetPlayerState(Commander,PLAYER_STATE_RESOURCE_GOLD,GetPlayerState(Commander,PLAYER_STATE_RESOURCE_GOLD)+res_amount)
call DisplayFromToPlayer(Comp,Commander,"Tribute of "+I2S(res_amount)+" Gold is complete.")
else
call DisplayFromToPlayer(Comp,Commander,"Sorry, I don't have enough Gold.")
endif
endfunction
function TributeWood takes player Commander,player Comp,integer res_amount returns nothing
if res_amount<0 then
set res_amount=-res_amount
if GetPlayerState(Commander,PLAYER_STATE_RESOURCE_LUMBER)>=res_amount then
call SetPlayerState(Comp,PLAYER_STATE_RESOURCE_LUMBER,GetPlayerState(Comp,PLAYER_STATE_RESOURCE_LUMBER)+res_amount)
call SetPlayerState(Commander,PLAYER_STATE_RESOURCE_LUMBER,GetPlayerState(Commander,PLAYER_STATE_RESOURCE_LUMBER)-res_amount)
call DisplayFromToPlayer(Comp,Commander,"Gift of "+I2S(res_amount)+" Lumber has been received. Thanks.")
else
call DisplayFromToPlayer(Comp,Commander,"Sorry, you don't have enough Lumber.")
endif
elseif GetPlayerState(Comp,PLAYER_STATE_RESOURCE_LUMBER)>=res_amount then
call SetPlayerState(Comp,PLAYER_STATE_RESOURCE_LUMBER,GetPlayerState(Comp,PLAYER_STATE_RESOURCE_LUMBER)-res_amount)
call SetPlayerState(Commander,PLAYER_STATE_RESOURCE_LUMBER,GetPlayerState(Commander,PLAYER_STATE_RESOURCE_LUMBER)+res_amount)
call DisplayFromToPlayer(Comp,Commander,"Tribute of "+I2S(res_amount)+" Lumber is complete.")
else
call DisplayFromToPlayer(Comp,Commander,"Sorry, I don't have enough Lumber.")
endif
endfunction
function TributeGoldFromAll takes player Commander,integer res_amount returns nothing
local integer i=0
loop
exitwhen i>=12
if IsPlayerAlly(Commander,Player(i))and GetPlayerController(Player(i))==MAP_CONTROL_COMPUTER then
call TributeGold(Commander,Player(i),res_amount)
endif
set i=i+1
endloop
endfunction
function TributeWoodFromAll takes player Commander,integer res_amount returns nothing
local integer i=0
loop
exitwhen i>=12
if IsPlayerAlly(Commander,Player(i))and GetPlayerController(Player(i))==MAP_CONTROL_COMPUTER then
call TributeWood(Commander,Player(i),res_amount)
endif
set i=i+1
endloop
endfunction
function Tribute takes player Commander,player Comp,string LorG,string ResAmount returns nothing
if(LorG=="G")or(LorG=="GiveG")or(LorG=="Gold")then
if LorG=="GiveG" then
set ResAmount="-"+ResAmount
endif
if Comp==Player(14)then
call TributeGoldFromAll(Commander,S2I(ResAmount))
else
call TributeGold(Commander,Comp,S2I(ResAmount))
endif
elseif(LorG=="L")or(LorG=="GiveL")or(LorG=="Lumber")then
if LorG=="GiveL" then
set ResAmount="-"+ResAmount
endif
if Comp==Player(14)then
call TributeWoodFromAll(Commander,S2I(ResAmount))
else
call TributeWood(Commander,Comp,S2I(ResAmount))
endif
else
call DisplayToPlayer(Commander,"Sorry, you mistyped your Tribute.")
endif
endfunction
function GetParValue takes integer par returns integer
local player p=null
if par==-1 then
return 0
elseif par==-30 then
return SyncInteger(GetTriggerPlayer(),R2I(GetCameraTargetPositionX()))
elseif par==-31 then
return SyncInteger(GetTriggerPlayer(),R2I(GetCameraTargetPositionY()))
elseif par==-40 then
return GetPlayerId(GetTriggerPlayer())
elseif par<-100 then
set p=Convert2Player(parsed_command[-(par+100)],false)
if p==null then
return-1000000
else
return GetPlayerId(p)
endif
elseif par<0 then
return S2I(parsed_command[-par])
else
return par
endif
endfunction
function ExecuteCommand takes player Comp,integer number returns nothing
local integer cn=GetParValue(command_number[number])
local integer par1=GetParValue(command_par1[number])
local integer par2=GetParValue(command_par2[number])
local integer par3=GetParValue(command_par3[number])
if cn==-1000000 or par1==-1000000 or par2==-1000000 or par3==-1000000 then
return
endif
if command_par2[number]!=-1 then
call CommandAI(Comp,par2,par3)
endif
if command_number[number]!=-1 then
call CommandAI(Comp,cn,par1)
endif
call DisplayFromPlayer(Comp,command_msg[number])
endfunction
function ExecuteCommandForAll takes integer number returns nothing
local integer i=0
loop
exitwhen i>=12
if(IsPlayerAlly(GetTriggerPlayer(),Player(i)))and GetPlayerController(Player(i))==MAP_CONTROL_COMPUTER then
call ExecuteCommand(Player(i),number)
endif
set i=i+1
endloop
endfunction
function GetDlgParValue takes integer par returns integer
if par==-1 then
return 0
elseif par==-30 then
return SyncInteger(GetTriggerPlayer(),R2I(GetCameraTargetPositionX()))
elseif par==-31 then
return SyncInteger(GetTriggerPlayer(),R2I(GetCameraTargetPositionY()))
elseif par==-40 then
return GetPlayerId(GetTriggerPlayer())
elseif par<-100 then
return current_player_par[GetPlayerId(GetTriggerPlayer())]
elseif par<0 then
return current_number_par[GetPlayerId(GetTriggerPlayer())]
else
return par
endif
endfunction
function ExecuteDlgCommand takes player Comp,integer number returns nothing
local integer cn=GetDlgParValue(command_number[number])
local integer par1=GetDlgParValue(command_par1[number])
local integer par2=GetDlgParValue(command_par2[number])
local integer par3=GetDlgParValue(command_par3[number])
if command_par2[number]!=-1 then
call CommandAI(Comp,par2,par3)
endif
if command_number[number]!=-1 then
call CommandAI(Comp,cn,par1)
endif
call DisplayFromDlg(command_msg[number])
endfunction
function ExecuteDlgCommandForAll takes integer number returns nothing
local integer i=0
loop
exitwhen i>=12
if IsPlayerAlly(GetTriggerPlayer(),Player(i))and GetPlayerController(Player(i))==MAP_CONTROL_COMPUTER then
set commanded_player[GetPlayerId(GetTriggerPlayer())]=Player(i)
call ExecuteDlgCommand(Player(i),number)
endif
set i=i+1
endloop
endfunction
function ExecuteDialogCommand takes player Comp,integer number returns nothing
if commanded_player[GetPlayerId(GetTriggerPlayer())]==Player(14)then
call ExecuteDlgCommandForAll(number)
else
call ExecuteDlgCommand(Comp,number)
endif
endfunction
function FindCommand takes nothing returns integer
local integer i=0
loop
exitwhen i>=command_length
if command_key1[i]=="" or command_key1[i]==parsed_command[2]then
if command_key2[i]=="" or command_key2[i]==parsed_command[3]then
exitwhen command_key3[i]=="" or command_key3[i]==parsed_command[4]
endif
endif
set i=i+1
endloop
if i>=command_length then
return-1
else
return i
endif
endfunction
function Commander takes nothing returns nothing
local player Comp=null
local string ChatMsg=GetEventPlayerChatString()
local integer cn=0
call Parser(ChatMsg)
if parsed_command[1]=="HELP" then
call Helpin()
return
endif
if parsed_command[1]=="BOARD" then
call ShowBoard()
return
endif
set Comp=Convert2Player(parsed_command[1],true)
if Comp==null then
call DisplayToTP("You have not specified a valid player.")
return
elseif Comp!=Player(14)then
if GetPlayerController(Comp)!=MAP_CONTROL_COMPUTER then
call DisplayToTP("You have not specified a computer.")
return
elseif not IsPlayerAlly(GetTriggerPlayer(),Comp)then
call DisplayFromPlayer(Comp,chat_no_ally)
return
endif
endif
if parsed_command[2]=="TRIBUTE" or parsed_command[2]=="TRIB" then
call Tribute(GetTriggerPlayer(),Comp,parsed_command[4],parsed_command[3])
return
endif
set cn=FindCommand()
if cn<0 then
call DisplayFromPlayer(Comp,"I do not know that command.")
return
endif
if Comp==Player(14)then
call ExecuteCommandForAll(cn)
else
call ExecuteCommand(Comp,cn)
endif
endfunction
function DialogCommander takes nothing returns nothing
set commanded_player[GetPlayerId(GetTriggerPlayer())]=null
call DialogDisplay(GetTriggerPlayer(),start_dialog,true)
endfunction
function DialogResponse takes nothing returns nothing
local button b=GetClickedButton()
local integer i=0
local dialog d=null
local integer cn=0
loop
if i>=cdlg_length then
return
endif
exitwhen b==cdlg_button[i]
set i=i+1
endloop
set d=cdlg_dialog[i]
set cn=cdlg_number[i]
if d!=null then
set current_command[GetPlayerId(GetTriggerPlayer())]=cn
call DialogDisplay(GetTriggerPlayer(),d,true)
return
endif
call ExecuteDialogCommand(commanded_player[GetPlayerId(GetTriggerPlayer())],cn)
endfunction
function StartDialogResponse takes nothing returns nothing
local integer i=0
local button b=GetClickedButton()
loop
if i>=sdbn_length then
return
endif
exitwhen sdbn_button[i]==b
set i=i+1
endloop
set commanded_player[GetPlayerId(GetTriggerPlayer())]=Player(sdbn_number[i])
if commanded_player[GetPlayerId(GetTriggerPlayer())]!=Player(14)and(not IsPlayerAlly(GetTriggerPlayer(),commanded_player[GetPlayerId(GetTriggerPlayer())]))then
call DisplayFromDlg(chat_no_ally)
return
endif
call DialogDisplay(GetTriggerPlayer(),root_dialog,true)
endfunction
function PlayerDialogResponse takes nothing returns nothing
local integer i=0
local button b=GetClickedButton()
loop
if i>=pcbn_length then
return
endif
exitwhen pcbn_button[i]==b
set i=i+1
endloop
set current_player_par[GetPlayerId(GetTriggerPlayer())]=pcbn_number[i]
call ExecuteDialogCommand(commanded_player[GetPlayerId(GetTriggerPlayer())],current_command[GetPlayerId(GetTriggerPlayer())])
endfunction
function NumberDialogResponse takes nothing returns nothing
local integer i=0
local button b=GetClickedButton()
loop
if i>=ndbn_length then
return
endif
exitwhen ndbn_button[i]==b
set i=i+1
endloop
set current_number_par[GetPlayerId(GetTriggerPlayer())]=i
call ExecuteDialogCommand(commanded_player[GetPlayerId(GetTriggerPlayer())],current_command[GetPlayerId(GetTriggerPlayer())])
endfunction
function TributeDialogResponse takes nothing returns nothing
local button b=GetClickedButton()
local integer pid=GetPlayerId(GetTriggerPlayer())
if b==tribute_g then
set tribute_type[pid]="G"
elseif b==tribute_l then
set tribute_type[pid]="L"
elseif b==tribute_give_g then
set tribute_type[pid]="GiveG"
elseif b==tribute_give_l then
set tribute_type[pid]="GiveL"
else
return
endif
call DialogDisplay(GetTriggerPlayer(),tribute_dlg,true)
endfunction
function TributeAmountDialogResponse takes nothing returns nothing
local integer i=0
local button b=GetClickedButton()
local string tribute_amount=null
local integer pid=GetPlayerId(GetTriggerPlayer())
loop
if i>=tribute_dlg_length then
return
endif
exitwhen tribute_dlg_button[i]==b
set i=i+1
endloop
set tribute_amount=I2S((i+1)*100)
call Tribute(GetTriggerPlayer(),commanded_player[pid],tribute_type[pid],tribute_amount)
endfunction
function Translation takes string s returns string
if HaveStoredString(translation,language,s)then
return GetStoredString(translation,language,s)
else
return s
endif
endfunction
function RegisterCommand takes string c_key1,string c_key2,string c_key3,integer c_number,integer c_par1,integer c_par2,integer c_par3,string c_dlg1,integer c_hk1,string c_dlg2,integer c_hk2,string c_dlg3,integer c_hk3,string c_msg returns nothing
set command_key1[command_length]=StringCase(c_key1,true)
set command_key2[command_length]=StringCase(c_key2,true)
set command_key3[command_length]=StringCase(c_key3,true)
set command_number[command_length]=c_number
set command_par1[command_length]=c_par1
set command_par2[command_length]=c_par2
set command_par3[command_length]=c_par3
set command_dlg1[command_length]=Translation(c_dlg1)
set command_hotkey1[command_length]=c_hk1
set command_dlg2[command_length]=Translation(c_dlg2)
set command_hotkey2[command_length]=c_hk2
set command_dlg3[command_length]=Translation(c_dlg3)
set command_hotkey3[command_length]=c_hk3
set command_msg[command_length]=Translation(c_msg)
set command_length=command_length+1
endfunction
function RegisterCommands takes nothing returns nothing
call RegisterCommand("CHATTER","","",50,-1,-1,-1,"AI Setting",0,"Chatter",67,"",0,"Turned On/Off Computer Chatter.")
call RegisterCommand("DEBUG","","",51,-1,-1,-1,"",0,"",0,"",0,"Turned On/Off Debug Mode.")
call RegisterCommand("BALANCE","","",52,-1,-1,-1,"",0,"",0,"",0,"Turned On/Off Balancing Mode.")
call RegisterCommand("SHOW","STRATEGY","",60,-1,-1,-1,"Show",87,"Current Strategy",67,"",0,"Showing current strategy.")
call RegisterCommand("SHOW","STRATNAMES","",61,-1,-1,-1,"Show",87,"Strategy names",83,"",0,"Showing all strategy names.")
call RegisterCommand("CHANGE","STRATEGY","",70,-4,-1,-1,"Change Strategy",72,"#",0,"",0,"Changes current strategy.")
call RegisterCommand("CANCEL","ALL","",0,-1,-1,-1,"Cancel Orders",67,"All Orders",79,"",0,"I have Canceled All commands you have given me so far.")
call RegisterCommand("CANCEL","ATTACK","",2,-1,-1,-1,"Cancel Orders",67,"Attack Orders",65,"",0,"I have Canceled all Attack commands you have given me so far.")
call RegisterCommand("CANCEL","BUILD","",1,-1,-1,-1,"Cancel Orders",67,"Build Orders",66,"",0,"I have Canceled all Build commands you have given me so far.")
call RegisterCommand("CANCEL","QUEUE","",30,-1,-1,-1,"Cancel Orders",67,"Queue",81,"",0,"I have Canceled all Queued commands you have given me so far.")
call RegisterCommand("CANCEL","QUE","",30,-1,-1,-1,"",0,"",0,"",0,"I have Canceled all Queued commands you have given me so far.")
call RegisterCommand("STOP","","",10,-1,-1,-1,"Stop",83,"",0,"",0,"I will Stop any current Attack.")
call RegisterCommand("NO","ATTACKS","",11,-1,-1,-1,"Restrict",82,"No Attacks",65,"",0,"I will not Attack Anything.")
call RegisterCommand("NO","CREEP","",14,-1,-1,-1,"Restrict",82,"No Creep Attacks",67,"",0,"I will not Attack Creeps.")
call RegisterCommand("NO","PLAYERS","",15,-1,-1,-1,"Restrict",82,"No Enemy Attacks",69,"",0,"I will not Attack Enemies.")
call RegisterCommand("BUILD","A2A","",20,-4,-1,-1,"Build",66,"Air vs. Air",65,"#",0,"I will build Air2Air units now.")
call RegisterCommand("BUILD","A2G","",21,-4,-1,-1,"Build",66,"Air vs. Ground",73,"#",0,"I will build Air2Ground units now.")
call RegisterCommand("BUILD","G2A","",22,-4,-1,-1,"Build",66,"Ground vs. Air",82,"#",0,"I will build Ground2Air units now.")
call RegisterCommand("BUILD","G2G","",23,-4,-1,-1,"Build",66,"Ground vs. Ground",71,"#",0,"I will build Ground2Ground units now.")
call RegisterCommand("BUILD","FARMS","",24,-4,-1,-1,"Build",66,"Farms",70,"#",0,"I will build farms now.")
call RegisterCommand("BUILD","TOWERS","",25,-4,-1,-1,"Build",66,"Towers",84,"#",0,"I will build towers now.")
call RegisterCommand("ATTACK","HERE","",13,0,-30,-31,"Attack",65,"Current screen",67,"",0,"I will Attack/Guard the location of current screen position.")
call RegisterCommand("ATTACK","SELECT","",16,-40,-1,-1,"Attack",65,"Selected unit",83,"",0,"I will Attack/Guard the currently selected unit.")
call RegisterCommand("ATTACK","TOWERRUSH","",17,-1,-1,-1,"Attack",65,"Towerrush (Orc only",84,"",0,"")
call RegisterCommand("ATTACK","","",12,-103,-1,-1,"Attack",65,"Enemy",69,"e",0,"I will Attack/Guard the specified player.")
call RegisterCommand("","START","",33,-1,-1,-1,"Queue",81,"Start/Restart",83,"",0,"I have Started or Restarted your Queued commands.")
call RegisterCommand("","RESTART","",33,-1,-1,-1,"",0,"",0,"",0,"I have Started or Restarted your Queued commands.")
call RegisterCommand("","PAUSE","",34,-1,-1,-1,"Queue",81,"Pause",80,"",0,"I have Paused your Queued commands.")
call RegisterCommand("","UNPAUSE","",35,-1,-1,-1,"Queue",81,"Unpause",78,"",0,"I have Unpaused your Queued commands.")
call RegisterCommand("","UNDO","",36,-1,-1,-1,"Queue",81,"Undo",85,"",0,"I have Removed your last Queued command.")
call RegisterCommand("","ATTACK","HERE",31,-1,-30,-31,"Queue",81,"Attack Here",65,"",0,"I have Queued the Attack/Guard location of current screen position.")
call RegisterCommand("","ATTACK","SELECT",32,-40,-1,-1,"Queue",81,"Attack Select",84,"",0,"I have Queued the currently selected unit to Attack/Guard.")
call RegisterCommand("NO","STRATCHANGE","",53,-1,-1,-1,"Restrict",82,"No Strategy Change",83,"",0,"Turned On/Off Automatic Strategy Change.")
call RegisterCommand("LANGUAGE","English","",71,0,-1,-1,"AI Setting",0,"Language",76,"English",69,"Set language of AI to English.")
call RegisterCommand("LANGUAGE","Deutsch","",71,1,-1,-1,"AI Setting",0,"Language",76,"Deutsch",68,"AI Sprache ist jetzt Deutsch.")
call RegisterCommand("LANGUAGE","Swedish","",71,2,-1,-1,"AI Setting",0,"Language",76,"Swedish",83,"AI Sprak andrat till Svenska.")
call RegisterCommand("LANGUAGE","French","",71,3,-1,-1,"AI Setting",0,"Language",76,"French",70,"Langue de l'IA est maintenant Francais.")
call RegisterCommand("LANGUAGE","Spanish","",71,4,-1,-1,"AI Setting",0,"Language",76,"Spanish",80,"Lengua es Espanol.")
call RegisterCommand("LANGUAGE","Romanian","",71,5,-1,-1,"AI Setting",0,"Language",76,"Romanian",82,"Seteaza Limba in Romana.")
call RegisterCommand("LANGUAGE","Russian","",71,6,-1,-1,"AI Setting",0,"Language",76,"Russian",85,"Language is now Russian.")
call RegisterCommand("LANGUAGE","Portuguese","",71,7,-1,-1,"AI Setting",0,"Language",76,"Portuguese",84,"Language is now Portuguese.")
call RegisterCommand("LANGUAGE","Norwegian","",71,8,-1,-1,"AI Setting",0,"Language",76,"Norwegian",78,"Sett språket til norsk.")
call RegisterCommand("LANGUAGE","Chinese","",71,9,-1,-1,"AI Setting",0,"Language",76,"Chinese",67,"Language is now Chinese.")
endfunction
function AddCancelButton takes dialog d returns nothing
call DialogAddButton(d,dlgbutton_cancel,512)
endfunction
function RegisterCDialogButton takes button b,integer cn,dialog d returns nothing
set cdlg_button[cdlg_length]=b
set cdlg_number[cdlg_length]=cn
set cdlg_dialog[cdlg_length]=d
set cdlg_length=cdlg_length+1
endfunction
function RegisterDialog takes string s returns dialog
local dialog d=DialogCreate()
local trigger t=CreateTrigger()
if s=="" then
call DialogSetMessage(d,dlghdr_root)
else
call DialogSetMessage(d,s)
endif
set dlg_dialog[dlg_length]=d
set dlg_string[dlg_length]=s
set dlg_length=dlg_length+1
call TriggerRegisterDialogEvent(t,d)
call TriggerAddAction(t,function DialogResponse)
return d
endfunction
function FindDialog takes string s returns dialog
local integer i=0
loop
exitwhen i>=dlg_length
if dlg_string[i]==s then
return dlg_dialog[i]
endif
set i=i+1
endloop
return null
endfunction
function BuildStartDialog takes nothing returns nothing
local trigger t=CreateTrigger()
local integer i=0
set start_dialog=DialogCreate()
call DialogSetMessage(start_dialog,dlghdr_choose_ally)
set sdbn_button[sdbn_length]=DialogAddButton(start_dialog,dlgbutton_all,65)
set sdbn_number[sdbn_length]=14
set sdbn_length=sdbn_length+1
loop
exitwhen i>11
if GetPlayerController(Player(i))==MAP_CONTROL_COMPUTER and GetPlayerSlotState(Player(i))==PLAYER_SLOT_STATE_PLAYING then
set sdbn_button[sdbn_length]=DialogAddButton(start_dialog,cs2s(GetPlayerName(Player(i)),GetPlayerColor(Player(i))),IMinBJ(48+i,57))
set sdbn_number[sdbn_length]=i
set sdbn_length=sdbn_length+1
endif
set i=i+1
endloop
call AddCancelButton(start_dialog)
call TriggerRegisterDialogEvent(t,start_dialog)
call TriggerAddAction(t,function StartDialogResponse)
endfunction
function BuildNumberDialog takes nothing returns nothing
local trigger t=CreateTrigger()
local integer i=0
set number_dialog=DialogCreate()
call DialogSetMessage(number_dialog,dlghdr_choose_number)
loop
exitwhen i>=10
set ndbn_button[ndbn_length]=DialogAddButton(number_dialog,I2S(i),IMinBJ(48+i,57))
set ndbn_length=ndbn_length+1
set i=i+1
endloop
call AddCancelButton(number_dialog)
call TriggerRegisterDialogEvent(t,number_dialog)
call TriggerAddAction(t,function NumberDialogResponse)
endfunction
function BuildPlayerDialog takes nothing returns nothing
local trigger t=CreateTrigger()
local integer i=0
set player_dialog=DialogCreate()
call DialogSetMessage(player_dialog,dlghdr_choose_player)
loop
exitwhen i>11
if not IsPlayerObserver(Player(i))and GetPlayerSlotState(Player(i))==PLAYER_SLOT_STATE_PLAYING then
set pcbn_button[pcbn_length]=DialogAddButton(player_dialog,cs2s(GetPlayerName(Player(i)),GetPlayerColor(Player(i))),IMinBJ(48+i,57))
set pcbn_number[pcbn_length]=i
set pcbn_length=pcbn_length+1
endif
set i=i+1
endloop
call AddCancelButton(player_dialog)
call TriggerRegisterDialogEvent(t,player_dialog)
call TriggerAddAction(t,function PlayerDialogResponse)
endfunction
function AddCommandDialog takes integer i returns nothing
local dialog current_dialog=null
local dialog next_dialog=null
local string current_name=""
if command_dlg3[i]!="" then
if command_dlg3[i]=="#" then
set next_dialog=number_dialog
elseif command_dlg3[i]=="e" then
set next_dialog=player_dialog
else
set current_name=command_dlg1[i]+" "+command_dlg2[i]
set current_dialog=FindDialog(current_name)
if current_dialog!=null then
call RegisterCDialogButton(DialogAddButton(current_dialog,command_dlg3[i],command_hotkey3[i]),i,next_dialog)
return
endif
set current_dialog=RegisterDialog(current_name)
call RegisterCDialogButton(DialogAddButton(current_dialog,command_dlg3[i],command_hotkey3[i]),i,next_dialog)
set next_dialog=current_dialog
endif
endif
if command_dlg2[i]!="" then
if command_dlg2[i]=="#" then
set next_dialog=number_dialog
elseif command_dlg2[i]=="e" then
set next_dialog=player_dialog
else
set current_name=command_dlg1[i]
set current_dialog=FindDialog(current_name)
if current_dialog!=null then
call RegisterCDialogButton(DialogAddButton(current_dialog,command_dlg2[i],command_hotkey2[i]),i,next_dialog)
return
endif
set current_dialog=RegisterDialog(current_name)
call RegisterCDialogButton(DialogAddButton(current_dialog,command_dlg2[i],command_hotkey2[i]),i,next_dialog)
set next_dialog=current_dialog
endif
endif
if command_dlg1[i]!="" then
set current_name=""
set current_dialog=FindDialog(current_name)
if current_dialog!=null then
call RegisterCDialogButton(DialogAddButton(current_dialog,command_dlg1[i],command_hotkey1[i]),i,next_dialog)
return
endif
set current_dialog=RegisterDialog(current_name)
call RegisterCDialogButton(DialogAddButton(current_dialog,command_dlg1[i],command_hotkey1[i]),i,next_dialog)
endif
endfunction
function AddCDCancelButtons takes nothing returns nothing
local integer i=0
loop
exitwhen i>=dlg_length
call AddCancelButton(dlg_dialog[i])
set i=i+1
endloop
endfunction
function BuildCommandDialogs takes nothing returns nothing
local integer i=0
loop
exitwhen i>=command_length
call AddCommandDialog(i)
set i=i+1
endloop
set root_dialog=FindDialog("")
endfunction
function BuildTributeDialogs takes nothing returns nothing
local dialog d=DialogCreate()
local trigger t=CreateTrigger()
local integer i=0
call DialogSetMessage(d,dlghdr_tribute_type)
set tribute_g=DialogAddButton(d,dlgbutton_gold,71)
set tribute_l=DialogAddButton(d,dlgbutton_lumber,76)
set tribute_give_g=DialogAddButton(d,dlgbutton_give_gold,79)
set tribute_give_l=DialogAddButton(d,dlgbutton_give_lumber,85)
call AddCancelButton(d)
call TriggerRegisterDialogEvent(t,d)
call TriggerAddAction(t,function TributeDialogResponse)
call RegisterCDialogButton(DialogAddButton(root_dialog,dlgbutton_tribute,84),0,d)
set tribute_dlg=DialogCreate()
call DialogSetMessage(tribute_dlg,dlghdr_tribute_amount)
loop
exitwhen i>=10
set tribute_dlg_button[i]=DialogAddButton(tribute_dlg,I2S(100*(i+1)),IMinBJ(48+i+1,57))
set i=i+1
endloop
call AddCancelButton(tribute_dlg)
set tribute_dlg_length=i
set t=CreateTrigger()
call TriggerRegisterDialogEvent(t,tribute_dlg)
call TriggerAddAction(t,function TributeAmountDialogResponse)
endfunction
function BuildDialogs takes nothing returns nothing
call BuildStartDialog()
call BuildNumberDialog()
call BuildPlayerDialog()
call BuildCommandDialogs()
call BuildTributeDialogs()
call AddCDCancelButtons()
endfunction
function InitCommanderPart takes nothing returns nothing
local integer i=0
local trigger commander_trigger=CreateTrigger()
local trigger cdlg_trigger=CreateTrigger()
local timer t=CreateTimer()
loop
exitwhen i>=12
call TriggerRegisterPlayerChatEvent(commander_trigger,Player(i),command_prefix,false)
call TriggerRegisterPlayerEvent(cdlg_trigger,Player(i),EVENT_PLAYER_END_CINEMATIC)
set i=i+1
endloop
call TriggerAddAction(commander_trigger,function Commander)
call TriggerAddAction(cdlg_trigger,function DialogCommander)
call RegisterCommands()
call BuildDialogs()
call TimerStart(t,3.0,false,function MapInit)
endfunction
function SendToAllAIs takes integer cmd,integer data returns nothing
local integer i=0
loop
exitwhen i>11
if GetPlayerController(Player(i))==MAP_CONTROL_COMPUTER then
call CommandAI(Player(i),cmd,data)
endif
set i=i+1
endloop
endfunction
function GetNextHuman takes integer last returns integer
local integer i=last+1
loop
exitwhen i>11
if GetPlayerController(Player(i))==MAP_CONTROL_USER and not IsPlayerObserver(Player(i))and GetPlayerSlotState(Player(i))==PLAYER_SLOT_STATE_PLAYING then
return i
endif
set i=i+1
endloop
return-1
endfunction
function GetFirstHuman takes nothing returns integer
return GetNextHuman(-1)
endfunction
function CheckAllyToControl takes player p returns boolean
local integer q=0
loop
exitwhen q>11
if IsPlayerAlly(Player(q),p)and GetPlayerController(Player(q))==MAP_CONTROL_COMPUTER then
return true
endif
set q=q+1
endloop
return false
endfunction
function EnumKillUnit takes nothing returns nothing
call KillUnit(GetEnumUnit())
endfunction
function RemoveHumanUnitsAndRes takes nothing returns nothing
local player p=GetEnumPlayer()
local group g=null
if GetPlayerController(p)!=MAP_CONTROL_USER then
return
endif
set g=CreateGroup()
call GroupEnumUnitsOfPlayer(g,p,null)
call ForGroup(g,function EnumKillUnit)
call SetPlayerState(p,PLAYER_STATE_RESOURCE_GOLD,0)
call SetPlayerState(p,PLAYER_STATE_RESOURCE_LUMBER,0)
endfunction
function GameStartDlgResponse takes nothing returns nothing
local button cb=GetClickedButton()
if cb!=ai_only_mode then
call InitCommanderPart()
if cb==no_human_mode then
call ForForce(GetPlayersAll(),function RemoveHumanUnitsAndRes)
call SendToAllAIs(53,0)
endif
endif
call DialogDestroy(game_start_dialog)
call DestroyTrigger(game_start_trigger)
endfunction
function GameStartDefault takes nothing returns nothing
if game_mode!="ai_only" then
call InitCommanderPart()
if game_mode=="no_human" then
call ForForce(GetPlayersAll(),function RemoveHumanUnitsAndRes)
call SendToAllAIs(53,0)
endif
endif
endfunction
function GameStartDlg takes nothing returns nothing
local integer host=GetFirstHuman()
local integer p=host
loop
if p==-1 then
return
endif
exitwhen CheckAllyToControl(Player(p))
set p=GetNextHuman(p)
endloop
if game_mode!="" then
call GameStartDefault()
return
endif
set game_start_dialog=DialogCreate()
call DialogSetMessage(game_start_dialog,dlghdr_game_type)
set commander_mode=DialogAddButton(game_start_dialog,dlgbutton_commander,67)
set no_human_mode=DialogAddButton(game_start_dialog,dlgbutton_no_human,79)
set ai_only_mode=DialogAddButton(game_start_dialog,dlgbutton_ai_only,78)
set game_start_trigger=CreateTrigger()
call TriggerRegisterDialogEvent(game_start_trigger,game_start_dialog)
call TriggerAddAction(game_start_trigger,function GameStartDlgResponse)
call DialogDisplay(Player(host),game_start_dialog,true)
endfunction
function initLanguageEnglish takes nothing returns nothing
set chat_no_ally="I will never obey you."
set dlghdr_choose_ally="Choose Ally"
set dlghdr_choose_number="Choose Number"
set dlghdr_choose_player="Choose Player"
set dlghdr_game_type="Choose Game Type"
set dlghdr_root="Choose Command"
set dlghdr_tribute_type="Choose Tribute Type"
set dlghdr_tribute_amount="Choose Tribute Amount"
set dlgbutton_cancel="Cancel"
set dlgbutton_all="All"
set dlgbutton_gold="Gold"
set dlgbutton_lumber="Lumber"
set dlgbutton_give_gold="Give Gold"
set dlgbutton_give_lumber="Give Lumber"
set dlgbutton_tribute="Tribute"
set dlgbutton_commander="Commander"
set dlgbutton_no_human="Computers only"
set dlgbutton_ai_only="No Commander"
endfunction
function initLanguageDeutsch takes nothing returns nothing
set chat_no_ally="Ich werde dir nie gehorchen."
set dlghdr_choose_ally="Wähle einen Verbündeten"
set dlghdr_choose_number="Zahl wählen"
set dlghdr_choose_player="Wähle einen Spieler"
set dlghdr_game_type="Wähle den Spielmodus"
set dlghdr_root="Befehl wählen"
set dlghdr_tribute_type="Wähle die Tributart"
set dlghdr_tribute_amount="Wähle die Tributmenge"
set dlgbutton_cancel="Abbrechen"
set dlgbutton_all="Alle"
set dlgbutton_gold="Gold"
set dlgbutton_lumber="Holz"
set dlgbutton_give_gold="Gold geben"
set dlgbutton_give_lumber="Holz geben"
set dlgbutton_tribute="Tribut"
set dlgbutton_commander="Commander"
set dlgbutton_no_human="Nur Computer"
set dlgbutton_ai_only="Kein Commander"
call StoreString(translation,language,"AI Setting","AI Einstellungen")
call StoreString(translation,language,"Chatter","Chatten")
call StoreString(translation,language,"Turned On/Off Computer Chatter.","Computer Chatten wurde an/ausgeschaltet.")
call StoreString(translation,language,"Turned On/Off Debug Mode.","Debug Modus wurde an/ausgeschaltet.")
call StoreString(translation,language,"Turned On/Off Balancing Mode.","Balance Modus wurde an/ausgeschaltet.")
call StoreString(translation,language,"Show","Zeige")
call StoreString(translation,language,"Current Strategy","Momentane Strategie")
call StoreString(translation,language,"Showing current strategy.","Ich zeige momentane Strategie an.")
call StoreString(translation,language,"Strategy names","Strategienamen")
call StoreString(translation,language,"Change Strategy","Ändere Strategie")
call StoreString(translation,language,"Changes current strategy.","Ich ändere die momentane Strategie.")
call StoreString(translation,language,"Cancel Orders","Befehle löschen")
call StoreString(translation,language,"All Orders","Alle Befehle")
call StoreString(translation,language,"I have Canceled All commands you have given me so far.","Ich habe alle Befehle gelöscht, die du mir bis jetzt gegeben hast.")
call StoreString(translation,language,"Attack Orders","Angriffsbefehle")
call StoreString(translation,language,"I have Canceled all Attack commands you have given me so far.","Ich habe alle Angriffsbefehle gelöscht, die du mir bis jetzt gegeben hast.")
call StoreString(translation,language,"Build Orders","Baubefehle")
call StoreString(translation,language,"I have Canceled all Build commands you have given me so far.","Ich habe alle Baubefehle gelöscht, die du mir bis jetzt gegeben hast.")
call StoreString(translation,language,"Queue","Queuebefehle")
call StoreString(translation,language,"I have Canceled all Queued commands you have given me so far.","Ich habe alle Queuebefehle gelöscht, die du mir bis jetzt gegeben hast.")
call StoreString(translation,language,"I will Stop any current Attack.","Ich breche den momentanen Angriff ab.")
call StoreString(translation,language,"I will not Attack Anything.","Ich greife nichts an.")
call StoreString(translation,language,"I will not Attack Creeps.","Ich greife keine Creeps an.")
call StoreString(translation,language,"I will not Attack Enemies.","Ich greife keine Feinde an.")
call StoreString(translation,language,"I will build Air2Air units now.","Ich baue Luft-Luft-Einheiten.")
call StoreString(translation,language,"I will build Air2Ground units now.","Ich baue Luft-Boden-Einheiten.")
call StoreString(translation,language,"I will build Ground2Air units now.","Ich baue Boden-Luft-Einheiten.")
call StoreString(translation,language,"I will build Ground2Ground units now.","Ich baue Boden-Boden-Einheiten.")
call StoreString(translation,language,"I will build farms now.","Ich baue Farmen.")
call StoreString(translation,language,"I will build towers now.","Ich baue Türme.")
call StoreString(translation,language,"I will Attack/Guard the location of current screen position.","Ich greife an/verteidige die momentane Bildschirmposition.")
call StoreString(translation,language,"I will Attack/Guard the currently selected unit.","Ich greife an/verteidige die gewählte Einheit.")
call StoreString(translation,language,"I will Attack/Guard the specified player.","Ich greife an/verteidige den gewählten Spieler.")
call StoreString(translation,language,"I have Started or Restarted your Queued commands.","Ich habe die Befehlsqueue gestartet / erneut gestartet.")
call StoreString(translation,language,"I have Paused your Queued commands.","Ich habe die Befehlsqueue angehalten.")
call StoreString(translation,language,"I have Unpaused your Queued commands.","Ich habe die Befehlsqueue weiterlaufen lassen.")
call StoreString(translation,language,"I have Removed your last Queued command.","Ich habe den letzten Befehl in der Befehlsqueue gelöscht.")
call StoreString(translation,language,"I have Queued the Attack/Guard location of current screen position.","Ich habe den Angriff/die Verteidigung der momentanen Bildschirmposition in die Queue hinzugefügt.")
call StoreString(translation,language,"I have Queued the currently selected unit to Attack/Guard.","Ich habe den Angriff/die Verteidigung der gewählten Einheit in die Queue hinzugefügt.")
call StoreString(translation,language,"Turned On/Off Automatic Strategy Change.","Ich habe den automatischen Strategiewechsel an/ausgeschaltet.")
call StoreString(translation,language,"Restrict","Einschränken")
call StoreString(translation,language,"No Attacks","Kein Angriff")
call StoreString(translation,language,"No Creep Attacks","Keine Creepangriffe")
call StoreString(translation,language,"No Enemy Attacks","Keine Feindangriffe")
call StoreString(translation,language,"Farms","Farmen")
call StoreString(translation,language,"Towers","Türme")
call StoreString(translation,language,"Current screen","Bildschirmposition")
call StoreString(translation,language,"Selected unit","Gewählte Einheit")
call StoreString(translation,language,"Towerrush (Orc only)","Towerrush (Nur Orks)")
call StoreString(translation,language,"Start/Restart","Start / Neustart")
call StoreString(translation,language,"No Strategy Change","Kein Strategiewechsel")
call StoreString(translation,language,"Build","Bauen")
call StoreString(translation,language,"Attack Here","Bildschirmposition angreifen")
call StoreString(translation,language,"Unpause","Ende Pause")
call StoreString(translation,language,"Undo","Rückgängig")
call StoreString(translation,language,"Attack select","Gewählte Einheit angreifen")
call StoreString(translation,language,"Air vs. Air","Luft-Luft")
call StoreString(translation,language,"Air vs. Ground","Luft-Boden")
call StoreString(translation,language,"Ground vs. Air","Boden-Luft")
call StoreString(translation,language,"Ground vs. Ground","Boden-Boden")
endfunction
function initLanguageSwedish takes nothing returns nothing
set chat_no_ally="jag kommer aldrig lyda dig."
set dlghdr_choose_ally="Välj din lierade"
set dlghdr_choose_number="Välj nummer"
set dlghdr_choose_player="Välj spelare"
set dlghdr_game_type="Välj speltyp"
set dlghdr_root="Välj kommando"
set dlghdr_tribute_type="Välj bidragsmetod"
set dlghdr_tribute_amount="Välj bidragsstorlek"
set dlgbutton_cancel="Avbryt"
set dlgbutton_all="Alla"
set dlgbutton_gold="Guld"
set dlgbutton_lumber="Trä"
set dlgbutton_tribute="Bidrag"
set dlgbutton_commander="Commander"
set dlgbutton_no_human="Endast datorer"
set dlgbutton_ai_only="Ingen Commander"
call StoreString(translation,language,"AI Setting","AI Inställningar")
call StoreString(translation,language,"Chatter","Chat")
call StoreString(translation,language,"Turned On/Off Computer Chatter.","Stängde av / satte på dator chat.")
call StoreString(translation,language,"Turned On/Off Debug Mode.","Stängde av / satte på felsökningsmedelande.")
call StoreString(translation,language,"Turned On/Off Balancing Mode.","Stängde av / satte på balanseringsläge.")
call StoreString(translation,language,"Show","Visa")
call StoreString(translation,language,"Current Strategy","Aktuell strategi")
call StoreString(translation,language,"Showing current strategy.","Visar aktuell strategi.")
call StoreString(translation,language,"Strategy names","Strateginamn")
call StoreString(translation,language,"Change Strategy","Byt strategi")
call StoreString(translation,language,"Changes current strategy.","Byter aktuell strategi.")
call StoreString(translation,language,"Cancel Orders","Avbryt order")
call StoreString(translation,language,"All Orders","Alla ordrar")
call StoreString(translation,language,"I have Canceled All commands you have given me so far.","Jag har avbrutit alla kommandon.")
call StoreString(translation,language,"Attack Orders","Anfallskommand")
call StoreString(translation,language,"I have Canceled all Attack commands you have given me so far.","Jag har avbrutit alla anfallskommandon.")
call StoreString(translation,language,"Build Orders","Byggkommand")
call StoreString(translation,language,"I have Canceled all Build commands you have given me so far.","Jag har avbrutit alla byggkommandon.")
call StoreString(translation,language,"Queue","Följdkommando")
call StoreString(translation,language,"I have Canceled all Queued commands you have given me so far.","Jag har avbrutit alla följdkommandon.")
call StoreString(translation,language,"I will Stop any current Attack.","Jag har avbrutit alla byggorder du gett hittills.")
call StoreString(translation,language,"I will not Attack Anything.","Jag har avbrutit alla följdkommando du gett mig hittills.")
call StoreString(translation,language,"I will not Attack Creeps.","Jag avbryter nuvarande anfall.")
call StoreString(translation,language,"I will not Attack Enemies.","Jag kommer inte anfalla något.")
call StoreString(translation,language,"I will build Air2Air units now.","Jag kommer bygga luft- mot luftenheter nu.")
call StoreString(translation,language,"I will build Air2Ground units now.","Jag kommer bygga luft- mot markenheter nu.")
call StoreString(translation,language,"I will build Ground2Air units now.","Jag kommer bygga mark- mot luftenheter nu.")
call StoreString(translation,language,"I will build Ground2Ground units now.","Jag kommer bygga mark- mot markenheter nu.")
call StoreString(translation,language,"I will build farms now.","Jag kommer bygga farms nu.")
call StoreString(translation,language,"I will build towers now.","Jag kommer bygga torn nu.")
call StoreString(translation,language,"I will Attack/Guard the location of current screen position.","Jag kommer anfalla/vakta nuvarande position av bilden.")
call StoreString(translation,language,"I will Attack/Guard the currently selected unit.","Jag kommer anfalla/vakta den aktuellt valda enheten.")
call StoreString(translation,language,"I will Attack/Guard the specified player.","Jag kommer anfalla/vakta den valda spelaren.")
call StoreString(translation,language,"I have Started or Restarted your Queued commands.","Jag har startat eller återställt dina följdkommando.")
call StoreString(translation,language,"I have Paused your Queued commands.","Jag har pausat dina följdkommando.")
call StoreString(translation,language,"I have Unpaused your Queued commands.","Jag har fortsatt med dina följdkommandon.")
call StoreString(translation,language,"I have Removed your last Queued command.","Jag har tagit bort ditt senaste följdkommando.")
call StoreString(translation,language,"I have Queued the Attack/Guard location of current screen position.","Jag har följdlagt en order att anfalla/vakta nuvarande bild.")
call StoreString(translation,language,"I have Queued the currently selected unit to Attack/Guard.","Jag har följdlagt en order att anfalla/vakta valda enheten.")
call StoreString(translation,language,"Turned On/Off Automatic Strategy Change.","Stängt av / satt på automatiskt strategibyte.")
call StoreString(translation,language,"Restrict","Begränsa")
call StoreString(translation,language,"No Attacks","Inga anfall")
call StoreString(translation,language,"No Creep Attacks","Inga creep-attacker")
call StoreString(translation,language,"No Enemy Attacks","Inga fiende-anfall")
call StoreString(translation,language,"Farms","Farms")
call StoreString(translation,language,"Towers","Torn")
call StoreString(translation,language,"Current screen","Nuvarande bild")
call StoreString(translation,language,"Selected unit","Vald enhet")
call StoreString(translation,language,"Towerrush (Orc only)","Towerrush (Bara för Orc)")
call StoreString(translation,language,"Start/Restart","Starta/Starta om")
call StoreString(translation,language,"No Strategy Change","Inget strategibyte")
call StoreString(translation,language,"Build","Bygg")
call StoreString(translation,language,"Attack Here","Anfall bild")
call StoreString(translation,language,"Unpause","Fortsätt")
call StoreString(translation,language,"Undo","Ångra")
call StoreString(translation,language,"attack select","Anfall vald")
call StoreString(translation,language,"Air vs. Air","Luft mot. Luft")
call StoreString(translation,language,"Air vs. Ground","Luft mot. Mark")
call StoreString(translation,language,"Ground vs. Air","Mark mot. Luft")
call StoreString(translation,language,"Ground vs. Ground","Mark mot. Mark")
endfunction
function initLanguageFrench takes nothing returns nothing
set chat_no_ally="Je ne t'obéirai jamais."
set dlghdr_choose_ally="Choisir un allie."
set dlghdr_choose_number="Choisir un nombre."
set dlghdr_choose_player="Choisir un joueur."
set dlghdr_game_type="Choisir un type de partie."
set dlghdr_root="Choisissez la Commande."
set dlghdr_tribute_type="Choisir le type de tributs."
set dlghdr_tribute_amount="Choisirla quantite de tributs."
set dlgbutton_cancel="Annuler."
set dlgbutton_all="Tout."
set dlgbutton_gold="Or."
set dlgbutton_lumber="Bois."
set dlgbutton_tribute="Tributs."
set dlgbutton_commander="Commandant."
set dlgbutton_no_human="Seulement des ordinateurs"
set dlgbutton_ai_only="Pas de commandant."
call StoreString(translation,language,"AI Setting","Configuration de l'IA")
call StoreString(translation,language,"Chatter","Discussion")
call StoreString(translation,language,"Turned On/Off Computer Chatter.","Permettre/Proscrire la discussion avec l'ordinateur.")
call StoreString(translation,language,"Turned On/Off Debug Mode.","Permettre/Proscrire le mode debogger .")
call StoreString(translation,language,"Turned On/Off Balancing Mode.","Permettre/proscire le mode d'équilibrage.")
call StoreString(translation,language,"Show","Montrer")
call StoreString(translation,language,"Current Strategy","Strategie actuelle")
call StoreString(translation,language,"Showing current strategy.","Montrer la strategie actuelle.")
call StoreString(translation,language,"Strategy names","Noms des strategies")
call StoreString(translation,language,"Change Strategy","Changer la strategie")
call StoreString(translation,language,"Changes current strategy.","Changer la strategie actuelle.")
call StoreString(translation,language,"Cancel Orders","Annuler les ordres")
call StoreString(translation,language,"All Orders","tous les ordres")
call StoreString(translation,language,"I have Canceled All commands you have given me so far.","J'ai annule tous les ordres que tu m'as donne auparavant.")
call StoreString(translation,language,"Attack Orders","Les ordres d'attaques")
call StoreString(translation,language,"I have Canceled all Attack commands you have given me so far.","J'ai annule tous les ordres d'attaque que tu m'as donne auparavant.")
call StoreString(translation,language,"Build Orders","les ordres de construction")
call StoreString(translation,language,"I have Canceled all Build commands you have given me so far.","J'ai annule tous les ordres de construction que tu m'as donne auparavant.")
call StoreString(translation,language,"Queue","file d'attente")
call StoreString(translation,language,"I have Canceled all Queued commands you have given me so far.","J'ai annule tous les ordres dans la file d'attente que tu m'as donne auparavant.")
call StoreString(translation,language,"I will Stop any current Attack.","Je vais annuler toutes attaques actuelles.")
call StoreString(translation,language,"I will not Attack Anything.","Je vais attaqer personne.")
call StoreString(translation,language,"I will not Attack Creeps.","Je ne vais pas attquer de creep.")
call StoreString(translation,language,"I will not Attack Enemies.","Je ne vais pas attaquer d'ennemis.")
call StoreString(translation,language,"I will build Air2Air units now.","Je vais creer des unites air/air maintenant.")
call StoreString(translation,language,"I will build Air2Ground units now.","Je vais creer des unites air/sol maintenant.")
call StoreString(translation,language,"I will build Ground2Air units now.","Je vais creer des unites sol/air maintenant.")
call StoreString(translation,language,"I will build Ground2Ground units now.","Je vais creer des unites sol/sol maintenant.")
call StoreString(translation,language,"I will build farms now.","Je vais creer des fermes maintenant.")
call StoreString(translation,language,"I will build towers now.","Je vais creer des tourelles maintenant.")
call StoreString(translation,language,"I will Attack/Guard the location of current screen position.","Je vais attaquer/garder a la position actuelle de l'ecran.")
call StoreString(translation,language,"I will Attack/Guard the currently selected unit.","Je vais attaquer/garder cette unite selectionnee actuellement.")
call StoreString(translation,language,"I will Attack/Guard the specified player.","Je vais attaquer/garder ce joueur specifique.")
call StoreString(translation,language,"I have Started or Restarted your Queued commands.","J'ai commence ou recommence tes ordres dans la file d'attente.")
call StoreString(translation,language,"I have Paused your Queued commands.","J'ai mis en veille vos ordres dans la file d'attente.")
call StoreString(translation,language,"I have Unpaused your Queued commands.","J'ai repris vos ordres dans la file d'attente.")
call StoreString(translation,language,"I have Removed your last Queued command.","J'ai supprime vos derniers ordres dans la file d'attente.")
call StoreString(translation,language,"I have Queued the Attack/Guard location of current screen position.","J'ai mis dans la file d'attente l'attaque/la protection du lieu de l'ecran actuel.")
call StoreString(translation,language,"I have Queued the currently selected unit to Attack/Guard.","J'ai mis dans la file d'attente l'unite choisir a attaquer/garder.")
call StoreString(translation,language,"Turned On/Off Automatic Strategy Change.","Permettre/Proscire les changements automatiques de strategie.")
call StoreString(translation,language,"Restrict","Restrictions")
call StoreString(translation,language,"No Attacks","Pas d'attaques")
call StoreString(translation,language,"No Creep Attacks","Pas d'attaques de creep")
call StoreString(translation,language,"No Enemy Attacks","Pas d'attaques contre des ennemis")
call StoreString(translation,language,"Farms","Fermes")
call StoreString(translation,language,"Towers","Tourelles")
call StoreString(translation,language,"Current screen","Position actuelle")
call StoreString(translation,language,"Selected unit","L'unite selectionnee")
call StoreString(translation,language,"Towerrush (Orc only)","Towerrush (Orc seulement)")
call StoreString(translation,language,"No Strategy Change","Pas de changement de strategie")
call StoreString(translation,language,"Start/Restart","Commencer/Recommencer")
call StoreString(translation,language,"Build","Construire")
call StoreString(translation,language,"Attack Here","Attaquer ici")
call StoreString(translation,language,"Unpause","Reprise")
call StoreString(translation,language,"Undo","Annuler")
call StoreString(translation,language,"attack select","Attaque choisie")
call StoreString(translation,language,"Air vs. Air","Air vs. Air")
call StoreString(translation,language,"Air vs. Ground","Air vs. sol")
call StoreString(translation,language,"Ground vs. Air","sol vs. Air")
call StoreString(translation,language,"Ground vs. Ground","sol vs. sol")
endfunction
function initLanguageSpanish takes nothing returns nothing
set chat_no_ally="Nunca te voy a obedecer."
set dlghdr_choose_ally="Escoger aliado"
set dlghdr_choose_number="Escoger numero"
set dlghdr_choose_player="Escoger jugador"
set dlghdr_game_type="Escoger tipo de juego"
set dlghdr_root="Escoger comando"
set dlghdr_tribute_type="Escoger tipo de tributo"
set dlghdr_tribute_amount="Escoger cantidad de tributo"
set dlgbutton_cancel="Cancelar"
set dlgbutton_all="Todo"
set dlgbutton_gold="Oro"
set dlgbutton_lumber="Leña"
set dlgbutton_tribute="Tributo"
set dlgbutton_commander="Comandante"
set dlgbutton_no_human="Solo computadoras"
set dlgbutton_ai_only="No usar comandante"
call StoreString(translation,language,"AI Setting","Opcion del AI")
call StoreString(translation,language,"Chatter","Conversacion")
call StoreString(translation,language,"Turned On/Off Computer Chatter.","Se Activo/Desactivo la conversacion de la computadora.")
call StoreString(translation,language,"Turned On/Off Debug Mode.","Se Activo/Desactivo el mode de Depuracion.")
call StoreString(translation,language,"Turned On/Off Balancing Mode.","Se Activo/Desactivo el modo de balance.")
call StoreString(translation,language,"Show","Mostrar")
call StoreString(translation,language,"Current Strategy","Estrategia actual")
call StoreString(translation,language,"Showing current strategy.","Mostrando estrategia actual.")
call StoreString(translation,language,"Strategy names","Nombres de estrategias")
call StoreString(translation,language,"Change Strategy","Cambiar Estrategia")
call StoreString(translation,language,"Changes current strategy.Cambiando the estrategia.","")
call StoreString(translation,language,"Cancel Orders","Cancelar Ordernes")
call StoreString(translation,language,"All Orders","Todas las ordenes")
call StoreString(translation,language,"I have Canceled All commands you have given me so far.","He cancelado todos los comandos que me diste hasta ahora.")
call StoreString(translation,language,"Attack Orders","Ordenes de Ataque")
call StoreString(translation,language,"I have Canceled all Attack commands you have given me so far.","He cancelado todos los comandos de ataque que me diste hasta ahora.")
call StoreString(translation,language,"Build Orders"," Ordenes de Construccion")
call StoreString(translation,language,"I have Canceled all Build commands you have given me so far.","He cancelado todos los comandos de construccion que me diste hasta ahora.")
call StoreString(translation,language,"Queue","Comandos en la Cola")
call StoreString(translation,language,"I have Canceled all Queued commands you have given me so far.","He cancelado todos los comandos en la cola que me diste hasta ahora.")
call StoreString(translation,language,"I will Stop any current Attack.","Voy a detener todos los ataques.")
call StoreString(translation,language,"I will not Attack Anything.","No voy a atacar nada.")
call StoreString(translation,language,"I will not Attack Creeps.","No voy a atacar a los creeps.")
call StoreString(translation,language,"I will not Attack Enemies.","No voy a atacar a los enemigos")
call StoreString(translation,language,"I will build Air2Air units now.","Ahora voy a construir unidades Aire-Aire.")
call StoreString(translation,language,"I will build Air2Ground units now.","Ahora voy a construir unidades Aire-Tierra.")
call StoreString(translation,language,"I will build Ground2Air units now.","Ahora voy a construir unidades Tierra-Aire.")
call StoreString(translation,language,"I will build Ground2Ground units now.","Ahora voy a construir unidades Tierra-Tierra.")
call StoreString(translation,language,"I will build farms now.","Ahora voy a construir granjas.")
call StoreString(translation,language,"I will build towers now.","Ahora voy a construir torres.")
call StoreString(translation,language,"I will Attack/Guard the location of current screen position.","Voy a atacar/proteger el sector que actualmente esta en pantalla.")
call StoreString(translation,language,"I will Attack/Guard the currently selected unit.","Voy a atacar/proteger la unidad que esta seleccionada")
call StoreString(translation,language,"I will Attack/Guard the specified player.","Voy a atacar/proteger el jugador especificado.")
call StoreString(translation,language,"I have Started or Restarted your Queued commands.","He  comenzado o vuelto a comenzar tus comandos en cola.")
call StoreString(translation,language,"I have Paused your Queued commands.","He dejado en pausa tus comandos en cola.")
call StoreString(translation,language,"I have Unpaused your Queued commands.","Procedo a continuar tus comandos en cola.")
call StoreString(translation,language,"I have Removed your last Queued command.","He removido tu ultimo comando en cola")
call StoreString(translation,language,"I have Queued the Attack/Guard location of current screen position.","He dejado en Ia cola la orden para atacar/proteger la posición actual de la pantalla.")
call StoreString(translation,language,"I have Queued the currently selected unit to Attack/Guard.","He dejado en Ia cola la orden para atacar/proteger la unidad seleccionada.")
call StoreString(translation,language,"Turned On/Off Automatic Strategy Change.","Se activo/desactivo el cambio automatico de estrategia.")
call StoreString(translation,language,"Restrict","Restringir")
call StoreString(translation,language,"No Attacks","No Atacar")
call StoreString(translation,language,"No Creep Attacks","No atacar a los Creeps")
call StoreString(translation,language,"No Enemy Attacks","No atacar a los enemigos")
call StoreString(translation,language,"Farms","Granjas")
call StoreString(translation,language,"Towers","Torres")
call StoreString(translation,language,"Current screen","Sector en Pantalla")
call StoreString(translation,language,"Selected unit","Unidad Seleccionada")
call StoreString(translation,language,"Towerrush (Orc only)","Usar Torres (Solo Orcos)")
call StoreString(translation,language,"Start/Restart","Comenzar/Re-empezar")
call StoreString(translation,language,"No Strategy Change","No cambiar de estrategia")
call StoreString(translation,language,"Build","Construir")
call StoreString(translation,language,"Attack Here","Atacar aqui")
call StoreString(translation,language,"Unpause","Continuar")
call StoreString(translation,language,"Undo","Deshacer")
call StoreString(translation,language,"attack select","Atacar Seleccion")
call StoreString(translation,language,"Air vs. Air","Aire contra Aire")
call StoreString(translation,language,"Air vs. Ground","Aire contra Tierra")
call StoreString(translation,language,"Ground vs. Air","Tierra contra Aire")
call StoreString(translation,language,"Ground vs. Ground","Tierra contra Tierra")
endfunction
function initLanguageRomanian takes nothing returns nothing
set chat_no_ally="Nu voi asculta niciodata de tine."
set dlghdr_choose_ally="Alege aliatul"
set dlghdr_choose_number="Alege un numar"
set dlghdr_choose_player="Alege jucatorul"
set dlghdr_game_type="Alege tipul meciului"
set dlghdr_root="Alege comanda"
set dlghdr_tribute_type="Alege tipul de tribut"
set dlghdr_tribute_amount="Alege cantitatea tributului"
set dlgbutton_cancel="Anuleaza"
set dlgbutton_all="Toate"
set dlgbutton_gold="Aur"
set dlgbutton_lumber="Lemn"
set dlgbutton_tribute="Tribut"
set dlgbutton_commander="Commander"
set dlgbutton_no_human="Numai computere"
set dlgbutton_ai_only="Fara Commander"
call StoreString(translation,language,"AI Setting","Setari AI")
call StoreString(translation,language,"Chatter","Vorbire")
call StoreString(translation,language,"Turned On/Off Computer Chatter.","Schimba On/Off vorbirea computerului.")
call StoreString(translation,language,"Turned On/Off Debug Mode.","Schimba On/Off Debug Mode.")
call StoreString(translation,language,"Turned On/Off Balancing Mode.","Schimba On/Off Mod de echilibrare.")
call StoreString(translation,language,"Show","Arata")
call StoreString(translation,language,"Current Strategy","Strategia Curenta")
call StoreString(translation,language,"Showing current strategy.","Arata strategia curenta.")
call StoreString(translation,language,"Strategy names","Nume de strategii")
call StoreString(translation,language,"Change Strategy","Schimba Strategia")
call StoreString(translation,language,"Changes current strategy.","Schimba strategia curenta.")
call StoreString(translation,language,"Cancel Orders","Anuleaza Comenzile")
call StoreString(translation,language,"All Orders","Toate Comenzile")
call StoreString(translation,language,"I have Canceled All commands you have given me so far.","Am anulat toate comenzile date pina acum.")
call StoreString(translation,language,"Attack Orders","Comenzile de Atac")
call StoreString(translation,language,"I have Canceled all Attack commands you have given me so far.","Am anulat toate comenzile de atac date pina acum.")
call StoreString(translation,language,"Build Orders","Comenzile de constructii")
call StoreString(translation,language,"I have Canceled all Build commands you have given me so far.","Am anulat toate comenzile de construit date pina acum.")
call StoreString(translation,language,"Queue","Sirul")
call StoreString(translation,language,"I have Canceled all Queued commands you have given me so far.","Am anulat tot sirul de comenzi date pina acum.")
call StoreString(translation,language,"I will Stop any current Attack.","Anulez orice atac pe care il fac.")
call StoreString(translation,language,"I will not Attack Anything.","Nu voi ataca nimic.")
call StoreString(translation,language,"I will not Attack Creeps.","Nu voi ataca neutrii.")
call StoreString(translation,language,"I will not Attack Enemies.","Nu voi ataca pe inamici.")
call StoreString(translation,language,"I will build Air2Air units now.","Voi face unitati Aer-Aer acum.")
call StoreString(translation,language,"I will build Air2Ground units now.","Voi face unitati Aer-Sol acum.")
call StoreString(translation,language,"I will build Ground2Air units now.","Voi face unitati Sol-Aer acum.")
call StoreString(translation,language,"I will build Ground2Ground units now.","Voi face unitati Sol-Sol acum.")
call StoreString(translation,language,"I will build farms now.","Voi face ferme acum.")
call StoreString(translation,language,"I will build towers now.","Voi construii turnuri acum")
call StoreString(translation,language,"I will Attack/Guard the location of current screen position.","Voi Ataca/Apara locul determinat de pozitia ecranului.")
call StoreString(translation,language,"I will Attack/Guard the currently selected unit.","Voi Ataca/Apara unitatea selectata de tine.")
call StoreString(translation,language,"I will Attack/Guard the specified player.","Voi Ataca/Apara jucatorul specificat.")
call StoreString(translation,language,"I have Started or Restarted your Queued commands.","Am Inceput sau am Reinceput sirul tau de comenzi.")
call StoreString(translation,language,"I have Paused your Queued commands.","Am pus pauza sirului de comenzi.")
call StoreString(translation,language,"I have Unpaused your Queued commands.","Am pornit sirul de comenzi.")
call StoreString(translation,language,"I have Removed your last Queued command.","Am scos ultima comanda din sir")
call StoreString(translation,language,"I have Queued the Attack/Guard location of current screen position.","Am adaugat in sir comanda sa Atac/Apar locul determinat de ecran.")
call StoreString(translation,language,"I have Queued the currently selected unit to Attack/Guard.","Am adaugat in sir comanda sa Atac/Apar unitatea selectata.")
call StoreString(translation,language,"Turned On/Off Automatic Strategy Change.","Schimba On/Off schimbarea de strategie automata.")
call StoreString(translation,language,"Restrict","Restrictioneaza")
call StoreString(translation,language,"No Attacks","Fara atacuri")
call StoreString(translation,language,"No Creep Attacks","Fara atacuri asupra neutrilor")
call StoreString(translation,language,"No Enemy Attacks","Fara atacuri asupra inamicilor")
call StoreString(translation,language,"Farms","Ferme")
call StoreString(translation,language,"Towers","Turnuri")
call StoreString(translation,language,"Current screen","Ecranul Actual")
call StoreString(translation,language,"Selected unit","Unitatea Selectata")
call StoreString(translation,language,"Towerrush (Orc only)","Towerrush (numai Orc)")
call StoreString(translation,language,"Start/Restart","Incepe/Reincepe")
call StoreString(translation,language,"No Strategy Change","Fara schimbare de strategie")
call StoreString(translation,language,"Build","Produ")
call StoreString(translation,language,"Attack Here","Ataca Aici")
call StoreString(translation,language,"Unpause","Start")
call StoreString(translation,language,"Undo","Undo")
call StoreString(translation,language,"attack select","Ataca Unitate")
call StoreString(translation,language,"Air vs. Air","Aer vs. Aer")
call StoreString(translation,language,"Air vs. Ground","Aer vs. Sol")
call StoreString(translation,language,"Ground vs. Air","Sol vs. Aer")
call StoreString(translation,language,"Ground vs. Ground","Sol vs. Sol")
endfunction
function initLanguageRussian takes nothing returns nothing
set chat_no_ally="Я тебе никогда не подчинюсь! Только через мой труп."
set dlghdr_choose_ally="Выбрать союзника"
set dlghdr_choose_number="Выбрать номер"
set dlghdr_choose_player="Выбрать игрока"
set dlghdr_game_type="Выбрать тип игры"
set dlghdr_root="Выбрать команду"
set dlghdr_tribute_type="Выбрать тип"
set dlghdr_tribute_amount="Выбрать кол-во"
set dlgbutton_cancel="Отмена"
set dlgbutton_all="Все"
set dlgbutton_gold="Золото"
set dlgbutton_lumber="Древесина"
set dlgbutton_give_gold="Дать золота"
set dlgbutton_give_lumber="Дать древисины"
set dlgbutton_tribute="Обмен ресурса"
set dlgbutton_commander="Командир"
set dlgbutton_no_human="Только AI"
set dlgbutton_ai_only="Без командира"
call StoreString(translation,language,"AI Setting","Настройки AI")
call StoreString(translation,language,"Chatter","Чат")
call StoreString(translation,language,"Turned On/Off Computer Chatter.","Включить / выключить чат компьютера.")
call StoreString(translation,language,"Turned On/Off Debug Mode.","Включить / выключить дебаг режим.")
call StoreString(translation,language,"Turned On/Off Balancing Mode.","Включить / выключить режим балансирования.")
call StoreString(translation,language,"Show","Показать.")
call StoreString(translation,language,"Current Strategy","Данная стратегия.")
call StoreString(translation,language,"Showing current strategy.","Показываю данную стратегию.")
call StoreString(translation,language,"Strategy names","Названия стратегий")
call StoreString(translation,language,"Change Strategy","Сменить стратегию.")
call StoreString(translation,language,"Changes current strategy.","Меняю стратегию.")
call StoreString(translation,language,"Cancel Orders","Отменить приказы.")
call StoreString(translation,language,"All Orders","Все приказы")
call StoreString(translation,language,"I have Canceled All commands you have given me so far.","Я отменил все приказы, которые ты мне давал.")
call StoreString(translation,language,"Attack Orders","Атаковать.")
call StoreString(translation,language,"I have Canceled all Attack commands you have given me so far.","Я отменил все приказы атак, которые ты мне давал.")
call StoreString(translation,language,"Build Orders","Строить.")
call StoreString(translation,language,"I have Canceled all Build commands you have given me so far.","Я отменил все приказы по поводу строительства, которые ты мне давал.")
call StoreString(translation,language,"Queue","Очередь.")
call StoreString(translation,language,"I have Canceled all Queued commands you have given me so far.","Я отменил все приказы в очереди.")
call StoreString(translation,language,"I will Stop any current Attack.","Я прекращаю атаку.")
call StoreString(translation,language,"I will not Attack Anything.","Я никого не буду атаковать.")
call StoreString(translation,language,"I will not Attack Creeps.","Я не буду бить бомжей.")
call StoreString(translation,language,"I will not Attack Enemies.","Я не буду атаковать врагов.")
call StoreString(translation,language,"I will build Air2Air units now.","Я буду строить юнитов воздух-воздух теперь.")
call StoreString(translation,language,"I will build Air2Ground units now.","Я буду делать воздух-землю.")
call StoreString(translation,language,"I will build Ground2Air units now.","Я буду строить земля-воздух сейчас.")
call StoreString(translation,language,"I will build Ground2Ground units now.","Делаю землю-землю.")
call StoreString(translation,language,"I will build farms now.","Строю фермы.")
call StoreString(translation,language,"I will build towers now.","Строю башни.")
call StoreString(translation,language,"I will Attack/Guard the location of current screen position.","Буду охранять / атаковать данное положение экрана.")
call StoreString(translation,language,"I will Attack/Guard the currently selected unit.","Я буду атаковать / защищать выбранного юнита.")
call StoreString(translation,language,"I will Attack/Guard the specified player.","Я буду атаковать / защищать выбранного игрока.")
call StoreString(translation,language,"I have Started or Restarted your Queued commands.","Я начал выполнять очередь команд.")
call StoreString(translation,language,"I have Paused your Queued commands.","Я отложил приказы в очереди.")
call StoreString(translation,language,"I have Unpaused your Queued commands.","Я снова выполняю приказы в очереди.")
call StoreString(translation,language,"I have Removed your last Queued command.","Убрал последнею в очереди команду.")
call StoreString(translation,language,"I have Queued the Attack/Guard location of current screen position.","Приказание защищать / атаковать данное положение экрана в очереди.")
call StoreString(translation,language,"I have Queued the currently selected unit to Attack/Guard.","Приказание защищать / атаковать выбранного юнита в очереди.")
call StoreString(translation,language,"Turned On/Off Automatic Strategy Change.","Включил / выключил автоматический выбор стратегий.")
call StoreString(translation,language,"Restrict","Запретить.")
call StoreString(translation,language,"No Attacks","Не атаковать.")
call StoreString(translation,language,"No Creep Attacks","Не атаковать крипов.")
call StoreString(translation,language,"No Enemy Attacks","Не атаковать врагов.")
call StoreString(translation,language,"Farms","Фермы")
call StoreString(translation,language,"Towers","Башни")
call StoreString(translation,language,"Current screen","Вид экрана")
call StoreString(translation,language,"Selected unit","Выбр. юнит.")
call StoreString(translation,language,"Towerrush (Orc only)","Товерраш (только для орка)")
call StoreString(translation,language,"Start/Restart","Начать.")
call StoreString(translation,language,"No Strategy Change","Не менять.")
call StoreString(translation,language,"Build","Строить.")
call StoreString(translation,language,"Attack Here","Атаковать тут.")
call StoreString(translation,language,"Unpause","Снять с паузы.")
call StoreString(translation,language,"Undo","Назад.")
call StoreString(translation,language,"attack select","Выбор атаки.")
call StoreString(translation,language,"Air vs. Air","Воздух-воздух.")
call StoreString(translation,language,"Air vs. Ground","Воздух-земля.")
call StoreString(translation,language,"Ground vs. Air","Земля-воздух.")
call StoreString(translation,language,"Ground vs. Ground","Земля-земля.")
endfunction
function initLanguagePortuguese takes nothing returns nothing
set chat_no_ally="Nunca vou te obedecer."
set dlghdr_choose_ally="Aliado Escolhido"
set dlghdr_choose_number="Escolha Número"
set dlghdr_choose_player="Escolha Jogador"
set dlghdr_game_type="Escolha Tipo de Jogo"
set dlghdr_root="Escolha Comando"
set dlghdr_tribute_type="Escolha Tipo de Tributo"
set dlghdr_tribute_amount="Escolha Quantidade"
set dlgbutton_cancel="Cancelar"
set dlgbutton_all="Todos"
set dlgbutton_gold="Ouro"
set dlgbutton_lumber="Madeira"
set dlgbutton_give_gold="Dar Ouro"
set dlgbutton_give_lumber="Dar Madeira"
set dlgbutton_tribute="Tribute"
set dlgbutton_commander="Comandante"
set dlgbutton_no_human="Computador Apenas"
set dlgbutton_ai_only="Sem Comandante"
endfunction
function initLanguageNorwegian takes nothing returns nothing
set chat_no_ally="Jeg går ikke etter dine ordre!"
set dlghdr_choose_ally="Velg din allierte"
set dlghdr_choose_number="Velg nummer"
set dlghdr_choose_player="Velg spillere"
set dlghdr_game_type="Velg spilletype"
set dlghdr_root="Velg kommando"
set dlghdr_tribute_type="Valg bidragsmetode"
set dlghdr_tribute_amount="Velg bidragsstørrelse"
set dlgbutton_cancel="Avbryt"
set dlgbutton_all="Alle"
set dlgbutton_gold="Gull"
set dlgbutton_lumber="Trær"
set dlgbutton_tribute="Bidrag"
set dlgbutton_commander="Commander"
set dlgbutton_no_human="Bare computere"
set dlgbutton_ai_only="Ingen Commander"
call StoreString(translation,language,"AI Setting","AI Innstillinger")
call StoreString(translation,language,"Chatter","Chat")
call StoreString(translation,language,"Turned On/Off Computer Chatter.","Skru av / på computer chatting.")
call StoreString(translation,language,"Turned On/Off Debug Mode.","Skru av / på feilsøkingsmodus")
call StoreString(translation,language,"Turned On/Off Balancing Mode.","Skru av / på balanserings modus")
call StoreString(translation,language,"Show","Vise")
call StoreString(translation,language,"Current Strategy","Aktuell strategi")
call StoreString(translation,language,"Showing current strategy.","Viser aktuell strategi.")
call StoreString(translation,language,"Strategy names","Strateginavn")
call StoreString(translation,language,"Change Strategy","Bytt strategi")
call StoreString(translation,language,"Changes current strategy.","Bytter aktuell strategi.")
call StoreString(translation,language,"Cancel Orders","Avbryt order")
call StoreString(translation,language,"All Orders","Alle ordrer")
call StoreString(translation,language,"I have Canceled All commands you have given me so far.","Jeg har avbrutt alle kommandoer")
call StoreString(translation,language,"Attack Orders","Angrepskommandoer")
call StoreString(translation,language,"I have Canceled all Attack commands you have given me so far.","Jeg har avbrutt alle angrepskommandoer.")
call StoreString(translation,language,"Build Orders","Byggekommandoer")
call StoreString(translation,language,"I have Canceled all Build commands you have given me so far.","Jag har avbrutt alla byggekommandoer.")
call StoreString(translation,language,"Queue","Følgekommandoer")
call StoreString(translation,language,"I have Canceled all Queued commands you have given me so far.","Jag har avbrutt alla Følgekommandoer.")
call StoreString(translation,language,"I will Stop any current Attack.","")
call StoreString(translation,language,"I will not Attack Anything.","")
call StoreString(translation,language,"I will not Attack Creeps.","")
call StoreString(translation,language,"I will not Attack Enemies.","")
call StoreString(translation,language,"I will build Air2Air units now.","")
call StoreString(translation,language,"I will build Air2Ground units now.","")
call StoreString(translation,language,"I will build Ground2Air units now.","")
call StoreString(translation,language,"I will build Ground2Ground units now.","")
call StoreString(translation,language,"I will build farms now.","")
call StoreString(translation,language,"I will build towers now.","")
call StoreString(translation,language,"I will Attack/Guard the location of current screen position.","")
call StoreString(translation,language,"I will Attack/Guard the currently selected unit.","")
call StoreString(translation,language,"I will Attack/Guard the specified player.","")
call StoreString(translation,language,"I have Started or Restarted your Queued commands.","")
call StoreString(translation,language,"I have Paused your Queued commands.","")
call StoreString(translation,language,"I have Unpaused your Queued commands.","")
call StoreString(translation,language,"I have Removed your last Queued command.","")
call StoreString(translation,language,"I have Queued the Attack/Guard location of current screen position.","")
call StoreString(translation,language,"I have Queued the currently selected unit to Attack/Guard.","")
call StoreString(translation,language,"Turned On/Off Automatic Strategy Change.","")
call StoreString(translation,language,"Restrict","")
call StoreString(translation,language,"No Attacks","")
call StoreString(translation,language,"No Creep Attacks","")
call StoreString(translation,language,"No Enemy Attacks","")
call StoreString(translation,language,"Farms","")
call StoreString(translation,language,"Towers","")
call StoreString(translation,language,"Current screen","")
call StoreString(translation,language,"Selected unit","")
call StoreString(translation,language,"Start/Restart","")
call StoreString(translation,language,"No Strategy Change","")
call StoreString(translation,language,"Build","")
call StoreString(translation,language,"Attack Here","")
call StoreString(translation,language,"Unpause","")
call StoreString(translation,language,"Undo","")
call StoreString(translation,language,"attack select","")
call StoreString(translation,language,"Air vs. Air","")
call StoreString(translation,language,"Air vs. Ground","")
call StoreString(translation,language,"Ground vs. Air","")
call StoreString(translation,language,"Ground vs. Ground","")
endfunction
function initLanguageChinese takes nothing returns nothing
set chat_no_ally=""
set dlghdr_choose_ally="Ñ¡ÔñÃËÓÑ"
set dlghdr_choose_number="Ñ¡Ôñ¶ÓÎé"
set dlghdr_choose_player="Ñ¡Ôñ¶ÓÓÑ"
set dlghdr_game_type="Ñ¡ÔñÓÎÏ·ÀàÐÍ"
set dlghdr_root=""
set dlghdr_tribute_type="Ñ¡Ôñ×ÊÔ´ÀàÐÍ"
set dlghdr_tribute_amount="Ñ¡Ôñ×ÊÔ´ÊýÁ¿"
set dlgbutton_cancel="È¡Ïû"
set dlgbutton_all="All"
set dlgbutton_gold="Gold"
set dlgbutton_lumber="Ä¾²Ä"
set dlgbutton_give_gold="¸ø½ð¿ó"
set dlgbutton_give_lumber="¸øÄ¾²Ä"
set dlgbutton_tribute="×ÊÔ´"
set dlgbutton_commander="Ö¸»ÓÄ£Ê½"
set dlgbutton_no_human="³£¹æÄ£Ê½"
set dlgbutton_ai_only="ÖÇÄÜÄ£Ê½"
endfunction
function LanguageDlgResponse takes nothing returns nothing
local button b=GetClickedButton()
if b==English_button then
set language="English"
call SendToAllAIs(71,0)
call initLanguageEnglish()
elseif b==Deutsch_button then
set language="Deutsch"
call SendToAllAIs(71,1)
call initLanguageDeutsch()
elseif b==Swedish_button then
set language="Swedish"
call SendToAllAIs(71,2)
call initLanguageSwedish()
elseif b==French_button then
set language="French"
call SendToAllAIs(71,3)
call initLanguageFrench()
elseif b==Spanish_button then
set language="Spanish"
call SendToAllAIs(71,4)
call initLanguageSpanish()
elseif b==Romanian_button then
set language="Romanian"
call SendToAllAIs(71,5)
call initLanguageRomanian()
elseif b==Russian_button then
set language="Russian"
call SendToAllAIs(71,6)
call initLanguageRussian()
elseif b==Portuguese_button then
set language="Portuguese"
call SendToAllAIs(71,7)
call initLanguagePortuguese()
elseif b==Norwegian_button then
set language="Norwegian"
call SendToAllAIs(71,8)
call initLanguageNorwegian()
elseif b==Chinese_button then
set language="Chinese"
call SendToAllAIs(71,9)
call initLanguageChinese()
endif
call PauseAllUnitsBJ(false)
call GameStartDlg()
endfunction
function LanguageDefault takes nothing returns nothing
if language=="English" then
call SendToAllAIs(71,0)
call initLanguageEnglish()
elseif language=="Deutsch" then
call SendToAllAIs(71,1)
call initLanguageDeutsch()
elseif language=="Swedish" then
call SendToAllAIs(71,2)
call initLanguageSwedish()
elseif language=="French" then
call SendToAllAIs(71,3)
call initLanguageFrench()
elseif language=="Spanish" then
call SendToAllAIs(71,4)
call initLanguageSpanish()
elseif language=="Romanian" then
call SendToAllAIs(71,5)
call initLanguageRomanian()
elseif language=="Russian" then
call SendToAllAIs(71,6)
call initLanguageRussian()
elseif language=="Portuguese" then
call SendToAllAIs(71,7)
call initLanguagePortuguese()
elseif language=="Norwegian" then
call SendToAllAIs(71,8)
call initLanguageNorwegian()
elseif language=="Chinese" then
call SendToAllAIs(71,9)
call initLanguageChinese()
endif
call PauseAllUnitsBJ(false)
call GameStartDlg()
endfunction
function LanguageDlg takes nothing returns nothing
local integer host=GetFirstHuman()
call PauseAllUnitsBJ(true)
if language!="" or host==-1 then
call LanguageDefault()
return
endif
set language_dialog=DialogCreate()
call DialogSetMessage(language_dialog,"Choose Language")
set English_button=DialogAddButton(language_dialog,"English",69)
set Deutsch_button=DialogAddButton(language_dialog,"Deutsch",68)
set Swedish_button=DialogAddButton(language_dialog,"Swedish",83)
set French_button=DialogAddButton(language_dialog,"French",70)
set Spanish_button=DialogAddButton(language_dialog,"Spanish",80)
set Romanian_button=DialogAddButton(language_dialog,"Romanian",82)
set Russian_button=DialogAddButton(language_dialog,"Russian",85)
set Portuguese_button=DialogAddButton(language_dialog,"Portuguese",84)
set Norwegian_button=DialogAddButton(language_dialog,"Norwegian",78)
set Chinese_button=DialogAddButton(language_dialog,"Chinese",67)
set language_trigger=CreateTrigger()
call TriggerRegisterDialogEvent(language_trigger,language_dialog)
call TriggerAddAction(language_trigger,function LanguageDlgResponse)
call DialogDisplay(Player(host),language_dialog,true)
endfunction
function InitCommander takes nothing returns nothing
local timer t=CreateTimer()
call TimerStart(t,1.0,false,function LanguageDlg)
endfunction
function SetDNCSoundsDawn takes nothing returns nothing
if bj_useDawnDuskSounds then
call StartSound(bj_dawnSound)
endif
endfunction
function SetDNCSoundsDusk takes nothing returns nothing
if bj_useDawnDuskSounds then
call StartSound(bj_duskSound)
endif
endfunction
function SetDNCSoundsDay takes nothing returns nothing
local real ToD=GetTimeOfDay()
if(ToD>=bj_TOD_DAWN and ToD<bj_TOD_DUSK)and not bj_dncIsDaytime then
set bj_dncIsDaytime=true
call StopSound(bj_nightAmbientSound,false,true)
call StartSound(bj_dayAmbientSound)
endif
endfunction
function SetDNCSoundsNight takes nothing returns nothing
local real ToD=GetTimeOfDay()
if(ToD<bj_TOD_DAWN or ToD>=bj_TOD_DUSK)and bj_dncIsDaytime then
set bj_dncIsDaytime=false
call StopSound(bj_dayAmbientSound,false,true)
call StartSound(bj_nightAmbientSound)
endif
endfunction
function InitDNCSounds takes nothing returns nothing
set bj_dawnSound=CreateSoundFromLabel("RoosterSound",false,false,false,10000,10000)
set bj_duskSound=CreateSoundFromLabel("WolfSound",false,false,false,10000,10000)
set bj_dncSoundsDawn=CreateTrigger()
call TriggerRegisterGameStateEvent(bj_dncSoundsDawn,GAME_STATE_TIME_OF_DAY,EQUAL,bj_TOD_DAWN)
call TriggerAddAction(bj_dncSoundsDawn,function SetDNCSoundsDawn)
set bj_dncSoundsDusk=CreateTrigger()
call TriggerRegisterGameStateEvent(bj_dncSoundsDusk,GAME_STATE_TIME_OF_DAY,EQUAL,bj_TOD_DUSK)
call TriggerAddAction(bj_dncSoundsDusk,function SetDNCSoundsDusk)
set bj_dncSoundsDay=CreateTrigger()
call TriggerRegisterGameStateEvent(bj_dncSoundsDay,GAME_STATE_TIME_OF_DAY,GREATER_THAN_OR_EQUAL,bj_TOD_DAWN)
call TriggerRegisterGameStateEvent(bj_dncSoundsDay,GAME_STATE_TIME_OF_DAY,LESS_THAN,bj_TOD_DUSK)
call TriggerAddAction(bj_dncSoundsDay,function SetDNCSoundsDay)
set bj_dncSoundsNight=CreateTrigger()
call TriggerRegisterGameStateEvent(bj_dncSoundsNight,GAME_STATE_TIME_OF_DAY,LESS_THAN,bj_TOD_DAWN)
call TriggerRegisterGameStateEvent(bj_dncSoundsNight,GAME_STATE_TIME_OF_DAY,GREATER_THAN_OR_EQUAL,bj_TOD_DUSK)
call TriggerAddAction(bj_dncSoundsNight,function SetDNCSoundsNight)
endfunction
function InitBlizzardGlobals takes nothing returns nothing
local integer index
local integer userControlledPlayers
local version v
set filterIssueHauntOrderAtLocBJ=Filter(function IssueHauntOrderAtLocBJFilter)
set filterEnumDestructablesInCircleBJ=Filter(function EnumDestructablesInCircleBJFilter)
set filterGetUnitsInRectOfPlayer=Filter(function GetUnitsInRectOfPlayerFilter)
set filterGetUnitsOfTypeIdAll=Filter(function GetUnitsOfTypeIdAllFilter)
set filterGetUnitsOfPlayerAndTypeId=Filter(function GetUnitsOfPlayerAndTypeIdFilter)
set filterMeleeTrainedUnitIsHeroBJ=Filter(function MeleeTrainedUnitIsHeroBJFilter)
set filterLivingPlayerUnitsOfTypeId=Filter(function LivingPlayerUnitsOfTypeIdFilter)
set index=0
loop
exitwhen index==bj_MAX_PLAYER_SLOTS
set bj_FORCE_PLAYER[index]=CreateForce()
call ForceAddPlayer(bj_FORCE_PLAYER[index],Player(index))
set index=index+1
endloop
set bj_FORCE_ALL_PLAYERS=CreateForce()
call ForceEnumPlayers(bj_FORCE_ALL_PLAYERS,null)
set bj_cineModePriorSpeed=GetGameSpeed()
set bj_cineModePriorFogSetting=IsFogEnabled()
set bj_cineModePriorMaskSetting=IsFogMaskEnabled()
set index=0
loop
exitwhen index>=bj_MAX_QUEUED_TRIGGERS
set bj_queuedExecTriggers[index]=null
set bj_queuedExecUseConds[index]=false
set index=index+1
endloop
set bj_isSinglePlayer=false
set userControlledPlayers=0
set index=0
loop
exitwhen index>=bj_MAX_PLAYERS
if(GetPlayerController(Player(index))==MAP_CONTROL_USER and GetPlayerSlotState(Player(index))==PLAYER_SLOT_STATE_PLAYING)then
set userControlledPlayers=userControlledPlayers+1
endif
set index=index+1
endloop
set bj_isSinglePlayer=(userControlledPlayers==1)
set bj_rescueSound=CreateSoundFromLabel("Rescue",false,false,false,10000,10000)
set bj_questDiscoveredSound=CreateSoundFromLabel("QuestNew",false,false,false,10000,10000)
set bj_questUpdatedSound=CreateSoundFromLabel("QuestUpdate",false,false,false,10000,10000)
set bj_questCompletedSound=CreateSoundFromLabel("QuestCompleted",false,false,false,10000,10000)
set bj_questFailedSound=CreateSoundFromLabel("QuestFailed",false,false,false,10000,10000)
set bj_questHintSound=CreateSoundFromLabel("Hint",false,false,false,10000,10000)
set bj_questSecretSound=CreateSoundFromLabel("SecretFound",false,false,false,10000,10000)
set bj_questItemAcquiredSound=CreateSoundFromLabel("ItemReward",false,false,false,10000,10000)
set bj_questWarningSound=CreateSoundFromLabel("Warning",false,false,false,10000,10000)
set bj_victoryDialogSound=CreateSoundFromLabel("QuestCompleted",false,false,false,10000,10000)
set bj_defeatDialogSound=CreateSoundFromLabel("QuestFailed",false,false,false,10000,10000)
call DelayedSuspendDecayCreate()
set v=VersionGet()
if(v==VERSION_REIGN_OF_CHAOS)then
set bj_MELEE_MAX_TWINKED_HEROES=bj_MELEE_MAX_TWINKED_HEROES_V0
else
set bj_MELEE_MAX_TWINKED_HEROES=bj_MELEE_MAX_TWINKED_HEROES_V1
endif
endfunction
function InitQueuedTriggers takes nothing returns nothing
set bj_queuedExecTimeout=CreateTrigger()
call TriggerRegisterTimerExpireEvent(bj_queuedExecTimeout,bj_queuedExecTimeoutTimer)
call TriggerAddAction(bj_queuedExecTimeout,function QueuedTriggerDoneBJ)
endfunction
function InitMapRects takes nothing returns nothing
set bj_mapInitialPlayableArea=Rect(GetCameraBoundMinX()-GetCameraMargin(CAMERA_MARGIN_LEFT),GetCameraBoundMinY()-GetCameraMargin(CAMERA_MARGIN_BOTTOM),GetCameraBoundMaxX()+GetCameraMargin(CAMERA_MARGIN_RIGHT),GetCameraBoundMaxY()+GetCameraMargin(CAMERA_MARGIN_TOP))
set bj_mapInitialCameraBounds=GetCurrentCameraBoundsMapRectBJ()
endfunction
function InitSummonableCaps takes nothing returns nothing
local integer index
set index=0
loop
if(not GetPlayerTechResearched(Player(index),'Rhrt',true))then
call SetPlayerTechMaxAllowed(Player(index),'hrtt',0)
endif
if(not GetPlayerTechResearched(Player(index),'Robk',true))then
call SetPlayerTechMaxAllowed(Player(index),'otbk',0)
endif
call SetPlayerTechMaxAllowed(Player(index),'uske',bj_MAX_SKELETONS)
set index=index+1
exitwhen index==bj_MAX_PLAYERS
endloop
endfunction
function UpdateStockAvailability takes item whichItem returns nothing
local itemtype iType=GetItemType(whichItem)
local integer iLevel=GetItemLevel(whichItem)
if(iType==ITEM_TYPE_PERMANENT)then
set bj_stockAllowedPermanent[iLevel]=true
elseif(iType==ITEM_TYPE_CHARGED)then
set bj_stockAllowedCharged[iLevel]=true
elseif(iType==ITEM_TYPE_ARTIFACT)then
set bj_stockAllowedArtifact[iLevel]=true
else
endif
endfunction
function UpdateEachStockBuildingEnum takes nothing returns nothing
local integer iteration=0
local integer pickedItemId
loop
set pickedItemId=ChooseRandomItemEx(bj_stockPickedItemType,bj_stockPickedItemLevel)
exitwhen IsItemIdSellable(pickedItemId)
set iteration=iteration+1
if(iteration>bj_STOCK_MAX_ITERATIONS)then
return
endif
endloop
call AddItemToStock(GetEnumUnit(),pickedItemId,1,1)
endfunction
function UpdateEachStockBuilding takes itemtype iType,integer iLevel returns nothing
local group g
set bj_stockPickedItemType=iType
set bj_stockPickedItemLevel=iLevel
set g=CreateGroup()
call GroupEnumUnitsOfType(g,"marketplace",null)
call ForGroup(g,function UpdateEachStockBuildingEnum)
call DestroyGroup(g)
endfunction
function PerformStockUpdates takes nothing returns nothing
local integer pickedItemId
local itemtype pickedItemType
local integer pickedItemLevel=0
local integer allowedCombinations=0
local integer iLevel
set iLevel=1
loop
if(bj_stockAllowedPermanent[iLevel])then
set allowedCombinations=allowedCombinations+1
if(GetRandomInt(1,allowedCombinations)==1)then
set pickedItemType=ITEM_TYPE_PERMANENT
set pickedItemLevel=iLevel
endif
endif
if(bj_stockAllowedCharged[iLevel])then
set allowedCombinations=allowedCombinations+1
if(GetRandomInt(1,allowedCombinations)==1)then
set pickedItemType=ITEM_TYPE_CHARGED
set pickedItemLevel=iLevel
endif
endif
if(bj_stockAllowedArtifact[iLevel])then
set allowedCombinations=allowedCombinations+1
if(GetRandomInt(1,allowedCombinations)==1)then
set pickedItemType=ITEM_TYPE_ARTIFACT
set pickedItemLevel=iLevel
endif
endif
set iLevel=iLevel+1
exitwhen iLevel>bj_MAX_ITEM_LEVEL
endloop
if(allowedCombinations==0)then
return
endif
call UpdateEachStockBuilding(pickedItemType,pickedItemLevel)
endfunction
function StartStockUpdates takes nothing returns nothing
call PerformStockUpdates()
call TimerStart(bj_stockUpdateTimer,bj_STOCK_RESTOCK_INTERVAL,true,function PerformStockUpdates)
endfunction
function RemovePurchasedItem takes nothing returns nothing
call RemoveItemFromStock(GetSellingUnit(),GetItemTypeId(GetSoldItem()))
endfunction
function InitNeutralBuildings takes nothing returns nothing
local integer iLevel
set iLevel=0
loop
set bj_stockAllowedPermanent[iLevel]=false
set bj_stockAllowedCharged[iLevel]=false
set bj_stockAllowedArtifact[iLevel]=false
set iLevel=iLevel+1
exitwhen iLevel>bj_MAX_ITEM_LEVEL
endloop
call SetAllItemTypeSlots(bj_MAX_STOCK_ITEM_SLOTS)
call SetAllUnitTypeSlots(bj_MAX_STOCK_UNIT_SLOTS)
set bj_stockUpdateTimer=CreateTimer()
call TimerStart(bj_stockUpdateTimer,bj_STOCK_RESTOCK_INITIAL_DELAY,false,function StartStockUpdates)
set bj_stockItemPurchased=CreateTrigger()
call TriggerRegisterPlayerUnitEvent(bj_stockItemPurchased,Player(PLAYER_NEUTRAL_PASSIVE),EVENT_PLAYER_UNIT_SELL_ITEM,null)
call TriggerAddAction(bj_stockItemPurchased,function RemovePurchasedItem)
endfunction
function MarkGameStarted takes nothing returns nothing
set bj_gameStarted=true
call DestroyTimer(bj_gameStartedTimer)
endfunction
function DetectGameStarted takes nothing returns nothing
set bj_gameStartedTimer=CreateTimer()
call TimerStart(bj_gameStartedTimer,bj_GAME_STARTED_THRESHOLD,false,function MarkGameStarted)
endfunction
function InitBlizzard takes nothing returns nothing
call ConfigureNeutralVictim()
call InitBlizzardGlobals()
call InitQueuedTriggers()
call InitRescuableBehaviorBJ()
call InitDNCSounds()
call InitMapRects()
call InitSummonableCaps()
call InitNeutralBuildings()
call InitCommander()
call DetectGameStarted()
endfunction
function RandomDistReset takes nothing returns nothing
set bj_randDistCount=0
endfunction
function RandomDistAddItem takes integer inID,integer inChance returns nothing
set bj_randDistID[bj_randDistCount]=inID
set bj_randDistChance[bj_randDistCount]=inChance
set bj_randDistCount=bj_randDistCount+1
endfunction
function RandomDistChoose takes nothing returns integer
local integer sum=0
local integer chance=0
local integer index
local integer foundID=-1
local boolean done
if(bj_randDistCount==0)then
return-1
endif
set index=0
loop
set sum=sum+bj_randDistChance[index]
set index=index+1
exitwhen index==bj_randDistCount
endloop
set chance=GetRandomInt(1,sum)
set index=0
set sum=0
set done=false
loop
set sum=sum+bj_randDistChance[index]
if(chance<=sum)then
set foundID=bj_randDistID[index]
set done=true
endif
set index=index+1
if(index==bj_randDistCount)then
set done=true
endif
exitwhen done==true
endloop
return foundID
endfunction
function UnitDropItem takes unit inUnit,integer inItemID returns item
local real x
local real y
local real radius=32
local real unitX
local real unitY
local item droppedItem
if(inItemID==-1)then
return null
endif
set unitX=GetUnitX(inUnit)
set unitY=GetUnitY(inUnit)
set x=GetRandomReal(unitX-radius,unitX+radius)
set y=GetRandomReal(unitY-radius,unitY+radius)
set droppedItem=CreateItem(inItemID,x,y)
call SetItemDropID(droppedItem,GetUnitTypeId(inUnit))
call UpdateStockAvailability(droppedItem)
return droppedItem
endfunction
function WidgetDropItem takes widget inWidget,integer inItemID returns item
local real x
local real y
local real radius=32
local real widgetX
local real widgetY
if(inItemID==-1)then
return null
endif
set widgetX=GetWidgetX(inWidget)
set widgetY=GetWidgetY(inWidget)
set x=GetRandomReal(widgetX-radius,widgetX+radius)
set y=GetRandomReal(widgetY-radius,widgetY+radius)
return CreateItem(inItemID,x,y)
endfunction
